<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for belegungskalenderdatapos StructType
 * @subpackage Structs
 */
class Belegungskalenderdatapos extends AbstractStructBase
{
    /**
     * The ortid
     * @var int
     */
    public $ortid;
    /**
     * The hausid
     * @var int
     */
    public $hausid;
    /**
     * The katid
     * @var int
     */
    public $katid;
    /**
     * The datum
     * @var string
     */
    public $datum;
    /**
     * The anreise
     * @var int
     */
    public $anreise;
    /**
     * The abreise
     * @var int
     */
    public $abreise;
    /**
     * The mintage
     * @var int
     */
    public $mintage;
    /**
     * The minvorbuchung
     * @var int
     */
    public $minvorbuchung;
    /**
     * The belegunganzahl
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Belegungskalenderdataposanzahl[]
     */
    public $belegunganzahl;
    /**
     * Constructor method for belegungskalenderdatapos
     * @uses Belegungskalenderdatapos::setOrtid()
     * @uses Belegungskalenderdatapos::setHausid()
     * @uses Belegungskalenderdatapos::setKatid()
     * @uses Belegungskalenderdatapos::setDatum()
     * @uses Belegungskalenderdatapos::setAnreise()
     * @uses Belegungskalenderdatapos::setAbreise()
     * @uses Belegungskalenderdatapos::setMintage()
     * @uses Belegungskalenderdatapos::setMinvorbuchung()
     * @uses Belegungskalenderdatapos::setBelegunganzahl()
     * @param int $ortid
     * @param int $hausid
     * @param int $katid
     * @param string $datum
     * @param int $anreise
     * @param int $abreise
     * @param int $mintage
     * @param int $minvorbuchung
     * @param \StructType\Belegungskalenderdataposanzahl[] $belegunganzahl
     */
    public function __construct($ortid = null, $hausid = null, $katid = null, $datum = null, $anreise = null, $abreise = null, $mintage = null, $minvorbuchung = null, array $belegunganzahl = array())
    {
        $this
            ->setOrtid($ortid)
            ->setHausid($hausid)
            ->setKatid($katid)
            ->setDatum($datum)
            ->setAnreise($anreise)
            ->setAbreise($abreise)
            ->setMintage($mintage)
            ->setMinvorbuchung($minvorbuchung)
            ->setBelegunganzahl($belegunganzahl);
    }
    /**
     * Get ortid value
     * @return int|null
     */
    public function getOrtid()
    {
        return $this->ortid;
    }
    /**
     * Set ortid value
     * @param int $ortid
     * @return \StructType\Belegungskalenderdatapos
     */
    public function setOrtid($ortid = null)
    {
        // validation for constraint: int
        if (!is_null($ortid) && !(is_int($ortid) || ctype_digit($ortid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ortid, true), gettype($ortid)), __LINE__);
        }
        $this->ortid = $ortid;
        return $this;
    }
    /**
     * Get hausid value
     * @return int|null
     */
    public function getHausid()
    {
        return $this->hausid;
    }
    /**
     * Set hausid value
     * @param int $hausid
     * @return \StructType\Belegungskalenderdatapos
     */
    public function setHausid($hausid = null)
    {
        // validation for constraint: int
        if (!is_null($hausid) && !(is_int($hausid) || ctype_digit($hausid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hausid, true), gettype($hausid)), __LINE__);
        }
        $this->hausid = $hausid;
        return $this;
    }
    /**
     * Get katid value
     * @return int|null
     */
    public function getKatid()
    {
        return $this->katid;
    }
    /**
     * Set katid value
     * @param int $katid
     * @return \StructType\Belegungskalenderdatapos
     */
    public function setKatid($katid = null)
    {
        // validation for constraint: int
        if (!is_null($katid) && !(is_int($katid) || ctype_digit($katid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($katid, true), gettype($katid)), __LINE__);
        }
        $this->katid = $katid;
        return $this;
    }
    /**
     * Get datum value
     * @return string|null
     */
    public function getDatum()
    {
        return $this->datum;
    }
    /**
     * Set datum value
     * @param string $datum
     * @return \StructType\Belegungskalenderdatapos
     */
    public function setDatum($datum = null)
    {
        // validation for constraint: string
        if (!is_null($datum) && !is_string($datum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datum, true), gettype($datum)), __LINE__);
        }
        $this->datum = $datum;
        return $this;
    }
    /**
     * Get anreise value
     * @return int|null
     */
    public function getAnreise()
    {
        return $this->anreise;
    }
    /**
     * Set anreise value
     * @param int $anreise
     * @return \StructType\Belegungskalenderdatapos
     */
    public function setAnreise($anreise = null)
    {
        // validation for constraint: int
        if (!is_null($anreise) && !(is_int($anreise) || ctype_digit($anreise))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anreise, true), gettype($anreise)), __LINE__);
        }
        $this->anreise = $anreise;
        return $this;
    }
    /**
     * Get abreise value
     * @return int|null
     */
    public function getAbreise()
    {
        return $this->abreise;
    }
    /**
     * Set abreise value
     * @param int $abreise
     * @return \StructType\Belegungskalenderdatapos
     */
    public function setAbreise($abreise = null)
    {
        // validation for constraint: int
        if (!is_null($abreise) && !(is_int($abreise) || ctype_digit($abreise))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($abreise, true), gettype($abreise)), __LINE__);
        }
        $this->abreise = $abreise;
        return $this;
    }
    /**
     * Get mintage value
     * @return int|null
     */
    public function getMintage()
    {
        return $this->mintage;
    }
    /**
     * Set mintage value
     * @param int $mintage
     * @return \StructType\Belegungskalenderdatapos
     */
    public function setMintage($mintage = null)
    {
        // validation for constraint: int
        if (!is_null($mintage) && !(is_int($mintage) || ctype_digit($mintage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mintage, true), gettype($mintage)), __LINE__);
        }
        $this->mintage = $mintage;
        return $this;
    }
    /**
     * Get minvorbuchung value
     * @return int|null
     */
    public function getMinvorbuchung()
    {
        return $this->minvorbuchung;
    }
    /**
     * Set minvorbuchung value
     * @param int $minvorbuchung
     * @return \StructType\Belegungskalenderdatapos
     */
    public function setMinvorbuchung($minvorbuchung = null)
    {
        // validation for constraint: int
        if (!is_null($minvorbuchung) && !(is_int($minvorbuchung) || ctype_digit($minvorbuchung))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minvorbuchung, true), gettype($minvorbuchung)), __LINE__);
        }
        $this->minvorbuchung = $minvorbuchung;
        return $this;
    }
    /**
     * Get belegunganzahl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Belegungskalenderdataposanzahl[]|null
     */
    public function getBelegunganzahl()
    {
        return isset($this->belegunganzahl) ? $this->belegunganzahl : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBelegunganzahl method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBelegunganzahl method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBelegunganzahlForArrayConstraintsFromSetBelegunganzahl(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $belegungskalenderdataposBelegunganzahlItem) {
            // validation for constraint: itemType
            if (!$belegungskalenderdataposBelegunganzahlItem instanceof \StructType\Belegungskalenderdataposanzahl) {
                $invalidValues[] = is_object($belegungskalenderdataposBelegunganzahlItem) ? get_class($belegungskalenderdataposBelegunganzahlItem) : sprintf('%s(%s)', gettype($belegungskalenderdataposBelegunganzahlItem), var_export($belegungskalenderdataposBelegunganzahlItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The belegunganzahl property can only contain items of type \StructType\Belegungskalenderdataposanzahl, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set belegunganzahl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Belegungskalenderdataposanzahl[] $belegunganzahl
     * @return \StructType\Belegungskalenderdatapos
     */
    public function setBelegunganzahl(array $belegunganzahl = array())
    {
        // validation for constraint: array
        if ('' !== ($belegunganzahlArrayErrorMessage = self::validateBelegunganzahlForArrayConstraintsFromSetBelegunganzahl($belegunganzahl))) {
            throw new \InvalidArgumentException($belegunganzahlArrayErrorMessage, __LINE__);
        }
        if (is_null($belegunganzahl) || (is_array($belegunganzahl) && empty($belegunganzahl))) {
            unset($this->belegunganzahl);
        } else {
            $this->belegunganzahl = $belegunganzahl;
        }
        return $this;
    }
    /**
     * Add item to belegunganzahl value
     * @throws \InvalidArgumentException
     * @param \StructType\Belegungskalenderdataposanzahl $item
     * @return \StructType\Belegungskalenderdatapos
     */
    public function addToBelegunganzahl(\StructType\Belegungskalenderdataposanzahl $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Belegungskalenderdataposanzahl) {
            throw new \InvalidArgumentException(sprintf('The belegunganzahl property can only contain items of type \StructType\Belegungskalenderdataposanzahl, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->belegunganzahl[] = $item;
        return $this;
    }
}
