<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for anfrageprospekt StructType
 * @subpackage Structs
 */
class Anfrageprospekt extends AbstractStructBase
{
    /**
     * The prospektid
     * @var int
     */
    public $prospektid;
    /**
     * The anzahl
     * @var int
     */
    public $anzahl;
    /**
     * Constructor method for anfrageprospekt
     * @uses Anfrageprospekt::setProspektid()
     * @uses Anfrageprospekt::setAnzahl()
     * @param int $prospektid
     * @param int $anzahl
     */
    public function __construct($prospektid = null, $anzahl = null)
    {
        $this
            ->setProspektid($prospektid)
            ->setAnzahl($anzahl);
    }
    /**
     * Get prospektid value
     * @return int|null
     */
    public function getProspektid()
    {
        return $this->prospektid;
    }
    /**
     * Set prospektid value
     * @param int $prospektid
     * @return \StructType\Anfrageprospekt
     */
    public function setProspektid($prospektid = null)
    {
        // validation for constraint: int
        if (!is_null($prospektid) && !(is_int($prospektid) || ctype_digit($prospektid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($prospektid, true), gettype($prospektid)), __LINE__);
        }
        $this->prospektid = $prospektid;
        return $this;
    }
    /**
     * Get anzahl value
     * @return int|null
     */
    public function getAnzahl()
    {
        return $this->anzahl;
    }
    /**
     * Set anzahl value
     * @param int $anzahl
     * @return \StructType\Anfrageprospekt
     */
    public function setAnzahl($anzahl = null)
    {
        // validation for constraint: int
        if (!is_null($anzahl) && !(is_int($anzahl) || ctype_digit($anzahl))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahl, true), gettype($anzahl)), __LINE__);
        }
        $this->anzahl = $anzahl;
        return $this;
    }
}
