<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Traslados StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo opcional para asentar o referir los impuestos trasladados aplicables | Nodo condicional para capturar los impuestos trasladados aplicables. | Nodo condicional para capturar los impuestos trasladados aplicables. Es requerido
 * cuando en los conceptos se registre un impuesto trasladado. | Nodo opcional para asentar los impuestos trasladados aplicables al presente concepto.
 * @subpackage Structs
 */
class Traslados extends AbstractStructBase
{
    /**
     * The Traslado
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Traslado[]
     */
    public $Traslado;
    /**
     * Constructor method for Traslados
     * @uses Traslados::setTraslado()
     * @param \StructType\Traslado[] $traslado
     */
    public function __construct(array $traslado = array())
    {
        $this
            ->setTraslado($traslado);
    }
    /**
     * Get Traslado value
     * @return \StructType\Traslado[]|null
     */
    public function getTraslado()
    {
        return $this->Traslado;
    }
    /**
     * This method is responsible for validating the values passed to the setTraslado method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTraslado method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTrasladoForArrayConstraintsFromSetTraslado(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $trasladosTrasladoItem) {
            // validation for constraint: itemType
            if (!$trasladosTrasladoItem instanceof \StructType\Traslado) {
                $invalidValues[] = is_object($trasladosTrasladoItem) ? get_class($trasladosTrasladoItem) : sprintf('%s(%s)', gettype($trasladosTrasladoItem), var_export($trasladosTrasladoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Traslado property can only contain items of type \StructType\Traslado, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Traslado value
     * @throws \InvalidArgumentException
     * @param \StructType\Traslado[] $traslado
     * @return \StructType\Traslados
     */
    public function setTraslado(array $traslado = array())
    {
        // validation for constraint: array
        if ('' !== ($trasladoArrayErrorMessage = self::validateTrasladoForArrayConstraintsFromSetTraslado($traslado))) {
            throw new \InvalidArgumentException($trasladoArrayErrorMessage, __LINE__);
        }
        $this->Traslado = $traslado;
        return $this;
    }
    /**
     * Add item to Traslado value
     * @throws \InvalidArgumentException
     * @param \StructType\Traslado $item
     * @return \StructType\Traslados
     */
    public function addToTraslado(\StructType\Traslado $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Traslado) {
            throw new \InvalidArgumentException(sprintf('The Traslado property can only contain items of type \StructType\Traslado, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Traslado[] = $item;
        return $this;
    }
}
