<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for transport StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo requerido que especifica el pago de transporte de embalaje
 * @subpackage Structs
 */
class Transport extends AbstractStructBase
{
    /**
     * The methodOfPayment
     * @var string
     */
    public $methodOfPayment;
    /**
     * Constructor method for transport
     * @uses Transport::setMethodOfPayment()
     * @param string $methodOfPayment
     */
    public function __construct($methodOfPayment = null)
    {
        $this
            ->setMethodOfPayment($methodOfPayment);
    }
    /**
     * Get methodOfPayment value
     * @return string|null
     */
    public function getMethodOfPayment()
    {
        return $this->methodOfPayment;
    }
    /**
     * Set methodOfPayment value
     * @uses \EnumType\MethodOfPayment::valueIsValid()
     * @uses \EnumType\MethodOfPayment::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $methodOfPayment
     * @return \StructType\Transport
     */
    public function setMethodOfPayment($methodOfPayment = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MethodOfPayment::valueIsValid($methodOfPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\MethodOfPayment', is_array($methodOfPayment) ? implode(', ', $methodOfPayment) : var_export($methodOfPayment, true), implode(', ', \EnumType\MethodOfPayment::getValidValues())), __LINE__);
        }
        $this->methodOfPayment = $methodOfPayment;
        return $this;
    }
}
