<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tradeItemTaxInformation StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo opcional que especifica los impuestos por cada línea de artículo
 * @subpackage Structs
 */
class TradeItemTaxInformation extends AbstractStructBase
{
    /**
     * The referenceNumber
     * Meta information extracted from the WSDL
     * - documentation: Nodo opcional que especifica el numero de identificación del impuesto. Numero asignado al comprador por una jurisdicción de impuesto
     * - base: xs:string
     * - maxLength: 20
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $referenceNumber;
    /**
     * The taxCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxCategory;
    /**
     * The taxTypeDescription
     * @var string
     */
    public $taxTypeDescription;
    /**
     * The tradeItemTaxAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TradeItemTaxAmount
     */
    public $tradeItemTaxAmount;
    /**
     * Constructor method for tradeItemTaxInformation
     * @uses TradeItemTaxInformation::setReferenceNumber()
     * @uses TradeItemTaxInformation::setTaxCategory()
     * @uses TradeItemTaxInformation::setTaxTypeDescription()
     * @uses TradeItemTaxInformation::setTradeItemTaxAmount()
     * @param string $referenceNumber
     * @param string $taxCategory
     * @param string $taxTypeDescription
     * @param \StructType\TradeItemTaxAmount $tradeItemTaxAmount
     */
    public function __construct($referenceNumber = null, $taxCategory = null, $taxTypeDescription = null, \StructType\TradeItemTaxAmount $tradeItemTaxAmount = null)
    {
        $this
            ->setReferenceNumber($referenceNumber)
            ->setTaxCategory($taxCategory)
            ->setTaxTypeDescription($taxTypeDescription)
            ->setTradeItemTaxAmount($tradeItemTaxAmount);
    }
    /**
     * Get referenceNumber value
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->referenceNumber;
    }
    /**
     * Set referenceNumber value
     * @param string $referenceNumber
     * @return \StructType\TradeItemTaxInformation
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($referenceNumber) && mb_strlen($referenceNumber) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($referenceNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($referenceNumber) && mb_strlen($referenceNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($referenceNumber)), __LINE__);
        }
        $this->referenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get taxCategory value
     * @return string|null
     */
    public function getTaxCategory()
    {
        return $this->taxCategory;
    }
    /**
     * Set taxCategory value
     * @uses \EnumType\TaxCategory::valueIsValid()
     * @uses \EnumType\TaxCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $taxCategory
     * @return \StructType\TradeItemTaxInformation
     */
    public function setTaxCategory($taxCategory = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TaxCategory::valueIsValid($taxCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TaxCategory', is_array($taxCategory) ? implode(', ', $taxCategory) : var_export($taxCategory, true), implode(', ', \EnumType\TaxCategory::getValidValues())), __LINE__);
        }
        $this->taxCategory = $taxCategory;
        return $this;
    }
    /**
     * Get taxTypeDescription value
     * @return string|null
     */
    public function getTaxTypeDescription()
    {
        return $this->taxTypeDescription;
    }
    /**
     * Set taxTypeDescription value
     * @uses \EnumType\TaxTypeDescription::valueIsValid()
     * @uses \EnumType\TaxTypeDescription::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $taxTypeDescription
     * @return \StructType\TradeItemTaxInformation
     */
    public function setTaxTypeDescription($taxTypeDescription = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TaxTypeDescription::valueIsValid($taxTypeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TaxTypeDescription', is_array($taxTypeDescription) ? implode(', ', $taxTypeDescription) : var_export($taxTypeDescription, true), implode(', ', \EnumType\TaxTypeDescription::getValidValues())), __LINE__);
        }
        $this->taxTypeDescription = $taxTypeDescription;
        return $this;
    }
    /**
     * Get tradeItemTaxAmount value
     * @return \StructType\TradeItemTaxAmount|null
     */
    public function getTradeItemTaxAmount()
    {
        return $this->tradeItemTaxAmount;
    }
    /**
     * Set tradeItemTaxAmount value
     * @param \StructType\TradeItemTaxAmount $tradeItemTaxAmount
     * @return \StructType\TradeItemTaxInformation
     */
    public function setTradeItemTaxAmount(\StructType\TradeItemTaxAmount $tradeItemTaxAmount = null)
    {
        $this->tradeItemTaxAmount = $tradeItemTaxAmount;
        return $this;
    }
}
