<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tradeItemTaxAmount StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo opcional que especifica el importe o porcentaje del descuento
 * @subpackage Structs
 */
class TradeItemTaxAmount extends AbstractStructBase
{
    /**
     * The taxPercentage
     * Meta information extracted from the WSDL
     * - documentation: Nodo requerido que especifica el porcentaje del impuesto
     * @var float
     */
    public $taxPercentage;
    /**
     * The taxAmount
     * Meta information extracted from the WSDL
     * - documentation: Nodo requerido que especifica el monto del impuesto
     * @var float
     */
    public $taxAmount;
    /**
     * Constructor method for tradeItemTaxAmount
     * @uses TradeItemTaxAmount::setTaxPercentage()
     * @uses TradeItemTaxAmount::setTaxAmount()
     * @param float $taxPercentage
     * @param float $taxAmount
     */
    public function __construct($taxPercentage = null, $taxAmount = null)
    {
        $this
            ->setTaxPercentage($taxPercentage)
            ->setTaxAmount($taxAmount);
    }
    /**
     * Get taxPercentage value
     * @return float|null
     */
    public function getTaxPercentage()
    {
        return $this->taxPercentage;
    }
    /**
     * Set taxPercentage value
     * @param float $taxPercentage
     * @return \StructType\TradeItemTaxAmount
     */
    public function setTaxPercentage($taxPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($taxPercentage) && !(is_float($taxPercentage) || is_numeric($taxPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxPercentage, true), gettype($taxPercentage)), __LINE__);
        }
        $this->taxPercentage = $taxPercentage;
        return $this;
    }
    /**
     * Get taxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->taxAmount;
    }
    /**
     * Set taxAmount value
     * @param float $taxAmount
     * @return \StructType\TradeItemTaxAmount
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->taxAmount = $taxAmount;
        return $this;
    }
}
