<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tradeItemIdentification StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo requerido que especifica la identificación de cada artículo
 * @subpackage Structs
 */
class TradeItemIdentification extends AbstractStructBase
{
    /**
     * The gtin
     * Meta information extracted from the WSDL
     * - documentation: Nodo requerido que especifica el código EAN del artículo solicitado
     * - base: xs:string
     * - maxLength: 14
     * - minLength: 1
     * @var string
     */
    public $gtin;
    /**
     * Constructor method for tradeItemIdentification
     * @uses TradeItemIdentification::setGtin()
     * @param string $gtin
     */
    public function __construct($gtin = null)
    {
        $this
            ->setGtin($gtin);
    }
    /**
     * Get gtin value
     * @return string|null
     */
    public function getGtin()
    {
        return $this->gtin;
    }
    /**
     * Set gtin value
     * @param string $gtin
     * @return \StructType\TradeItemIdentification
     */
    public function setGtin($gtin = null)
    {
        // validation for constraint: string
        if (!is_null($gtin) && !is_string($gtin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gtin, true), gettype($gtin)), __LINE__);
        }
        // validation for constraint: maxLength(14)
        if (!is_null($gtin) && mb_strlen($gtin) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 14', mb_strlen($gtin)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($gtin) && mb_strlen($gtin) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($gtin)), __LINE__);
        }
        $this->gtin = $gtin;
        return $this;
    }
}
