<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tradeItemDescriptionInformation StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo opcional que especifica el inicio de la descripción del artículo
 * @subpackage Structs
 */
class TradeItemDescriptionInformation extends AbstractStructBase
{
    /**
     * The longText
     * Meta information extracted from the WSDL
     * - documentation: Nodo requerido que especifica la descripción del artículo solicitado
     * - base: xs:string
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $longText;
    /**
     * The language
     * @var string
     */
    public $language;
    /**
     * Constructor method for tradeItemDescriptionInformation
     * @uses TradeItemDescriptionInformation::setLongText()
     * @uses TradeItemDescriptionInformation::setLanguage()
     * @param string $longText
     * @param string $language
     */
    public function __construct($longText = null, $language = null)
    {
        $this
            ->setLongText($longText)
            ->setLanguage($language);
    }
    /**
     * Get longText value
     * @return string|null
     */
    public function getLongText()
    {
        return $this->longText;
    }
    /**
     * Set longText value
     * @param string $longText
     * @return \StructType\TradeItemDescriptionInformation
     */
    public function setLongText($longText = null)
    {
        // validation for constraint: string
        if (!is_null($longText) && !is_string($longText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($longText, true), gettype($longText)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($longText) && mb_strlen($longText) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($longText)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($longText) && mb_strlen($longText) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($longText)), __LINE__);
        }
        $this->longText = $longText;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\TradeItemDescriptionInformation
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
}
