<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TotalAllowanceCharge StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo opcional que especifica el monto total de cargos o descuentos
 * @subpackage Structs
 */
class TotalAllowanceCharge extends AbstractStructBase
{
    /**
     * The allowanceOrChargeType
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $allowanceOrChargeType;
    /**
     * The specialServicesType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $specialServicesType;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Nodo opcional que especifica el monto total de los cargos o descuentos
     * - minOccurs: 0
     * @var float
     */
    public $Amount;
    /**
     * Constructor method for TotalAllowanceCharge
     * @uses TotalAllowanceCharge::setAllowanceOrChargeType()
     * @uses TotalAllowanceCharge::setSpecialServicesType()
     * @uses TotalAllowanceCharge::setAmount()
     * @param string $allowanceOrChargeType
     * @param string $specialServicesType
     * @param float $amount
     */
    public function __construct($allowanceOrChargeType = null, $specialServicesType = null, $amount = null)
    {
        $this
            ->setAllowanceOrChargeType($allowanceOrChargeType)
            ->setSpecialServicesType($specialServicesType)
            ->setAmount($amount);
    }
    /**
     * Get allowanceOrChargeType value
     * @return string
     */
    public function getAllowanceOrChargeType()
    {
        return $this->allowanceOrChargeType;
    }
    /**
     * Set allowanceOrChargeType value
     * @param string $allowanceOrChargeType
     * @return \StructType\TotalAllowanceCharge
     */
    public function setAllowanceOrChargeType($allowanceOrChargeType = null)
    {
        // validation for constraint: string
        if (!is_null($allowanceOrChargeType) && !is_string($allowanceOrChargeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allowanceOrChargeType, true), gettype($allowanceOrChargeType)), __LINE__);
        }
        $this->allowanceOrChargeType = $allowanceOrChargeType;
        return $this;
    }
    /**
     * Get specialServicesType value
     * @return string|null
     */
    public function getSpecialServicesType()
    {
        return $this->specialServicesType;
    }
    /**
     * Set specialServicesType value
     * @uses \EnumType\SpecialServicesType::valueIsValid()
     * @uses \EnumType\SpecialServicesType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $specialServicesType
     * @return \StructType\TotalAllowanceCharge
     */
    public function setSpecialServicesType($specialServicesType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SpecialServicesType::valueIsValid($specialServicesType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SpecialServicesType', is_array($specialServicesType) ? implode(', ', $specialServicesType) : var_export($specialServicesType, true), implode(', ', \EnumType\SpecialServicesType::getValidValues())), __LINE__);
        }
        $this->specialServicesType = $specialServicesType;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\TotalAllowanceCharge
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
}
