<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for timePeriodDue StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo requerido que especifica el tiempo de pago
 * @subpackage Structs
 */
class TimePeriodDue extends AbstractStructBase
{
    /**
     * The timePeriod
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $timePeriod;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - documentation: Nodo requerido que especifica el numero de periodos
     * - base: xs:string
     * - maxLength: 5
     * - minLength: 1
     * @var string
     */
    public $value;
    /**
     * Constructor method for timePeriodDue
     * @uses TimePeriodDue::setTimePeriod()
     * @uses TimePeriodDue::setValue()
     * @param string $timePeriod
     * @param string $value
     */
    public function __construct($timePeriod = null, $value = null)
    {
        $this
            ->setTimePeriod($timePeriod)
            ->setValue($value);
    }
    /**
     * Get timePeriod value
     * @return string
     */
    public function getTimePeriod()
    {
        return $this->timePeriod;
    }
    /**
     * Set timePeriod value
     * @param string $timePeriod
     * @return \StructType\TimePeriodDue
     */
    public function setTimePeriod($timePeriod = null)
    {
        // validation for constraint: string
        if (!is_null($timePeriod) && !is_string($timePeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timePeriod, true), gettype($timePeriod)), __LINE__);
        }
        $this->timePeriod = $timePeriod;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\TimePeriodDue
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($value) && mb_strlen($value) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($value)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($value) && mb_strlen($value) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
}
