<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimbreFiscalDigital StructType
 * Meta information extracted from the WSDL
 * - documentation: Complemento requerido para el Timbrado Fiscal Digital que da validez al Comprobante fiscal digital por Internet.
 * @subpackage Structs
 */
class TimbreFiscalDigital extends AbstractStructBase
{
    /**
     * The FechaTimbrado
     * Meta information extracted from the WSDL
     * - documentation: Atributo requerido para expresar la fecha y hora, de la generación del timbre por la certificación digital del SAT. Se expresa en la forma AAAA-MM-DDThh:mm:ss y debe corresponder con la hora de la Zona Centro del Sistema de Horario
     * en México. | Tipo definido para la expresión de la fecha y hora. Se expresa en la forma AAAA-MM-DDThh:mm:ss
     * - base: xs:dateTime
     * - pattern: (20[1-9][0-9])-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01])T(([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $FechaTimbrado;
    /**
     * The NoCertificadoSAT
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - length: 20
     * - pattern: [0-9]{20}
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $NoCertificadoSAT;
    /**
     * The RfcProvCertif
     * Meta information extracted from the WSDL
     * - documentation: Atributo requerido para expresar el RFC del proveedor de certificación de comprobantes fiscales digitales que genera el timbre fiscal digital. | Tipo definido para la expresión de un Registro Federal de Contribuyentes de persona
     * moral.
     * - base: xs:string
     * - minLength: 12
     * - pattern: [A-Z&Ñ]{3}[0-9]{2}(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])[A-Z0-9]{2}[0-9A]
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $RfcProvCertif;
    /**
     * The SelloCFD
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $SelloCFD;
    /**
     * The SelloSAT
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $SelloSAT;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - length: 36
     * - pattern: [a-f0-9A-F]{8}-[a-f0-9A-F]{4}-[a-f0-9A-F]{4}-[a-f0-9A-F]{4}-[a-f0-9A-F]{12}
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $UUID;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - documentation: Atributo requerido para la expresión de la versión del estándar del Timbre Fiscal Digital
     * - fixed: 1.1
     * - use: required
     * @var anySimpleType
     */
    public $Version;
    /**
     * The Leyenda
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 150
     * - minLength: 12
     * - pattern: ([A-Z]|[a-z]|[0-9]| |Ñ|ñ|!|"|%|&|'|´|-|:|;|>|=|<|@|_|,|\{|\}|`|~|á|é|í|ó|ú|Á|É|Í|Ó|Ú|ü|Ü){1,150}
     * - whiteSpace: collapse
     * @var string
     */
    public $Leyenda;
    /**
     * Constructor method for TimbreFiscalDigital
     * @uses TimbreFiscalDigital::setFechaTimbrado()
     * @uses TimbreFiscalDigital::setNoCertificadoSAT()
     * @uses TimbreFiscalDigital::setRfcProvCertif()
     * @uses TimbreFiscalDigital::setSelloCFD()
     * @uses TimbreFiscalDigital::setSelloSAT()
     * @uses TimbreFiscalDigital::setUUID()
     * @uses TimbreFiscalDigital::setVersion()
     * @uses TimbreFiscalDigital::setLeyenda()
     * @param string $fechaTimbrado
     * @param string $noCertificadoSAT
     * @param string $rfcProvCertif
     * @param string $selloCFD
     * @param string $selloSAT
     * @param string $uUID
     * @param anySimpleType $version
     * @param string $leyenda
     */
    public function __construct($fechaTimbrado = null, $noCertificadoSAT = null, $rfcProvCertif = null, $selloCFD = null, $selloSAT = null, $uUID = null, anySimpleType $version = null, $leyenda = null)
    {
        $this
            ->setFechaTimbrado($fechaTimbrado)
            ->setNoCertificadoSAT($noCertificadoSAT)
            ->setRfcProvCertif($rfcProvCertif)
            ->setSelloCFD($selloCFD)
            ->setSelloSAT($selloSAT)
            ->setUUID($uUID)
            ->setVersion($version)
            ->setLeyenda($leyenda);
    }
    /**
     * Get FechaTimbrado value
     * @return string
     */
    public function getFechaTimbrado()
    {
        return $this->FechaTimbrado;
    }
    /**
     * Set FechaTimbrado value
     * @param string $fechaTimbrado
     * @return \StructType\TimbreFiscalDigital
     */
    public function setFechaTimbrado($fechaTimbrado = null)
    {
        // validation for constraint: string
        if (!is_null($fechaTimbrado) && !is_string($fechaTimbrado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaTimbrado, true), gettype($fechaTimbrado)), __LINE__);
        }
        // validation for constraint: pattern((20[1-9][0-9])-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01])T(([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]))
        if (!is_null($fechaTimbrado) && !preg_match('/(20[1-9][0-9])-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01])T(([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])/', $fechaTimbrado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (20[1-9][0-9])-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01])T(([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])', var_export($fechaTimbrado, true)), __LINE__);
        }
        $this->FechaTimbrado = $fechaTimbrado;
        return $this;
    }
    /**
     * Get NoCertificadoSAT value
     * @return string
     */
    public function getNoCertificadoSAT()
    {
        return $this->NoCertificadoSAT;
    }
    /**
     * Set NoCertificadoSAT value
     * @param string $noCertificadoSAT
     * @return \StructType\TimbreFiscalDigital
     */
    public function setNoCertificadoSAT($noCertificadoSAT = null)
    {
        // validation for constraint: string
        if (!is_null($noCertificadoSAT) && !is_string($noCertificadoSAT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noCertificadoSAT, true), gettype($noCertificadoSAT)), __LINE__);
        }
        // validation for constraint: length(20)
        if (!is_null($noCertificadoSAT) && mb_strlen($noCertificadoSAT) !== 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 20', mb_strlen($noCertificadoSAT)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{20})
        if (!is_null($noCertificadoSAT) && !preg_match('/[0-9]{20}/', $noCertificadoSAT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{20}', var_export($noCertificadoSAT, true)), __LINE__);
        }
        $this->NoCertificadoSAT = $noCertificadoSAT;
        return $this;
    }
    /**
     * Get RfcProvCertif value
     * @return string
     */
    public function getRfcProvCertif()
    {
        return $this->RfcProvCertif;
    }
    /**
     * Set RfcProvCertif value
     * @param string $rfcProvCertif
     * @return \StructType\TimbreFiscalDigital
     */
    public function setRfcProvCertif($rfcProvCertif = null)
    {
        // validation for constraint: string
        if (!is_null($rfcProvCertif) && !is_string($rfcProvCertif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rfcProvCertif, true), gettype($rfcProvCertif)), __LINE__);
        }
        // validation for constraint: minLength(12)
        if (!is_null($rfcProvCertif) && mb_strlen($rfcProvCertif) < 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 12', mb_strlen($rfcProvCertif)), __LINE__);
        }
        // validation for constraint: pattern([A-Z&Ñ]{3}[0-9]{2}(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])[A-Z0-9]{2}[0-9A])
        if (!is_null($rfcProvCertif) && !preg_match('/[A-Z&Ñ]{3}[0-9]{2}(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])[A-Z0-9]{2}[0-9A]/', $rfcProvCertif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z&Ñ]{3}[0-9]{2}(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])[A-Z0-9]{2}[0-9A]', var_export($rfcProvCertif, true)), __LINE__);
        }
        $this->RfcProvCertif = $rfcProvCertif;
        return $this;
    }
    /**
     * Get SelloCFD value
     * @return string
     */
    public function getSelloCFD()
    {
        return $this->SelloCFD;
    }
    /**
     * Set SelloCFD value
     * @param string $selloCFD
     * @return \StructType\TimbreFiscalDigital
     */
    public function setSelloCFD($selloCFD = null)
    {
        // validation for constraint: string
        if (!is_null($selloCFD) && !is_string($selloCFD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selloCFD, true), gettype($selloCFD)), __LINE__);
        }
        $this->SelloCFD = $selloCFD;
        return $this;
    }
    /**
     * Get SelloSAT value
     * @return string
     */
    public function getSelloSAT()
    {
        return $this->SelloSAT;
    }
    /**
     * Set SelloSAT value
     * @param string $selloSAT
     * @return \StructType\TimbreFiscalDigital
     */
    public function setSelloSAT($selloSAT = null)
    {
        // validation for constraint: string
        if (!is_null($selloSAT) && !is_string($selloSAT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selloSAT, true), gettype($selloSAT)), __LINE__);
        }
        $this->SelloSAT = $selloSAT;
        return $this;
    }
    /**
     * Get UUID value
     * @return string
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param string $uUID
     * @return \StructType\TimbreFiscalDigital
     */
    public function setUUID($uUID = null)
    {
        // validation for constraint: string
        if (!is_null($uUID) && !is_string($uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uUID, true), gettype($uUID)), __LINE__);
        }
        // validation for constraint: length(36)
        if (!is_null($uUID) && mb_strlen($uUID) !== 36) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 36', mb_strlen($uUID)), __LINE__);
        }
        // validation for constraint: pattern([a-f0-9A-F]{8}-[a-f0-9A-F]{4}-[a-f0-9A-F]{4}-[a-f0-9A-F]{4}-[a-f0-9A-F]{12})
        if (!is_null($uUID) && !preg_match('/[a-f0-9A-F]{8}-[a-f0-9A-F]{4}-[a-f0-9A-F]{4}-[a-f0-9A-F]{4}-[a-f0-9A-F]{12}/', $uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-f0-9A-F]{8}-[a-f0-9A-F]{4}-[a-f0-9A-F]{4}-[a-f0-9A-F]{4}-[a-f0-9A-F]{12}', var_export($uUID, true)), __LINE__);
        }
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get Version value
     * @return anySimpleType
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param anySimpleType $version
     * @return \StructType\TimbreFiscalDigital
     */
    public function setVersion(anySimpleType $version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Leyenda value
     * @return string|null
     */
    public function getLeyenda()
    {
        return $this->Leyenda;
    }
    /**
     * Set Leyenda value
     * @param string $leyenda
     * @return \StructType\TimbreFiscalDigital
     */
    public function setLeyenda($leyenda = null)
    {
        // validation for constraint: string
        if (!is_null($leyenda) && !is_string($leyenda)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leyenda, true), gettype($leyenda)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($leyenda) && mb_strlen($leyenda) > 150) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen($leyenda)), __LINE__);
        }
        // validation for constraint: minLength(12)
        if (!is_null($leyenda) && mb_strlen($leyenda) < 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 12', mb_strlen($leyenda)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]|[a-z]|[0-9]| |Ñ|ñ|!|"|%|&|'|´|-|:|;|>|=|<|@|_|,|\{|\}|`|~|á|é|í|ó|ú|Á|É|Í|Ó|Ú|ü|Ü){1,150})
        if (!is_null($leyenda) && !preg_match('/([A-Z]|[a-z]|[0-9]| |Ñ|ñ|!|"|%|&|\'|´|-|:|;|>|=|<|@|_|,|\\{|\\}|`|~|á|é|í|ó|ú|Á|É|Í|Ó|Ú|ü|Ü){1,150}/', $leyenda)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]|[a-z]|[0-9]| |Ñ|ñ|!|"|%|&|\'|´|-|:|;|>|=|<|@|_|,|\{|\}|`|~|á|é|í|ó|ú|Á|É|Í|Ó|Ú|ü|Ü){1,150}', var_export($leyenda, true)), __LINE__);
        }
        $this->Leyenda = $leyenda;
        return $this;
    }
}
