<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tax StructType
 * @subpackage Structs
 */
class Tax extends AbstractStructBase
{
    /**
     * The taxPercentage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxPercentage;
    /**
     * The taxAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxAmount;
    /**
     * The taxCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxCategory;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * Constructor method for tax
     * @uses Tax::setTaxPercentage()
     * @uses Tax::setTaxAmount()
     * @uses Tax::setTaxCategory()
     * @uses Tax::setType()
     * @param float $taxPercentage
     * @param float $taxAmount
     * @param string $taxCategory
     * @param string $type
     */
    public function __construct($taxPercentage = null, $taxAmount = null, $taxCategory = null, $type = null)
    {
        $this
            ->setTaxPercentage($taxPercentage)
            ->setTaxAmount($taxAmount)
            ->setTaxCategory($taxCategory)
            ->setType($type);
    }
    /**
     * Get taxPercentage value
     * @return float|null
     */
    public function getTaxPercentage()
    {
        return $this->taxPercentage;
    }
    /**
     * Set taxPercentage value
     * @param float $taxPercentage
     * @return \StructType\Tax
     */
    public function setTaxPercentage($taxPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($taxPercentage) && !(is_float($taxPercentage) || is_numeric($taxPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxPercentage, true), gettype($taxPercentage)), __LINE__);
        }
        $this->taxPercentage = $taxPercentage;
        return $this;
    }
    /**
     * Get taxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->taxAmount;
    }
    /**
     * Set taxAmount value
     * @param float $taxAmount
     * @return \StructType\Tax
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->taxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get taxCategory value
     * @return string|null
     */
    public function getTaxCategory()
    {
        return $this->taxCategory;
    }
    /**
     * Set taxCategory value
     * @uses \EnumType\TaxCategory::valueIsValid()
     * @uses \EnumType\TaxCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $taxCategory
     * @return \StructType\Tax
     */
    public function setTaxCategory($taxCategory = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TaxCategory::valueIsValid($taxCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TaxCategory', is_array($taxCategory) ? implode(', ', $taxCategory) : var_export($taxCategory, true), implode(', ', \EnumType\TaxCategory::getValidValues())), __LINE__);
        }
        $this->taxCategory = $taxCategory;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\Tax
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
}
