<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for t_UbicacionFiscal StructType
 * Meta information extracted from the WSDL
 * - documentation: Tipo definido para expresar domicilios o direcciones
 * @subpackage Structs
 */
class T_UbicacionFiscal extends AbstractStructBase
{
    /**
     * The calle
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minLength: 1
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $calle;
    /**
     * The codigoPostal
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - length: 5
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $codigoPostal;
    /**
     * The estado
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minLength: 1
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $estado;
    /**
     * The municipio
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minLength: 1
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $municipio;
    /**
     * The pais
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minLength: 1
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $pais;
    /**
     * The colonia
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minLength: 1
     * - whiteSpace: collapse
     * @var string
     */
    public $colonia;
    /**
     * The localidad
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minLength: 1
     * - whiteSpace: collapse
     * @var string
     */
    public $localidad;
    /**
     * The noExterior
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minLength: 1
     * - whiteSpace: collapse
     * @var string
     */
    public $noExterior;
    /**
     * The noInterior
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minLength: 1
     * - whiteSpace: collapse
     * @var string
     */
    public $noInterior;
    /**
     * The referencia
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minLength: 1
     * - whiteSpace: collapse
     * @var string
     */
    public $referencia;
    /**
     * Constructor method for t_UbicacionFiscal
     * @uses T_UbicacionFiscal::setCalle()
     * @uses T_UbicacionFiscal::setCodigoPostal()
     * @uses T_UbicacionFiscal::setEstado()
     * @uses T_UbicacionFiscal::setMunicipio()
     * @uses T_UbicacionFiscal::setPais()
     * @uses T_UbicacionFiscal::setColonia()
     * @uses T_UbicacionFiscal::setLocalidad()
     * @uses T_UbicacionFiscal::setNoExterior()
     * @uses T_UbicacionFiscal::setNoInterior()
     * @uses T_UbicacionFiscal::setReferencia()
     * @param string $calle
     * @param string $codigoPostal
     * @param string $estado
     * @param string $municipio
     * @param string $pais
     * @param string $colonia
     * @param string $localidad
     * @param string $noExterior
     * @param string $noInterior
     * @param string $referencia
     */
    public function __construct($calle = null, $codigoPostal = null, $estado = null, $municipio = null, $pais = null, $colonia = null, $localidad = null, $noExterior = null, $noInterior = null, $referencia = null)
    {
        $this
            ->setCalle($calle)
            ->setCodigoPostal($codigoPostal)
            ->setEstado($estado)
            ->setMunicipio($municipio)
            ->setPais($pais)
            ->setColonia($colonia)
            ->setLocalidad($localidad)
            ->setNoExterior($noExterior)
            ->setNoInterior($noInterior)
            ->setReferencia($referencia);
    }
    /**
     * Get calle value
     * @return string
     */
    public function getCalle()
    {
        return $this->calle;
    }
    /**
     * Set calle value
     * @param string $calle
     * @return \StructType\T_UbicacionFiscal
     */
    public function setCalle($calle = null)
    {
        // validation for constraint: string
        if (!is_null($calle) && !is_string($calle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calle, true), gettype($calle)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($calle) && mb_strlen($calle) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($calle)), __LINE__);
        }
        $this->calle = $calle;
        return $this;
    }
    /**
     * Get codigoPostal value
     * @return string
     */
    public function getCodigoPostal()
    {
        return $this->codigoPostal;
    }
    /**
     * Set codigoPostal value
     * @param string $codigoPostal
     * @return \StructType\T_UbicacionFiscal
     */
    public function setCodigoPostal($codigoPostal = null)
    {
        // validation for constraint: string
        if (!is_null($codigoPostal) && !is_string($codigoPostal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoPostal, true), gettype($codigoPostal)), __LINE__);
        }
        // validation for constraint: length(5)
        if (!is_null($codigoPostal) && mb_strlen($codigoPostal) !== 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 5', mb_strlen($codigoPostal)), __LINE__);
        }
        $this->codigoPostal = $codigoPostal;
        return $this;
    }
    /**
     * Get estado value
     * @return string
     */
    public function getEstado()
    {
        return $this->estado;
    }
    /**
     * Set estado value
     * @param string $estado
     * @return \StructType\T_UbicacionFiscal
     */
    public function setEstado($estado = null)
    {
        // validation for constraint: string
        if (!is_null($estado) && !is_string($estado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estado, true), gettype($estado)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($estado) && mb_strlen($estado) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($estado)), __LINE__);
        }
        $this->estado = $estado;
        return $this;
    }
    /**
     * Get municipio value
     * @return string
     */
    public function getMunicipio()
    {
        return $this->municipio;
    }
    /**
     * Set municipio value
     * @param string $municipio
     * @return \StructType\T_UbicacionFiscal
     */
    public function setMunicipio($municipio = null)
    {
        // validation for constraint: string
        if (!is_null($municipio) && !is_string($municipio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($municipio, true), gettype($municipio)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($municipio) && mb_strlen($municipio) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($municipio)), __LINE__);
        }
        $this->municipio = $municipio;
        return $this;
    }
    /**
     * Get pais value
     * @return string
     */
    public function getPais()
    {
        return $this->pais;
    }
    /**
     * Set pais value
     * @param string $pais
     * @return \StructType\T_UbicacionFiscal
     */
    public function setPais($pais = null)
    {
        // validation for constraint: string
        if (!is_null($pais) && !is_string($pais)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pais, true), gettype($pais)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($pais) && mb_strlen($pais) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($pais)), __LINE__);
        }
        $this->pais = $pais;
        return $this;
    }
    /**
     * Get colonia value
     * @return string|null
     */
    public function getColonia()
    {
        return $this->colonia;
    }
    /**
     * Set colonia value
     * @param string $colonia
     * @return \StructType\T_UbicacionFiscal
     */
    public function setColonia($colonia = null)
    {
        // validation for constraint: string
        if (!is_null($colonia) && !is_string($colonia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($colonia, true), gettype($colonia)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($colonia) && mb_strlen($colonia) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($colonia)), __LINE__);
        }
        $this->colonia = $colonia;
        return $this;
    }
    /**
     * Get localidad value
     * @return string|null
     */
    public function getLocalidad()
    {
        return $this->localidad;
    }
    /**
     * Set localidad value
     * @param string $localidad
     * @return \StructType\T_UbicacionFiscal
     */
    public function setLocalidad($localidad = null)
    {
        // validation for constraint: string
        if (!is_null($localidad) && !is_string($localidad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localidad, true), gettype($localidad)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($localidad) && mb_strlen($localidad) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($localidad)), __LINE__);
        }
        $this->localidad = $localidad;
        return $this;
    }
    /**
     * Get noExterior value
     * @return string|null
     */
    public function getNoExterior()
    {
        return $this->noExterior;
    }
    /**
     * Set noExterior value
     * @param string $noExterior
     * @return \StructType\T_UbicacionFiscal
     */
    public function setNoExterior($noExterior = null)
    {
        // validation for constraint: string
        if (!is_null($noExterior) && !is_string($noExterior)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noExterior, true), gettype($noExterior)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($noExterior) && mb_strlen($noExterior) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($noExterior)), __LINE__);
        }
        $this->noExterior = $noExterior;
        return $this;
    }
    /**
     * Get noInterior value
     * @return string|null
     */
    public function getNoInterior()
    {
        return $this->noInterior;
    }
    /**
     * Set noInterior value
     * @param string $noInterior
     * @return \StructType\T_UbicacionFiscal
     */
    public function setNoInterior($noInterior = null)
    {
        // validation for constraint: string
        if (!is_null($noInterior) && !is_string($noInterior)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noInterior, true), gettype($noInterior)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($noInterior) && mb_strlen($noInterior) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($noInterior)), __LINE__);
        }
        $this->noInterior = $noInterior;
        return $this;
    }
    /**
     * Get referencia value
     * @return string|null
     */
    public function getReferencia()
    {
        return $this->referencia;
    }
    /**
     * Set referencia value
     * @param string $referencia
     * @return \StructType\T_UbicacionFiscal
     */
    public function setReferencia($referencia = null)
    {
        // validation for constraint: string
        if (!is_null($referencia) && !is_string($referencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referencia, true), gettype($referencia)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($referencia) && mb_strlen($referencia) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($referencia)), __LINE__);
        }
        $this->referencia = $referencia;
        return $this;
    }
}
