<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for t_InformacionAduanera StructType
 * Meta information extracted from the WSDL
 * - documentation: Tipo definido para expresar información aduanera
 * @subpackage Structs
 */
class T_InformacionAduanera extends AbstractStructBase
{
    /**
     * The fecha
     * Meta information extracted from the WSDL
     * - base: xs:date
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $fecha;
    /**
     * The numero
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minLength: 1
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $numero;
    /**
     * The aduana
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minLength: 1
     * - whiteSpace: collapse
     * @var string
     */
    public $aduana;
    /**
     * Constructor method for t_InformacionAduanera
     * @uses T_InformacionAduanera::setFecha()
     * @uses T_InformacionAduanera::setNumero()
     * @uses T_InformacionAduanera::setAduana()
     * @param string $fecha
     * @param string $numero
     * @param string $aduana
     */
    public function __construct($fecha = null, $numero = null, $aduana = null)
    {
        $this
            ->setFecha($fecha)
            ->setNumero($numero)
            ->setAduana($aduana);
    }
    /**
     * Get fecha value
     * @return string
     */
    public function getFecha()
    {
        return $this->fecha;
    }
    /**
     * Set fecha value
     * @param string $fecha
     * @return \StructType\T_InformacionAduanera
     */
    public function setFecha($fecha = null)
    {
        // validation for constraint: string
        if (!is_null($fecha) && !is_string($fecha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fecha, true), gettype($fecha)), __LINE__);
        }
        $this->fecha = $fecha;
        return $this;
    }
    /**
     * Get numero value
     * @return string
     */
    public function getNumero()
    {
        return $this->numero;
    }
    /**
     * Set numero value
     * @param string $numero
     * @return \StructType\T_InformacionAduanera
     */
    public function setNumero($numero = null)
    {
        // validation for constraint: string
        if (!is_null($numero) && !is_string($numero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numero, true), gettype($numero)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($numero) && mb_strlen($numero) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($numero)), __LINE__);
        }
        $this->numero = $numero;
        return $this;
    }
    /**
     * Get aduana value
     * @return string|null
     */
    public function getAduana()
    {
        return $this->aduana;
    }
    /**
     * Set aduana value
     * @param string $aduana
     * @return \StructType\T_InformacionAduanera
     */
    public function setAduana($aduana = null)
    {
        // validation for constraint: string
        if (!is_null($aduana) && !is_string($aduana)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aduana, true), gettype($aduana)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($aduana) && mb_strlen($aduana) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($aduana)), __LINE__);
        }
        $this->aduana = $aduana;
        return $this;
    }
}
