<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for supplierNumber StructType
 * @subpackage Structs
 */
class SupplierNumber extends AbstractStructBase
{
    /**
     * The referenceIdentification
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - form: qualified
     * - length: 35
     * @var string
     */
    public $referenceIdentification;
    /**
     * The referenceDate
     * Meta information extracted from the WSDL
     * - documentation: SG1 DTM 2380 CALF 171
     * - base: xsd:string
     * - form: qualified
     * - length: 8
     * @var string
     */
    public $referenceDate;
    /**
     * Constructor method for supplierNumber
     * @uses SupplierNumber::setReferenceIdentification()
     * @uses SupplierNumber::setReferenceDate()
     * @param string $referenceIdentification
     * @param string $referenceDate
     */
    public function __construct($referenceIdentification = null, $referenceDate = null)
    {
        $this
            ->setReferenceIdentification($referenceIdentification)
            ->setReferenceDate($referenceDate);
    }
    /**
     * Get referenceIdentification value
     * @return string|null
     */
    public function getReferenceIdentification()
    {
        return $this->referenceIdentification;
    }
    /**
     * Set referenceIdentification value
     * @param string $referenceIdentification
     * @return \StructType\SupplierNumber
     */
    public function setReferenceIdentification($referenceIdentification = null)
    {
        // validation for constraint: string
        if (!is_null($referenceIdentification) && !is_string($referenceIdentification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceIdentification, true), gettype($referenceIdentification)), __LINE__);
        }
        // validation for constraint: length(35)
        if (!is_null($referenceIdentification) && mb_strlen($referenceIdentification) !== 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 35', mb_strlen($referenceIdentification)), __LINE__);
        }
        $this->referenceIdentification = $referenceIdentification;
        return $this;
    }
    /**
     * Get referenceDate value
     * @return string|null
     */
    public function getReferenceDate()
    {
        return $this->referenceDate;
    }
    /**
     * Set referenceDate value
     * @param string $referenceDate
     * @return \StructType\SupplierNumber
     */
    public function setReferenceDate($referenceDate = null)
    {
        // validation for constraint: string
        if (!is_null($referenceDate) && !is_string($referenceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceDate, true), gettype($referenceDate)), __LINE__);
        }
        // validation for constraint: length(8)
        if (!is_null($referenceDate) && mb_strlen($referenceDate) !== 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 8', mb_strlen($referenceDate)), __LINE__);
        }
        $this->referenceDate = $referenceDate;
        return $this;
    }
}
