<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for specialInstruction StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo opcional que especifica que tipo de instrucciones comerciales son enviadas
 * @subpackage Structs
 */
class SpecialInstruction extends AbstractStructBase
{
    /**
     * The code
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $code;
    /**
     * The text
     * Meta information extracted from the WSDL
     * - documentation: Nodo requerido que especifica información de texto que aplica a todo el mensaje de la factura. La información estará en función al código del tema de texto | Contacto de Nodo requerido que especifica el contacto de compras |
     * SG4FTX 4451
     * - base: xs:string
     * - maxLength: 255
     * - maxOccurs: 15
     * - minLength: 1
     * @var string[]
     */
    public $text;
    /**
     * Constructor method for specialInstruction
     * @uses SpecialInstruction::setCode()
     * @uses SpecialInstruction::setText()
     * @param string $code
     * @param string[] $text
     */
    public function __construct($code = null, array $text = array())
    {
        $this
            ->setCode($code)
            ->setText($text);
    }
    /**
     * Get code value
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\SpecialInstruction
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get text value
     * @return string[]|null
     */
    public function getText()
    {
        return $this->text;
    }
    /**
     * This method is responsible for validating the values passed to the setText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setText method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTextForArrayConstraintsFromSetText(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $specialInstructionTextItem) {
            // validation for constraint: itemType
            if (!is_string($specialInstructionTextItem)) {
                $invalidValues[] = is_object($specialInstructionTextItem) ? get_class($specialInstructionTextItem) : sprintf('%s(%s)', gettype($specialInstructionTextItem), var_export($specialInstructionTextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The text property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setText method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTextForMaxLengthConstraintFromSetText($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $specialInstructionTextItem) {
            // validation for constraint: maxLength(255)
            if (mb_strlen($specialInstructionTextItem) > 255) {
                $invalidValues[] = var_export($specialInstructionTextItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 255', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setText method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTextForMinLengthConstraintFromSetText($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $specialInstructionTextItem) {
            // validation for constraint: minLength(1)
            if (mb_strlen($specialInstructionTextItem) < 1) {
                $invalidValues[] = var_export($specialInstructionTextItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 1', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set text value
     * @throws \InvalidArgumentException
     * @param string[] $text
     * @return \StructType\SpecialInstruction
     */
    public function setText(array $text = array())
    {
        // validation for constraint: array
        if ('' !== ($textArrayErrorMessage = self::validateTextForArrayConstraintsFromSetText($text))) {
            throw new \InvalidArgumentException($textArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(255)
        if ('' !== ($textMaxLengthErrorMessage = self::validateTextForMaxLengthConstraintFromSetText($text))) {
            throw new \InvalidArgumentException($textMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(15)
        if (is_array($text) && count($text) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 15', count($text)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if ('' !== ($textMinLengthErrorMessage = self::validateTextForMinLengthConstraintFromSetText($text))) {
            throw new \InvalidArgumentException($textMinLengthErrorMessage, __LINE__);
        }
        $this->text = $text;
        return $this;
    }
    /**
     * Add item to text value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SpecialInstruction
     */
    public function addToText($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The text property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (mb_strlen($item) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: maxOccurs(15)
        if (is_array($this->text) && count($this->text) >= 15) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 15', count($this->text)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (mb_strlen($item) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($item)), __LINE__);
        }
        $this->text[] = $item;
        return $this;
    }
}
