<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Seller StructType
 * Meta information extracted from the WSDL
 * - documentation: SG2NAD
 * @subpackage Structs
 */
class Seller_1 extends AbstractStructBase
{
    /**
     * The gln
     * Meta information extracted from the WSDL
     * - documentation: Nodo requerido que especifica el número global de localización (GLN) del comprador. | Nodo requerido que especifica el número global de localización (GLN) del vendedor. | Nodo opcional que especifica el número global de
     * localización (GLN) de la ubicación a entregar la mercancía | Nodo opcional que especifica el número global de localización (GLN)de la ubicación del emisor de la factura | Nodo opcional que especifica el número global de localización (GLN) de
     * la aduana | SG2NAD 3039 CALIF BY | SG2NAD 3039 CALIF SU
     * - base: xsd:string
     * - form: qualified
     * - minLength: 12
     * @var string
     */
    public $gln;
    /**
     * The nameAndAddress
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\NameAndAddress
     */
    public $nameAndAddress;
    /**
     * Constructor method for Seller
     * @uses Seller_1::setGln()
     * @uses Seller_1::setNameAndAddress()
     * @param string $gln
     * @param \StructType\NameAndAddress $nameAndAddress
     */
    public function __construct($gln = null, \StructType\NameAndAddress $nameAndAddress = null)
    {
        $this
            ->setGln($gln)
            ->setNameAndAddress($nameAndAddress);
    }
    /**
     * Get gln value
     * @return string|null
     */
    public function getGln()
    {
        return $this->gln;
    }
    /**
     * Set gln value
     * @param string $gln
     * @return \StructType\Seller_1
     */
    public function setGln($gln = null)
    {
        // validation for constraint: string
        if (!is_null($gln) && !is_string($gln)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gln, true), gettype($gln)), __LINE__);
        }
        // validation for constraint: minLength(12)
        if (!is_null($gln) && mb_strlen($gln) < 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 12', mb_strlen($gln)), __LINE__);
        }
        $this->gln = $gln;
        return $this;
    }
    /**
     * Get nameAndAddress value
     * @return \StructType\NameAndAddress|null
     */
    public function getNameAndAddress()
    {
        return $this->nameAndAddress;
    }
    /**
     * Set nameAndAddress value
     * @param \StructType\NameAndAddress $nameAndAddress
     * @return \StructType\Seller_1
     */
    public function setNameAndAddress(\StructType\NameAndAddress $nameAndAddress = null)
    {
        $this->nameAndAddress = $nameAndAddress;
        return $this;
    }
}
