<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for seller StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo opcional que especifica información del vendedor
 * @subpackage Structs
 */
class Seller extends AbstractStructBase
{
    /**
     * The gln
     * Meta information extracted from the WSDL
     * - documentation: Nodo requerido que especifica el número global de localización (GLN) del comprador. | Nodo requerido que especifica el número global de localización (GLN) del vendedor. | Nodo opcional que especifica el número global de
     * localización (GLN) de la ubicación a entregar la mercancía | Nodo opcional que especifica el número global de localización (GLN)de la ubicación del emisor de la factura | Nodo opcional que especifica el número global de localización (GLN) de
     * la aduana | SG2NAD 3039 CALIF BY | SG2NAD 3039 CALIF SU
     * - base: xs:string
     * - length: 13
     * @var string
     */
    public $gln;
    /**
     * The alternatePartyIdentification
     * @var \StructType\AlternatePartyIdentification
     */
    public $alternatePartyIdentification;
    /**
     * Constructor method for seller
     * @uses Seller::setGln()
     * @uses Seller::setAlternatePartyIdentification()
     * @param string $gln
     * @param \StructType\AlternatePartyIdentification $alternatePartyIdentification
     */
    public function __construct($gln = null, \StructType\AlternatePartyIdentification $alternatePartyIdentification = null)
    {
        $this
            ->setGln($gln)
            ->setAlternatePartyIdentification($alternatePartyIdentification);
    }
    /**
     * Get gln value
     * @return string|null
     */
    public function getGln()
    {
        return $this->gln;
    }
    /**
     * Set gln value
     * @param string $gln
     * @return \StructType\Seller
     */
    public function setGln($gln = null)
    {
        // validation for constraint: string
        if (!is_null($gln) && !is_string($gln)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gln, true), gettype($gln)), __LINE__);
        }
        // validation for constraint: length(13)
        if (!is_null($gln) && mb_strlen($gln) !== 13) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 13', mb_strlen($gln)), __LINE__);
        }
        $this->gln = $gln;
        return $this;
    }
    /**
     * Get alternatePartyIdentification value
     * @return \StructType\AlternatePartyIdentification|null
     */
    public function getAlternatePartyIdentification()
    {
        return $this->alternatePartyIdentification;
    }
    /**
     * Set alternatePartyIdentification value
     * @param \StructType\AlternatePartyIdentification $alternatePartyIdentification
     * @return \StructType\Seller
     */
    public function setAlternatePartyIdentification(\StructType\AlternatePartyIdentification $alternatePartyIdentification = null)
    {
        $this->alternatePartyIdentification = $alternatePartyIdentification;
        return $this;
    }
}
