<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SPGSOAPFault StructType
 * @subpackage Structs
 */
class SPGSOAPFault extends AbstractStructBase
{
    /**
     * The FaultCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FaultCode;
    /**
     * The FaultString
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FaultString;
    /**
     * The FaultActor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FaultActor;
    /**
     * The SPGSOAPErrorMsg
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ns2:SPGSOAPErrorMsg
     * @var \StructType\SPGSOAPErrorMsg[]
     */
    public $SPGSOAPErrorMsg;
    /**
     * Constructor method for SPGSOAPFault
     * @uses SPGSOAPFault::setFaultCode()
     * @uses SPGSOAPFault::setFaultString()
     * @uses SPGSOAPFault::setFaultActor()
     * @uses SPGSOAPFault::setSPGSOAPErrorMsg()
     * @param string $faultCode
     * @param string $faultString
     * @param string $faultActor
     * @param \StructType\SPGSOAPErrorMsg[] $sPGSOAPErrorMsg
     */
    public function __construct($faultCode = null, $faultString = null, $faultActor = null, array $sPGSOAPErrorMsg = array())
    {
        $this
            ->setFaultCode($faultCode)
            ->setFaultString($faultString)
            ->setFaultActor($faultActor)
            ->setSPGSOAPErrorMsg($sPGSOAPErrorMsg);
    }
    /**
     * Get FaultCode value
     * @return string|null
     */
    public function getFaultCode()
    {
        return $this->FaultCode;
    }
    /**
     * Set FaultCode value
     * @param string $faultCode
     * @return \StructType\SPGSOAPFault
     */
    public function setFaultCode($faultCode = null)
    {
        // validation for constraint: string
        if (!is_null($faultCode) && !is_string($faultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faultCode, true), gettype($faultCode)), __LINE__);
        }
        $this->FaultCode = $faultCode;
        return $this;
    }
    /**
     * Get FaultString value
     * @return string|null
     */
    public function getFaultString()
    {
        return $this->FaultString;
    }
    /**
     * Set FaultString value
     * @param string $faultString
     * @return \StructType\SPGSOAPFault
     */
    public function setFaultString($faultString = null)
    {
        // validation for constraint: string
        if (!is_null($faultString) && !is_string($faultString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faultString, true), gettype($faultString)), __LINE__);
        }
        $this->FaultString = $faultString;
        return $this;
    }
    /**
     * Get FaultActor value
     * @return string|null
     */
    public function getFaultActor()
    {
        return $this->FaultActor;
    }
    /**
     * Set FaultActor value
     * @param string $faultActor
     * @return \StructType\SPGSOAPFault
     */
    public function setFaultActor($faultActor = null)
    {
        // validation for constraint: string
        if (!is_null($faultActor) && !is_string($faultActor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faultActor, true), gettype($faultActor)), __LINE__);
        }
        $this->FaultActor = $faultActor;
        return $this;
    }
    /**
     * Get SPGSOAPErrorMsg value
     * @return \StructType\SPGSOAPErrorMsg[]|null
     */
    public function getSPGSOAPErrorMsg()
    {
        return $this->SPGSOAPErrorMsg;
    }
    /**
     * This method is responsible for validating the values passed to the setSPGSOAPErrorMsg method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSPGSOAPErrorMsg method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSPGSOAPErrorMsgForArrayConstraintsFromSetSPGSOAPErrorMsg(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sPGSOAPFaultSPGSOAPErrorMsgItem) {
            // validation for constraint: itemType
            if (!$sPGSOAPFaultSPGSOAPErrorMsgItem instanceof \StructType\SPGSOAPErrorMsg) {
                $invalidValues[] = is_object($sPGSOAPFaultSPGSOAPErrorMsgItem) ? get_class($sPGSOAPFaultSPGSOAPErrorMsgItem) : sprintf('%s(%s)', gettype($sPGSOAPFaultSPGSOAPErrorMsgItem), var_export($sPGSOAPFaultSPGSOAPErrorMsgItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SPGSOAPErrorMsg property can only contain items of type \StructType\SPGSOAPErrorMsg, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SPGSOAPErrorMsg value
     * @throws \InvalidArgumentException
     * @param \StructType\SPGSOAPErrorMsg[] $sPGSOAPErrorMsg
     * @return \StructType\SPGSOAPFault
     */
    public function setSPGSOAPErrorMsg(array $sPGSOAPErrorMsg = array())
    {
        // validation for constraint: array
        if ('' !== ($sPGSOAPErrorMsgArrayErrorMessage = self::validateSPGSOAPErrorMsgForArrayConstraintsFromSetSPGSOAPErrorMsg($sPGSOAPErrorMsg))) {
            throw new \InvalidArgumentException($sPGSOAPErrorMsgArrayErrorMessage, __LINE__);
        }
        $this->SPGSOAPErrorMsg = $sPGSOAPErrorMsg;
        return $this;
    }
    /**
     * Add item to SPGSOAPErrorMsg value
     * @throws \InvalidArgumentException
     * @param \StructType\SPGSOAPErrorMsg $item
     * @return \StructType\SPGSOAPFault
     */
    public function addToSPGSOAPErrorMsg(\StructType\SPGSOAPErrorMsg $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SPGSOAPErrorMsg) {
            throw new \InvalidArgumentException(sprintf('The SPGSOAPErrorMsg property can only contain items of type \StructType\SPGSOAPErrorMsg, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SPGSOAPErrorMsg[] = $item;
        return $this;
    }
}
