<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SPGSOAPErrorMsg StructType
 * @subpackage Structs
 */
class SPGSOAPErrorMsg extends AbstractStructBase
{
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns2:Message
     * @var string
     */
    public $Message;
    /**
     * The MessageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns2:MessageId
     * @var string
     */
    public $MessageId;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns2:ErrorCode
     * @var string
     */
    public $ErrorCode;
    /**
     * Constructor method for SPGSOAPErrorMsg
     * @uses SPGSOAPErrorMsg::setMessage()
     * @uses SPGSOAPErrorMsg::setMessageId()
     * @uses SPGSOAPErrorMsg::setErrorCode()
     * @param string $message
     * @param string $messageId
     * @param string $errorCode
     */
    public function __construct($message = null, $messageId = null, $errorCode = null)
    {
        $this
            ->setMessage($message)
            ->setMessageId($messageId)
            ->setErrorCode($errorCode);
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\SPGSOAPErrorMsg
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get MessageId value
     * @return string|null
     */
    public function getMessageId()
    {
        return $this->MessageId;
    }
    /**
     * Set MessageId value
     * @param string $messageId
     * @return \StructType\SPGSOAPErrorMsg
     */
    public function setMessageId($messageId = null)
    {
        // validation for constraint: string
        if (!is_null($messageId) && !is_string($messageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageId, true), gettype($messageId)), __LINE__);
        }
        $this->MessageId = $messageId;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return string|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param string $errorCode
     * @return \StructType\SPGSOAPErrorMsg
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
}
