<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SIH_Proveedor StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo requerido para expresar la informacion relacionada cuando no presenta addenda AMC 7.1
 * @subpackage Structs
 */
class SIH_Proveedor extends AbstractStructBase
{
    /**
     * The NumProveedor
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - use: required
     * @var string
     */
    public $NumProveedor;
    /**
     * The Sucursal
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - use: required
     * @var string
     */
    public $Sucursal;
    /**
     * The FolioRecepcion
     * Meta information extracted from the WSDL
     * - base: xs:string
     * @var string
     */
    public $FolioRecepcion;
    /**
     * The OrdenCompra
     * Meta information extracted from the WSDL
     * - base: xs:string
     * @var string
     */
    public $OrdenCompra;
    /**
     * Constructor method for SIH_Proveedor
     * @uses SIH_Proveedor::setNumProveedor()
     * @uses SIH_Proveedor::setSucursal()
     * @uses SIH_Proveedor::setFolioRecepcion()
     * @uses SIH_Proveedor::setOrdenCompra()
     * @param string $numProveedor
     * @param string $sucursal
     * @param string $folioRecepcion
     * @param string $ordenCompra
     */
    public function __construct($numProveedor = null, $sucursal = null, $folioRecepcion = null, $ordenCompra = null)
    {
        $this
            ->setNumProveedor($numProveedor)
            ->setSucursal($sucursal)
            ->setFolioRecepcion($folioRecepcion)
            ->setOrdenCompra($ordenCompra);
    }
    /**
     * Get NumProveedor value
     * @return string
     */
    public function getNumProveedor()
    {
        return $this->NumProveedor;
    }
    /**
     * Set NumProveedor value
     * @param string $numProveedor
     * @return \StructType\SIH_Proveedor
     */
    public function setNumProveedor($numProveedor = null)
    {
        // validation for constraint: string
        if (!is_null($numProveedor) && !is_string($numProveedor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numProveedor, true), gettype($numProveedor)), __LINE__);
        }
        $this->NumProveedor = $numProveedor;
        return $this;
    }
    /**
     * Get Sucursal value
     * @return string
     */
    public function getSucursal()
    {
        return $this->Sucursal;
    }
    /**
     * Set Sucursal value
     * @param string $sucursal
     * @return \StructType\SIH_Proveedor
     */
    public function setSucursal($sucursal = null)
    {
        // validation for constraint: string
        if (!is_null($sucursal) && !is_string($sucursal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sucursal, true), gettype($sucursal)), __LINE__);
        }
        $this->Sucursal = $sucursal;
        return $this;
    }
    /**
     * Get FolioRecepcion value
     * @return string|null
     */
    public function getFolioRecepcion()
    {
        return $this->FolioRecepcion;
    }
    /**
     * Set FolioRecepcion value
     * @param string $folioRecepcion
     * @return \StructType\SIH_Proveedor
     */
    public function setFolioRecepcion($folioRecepcion = null)
    {
        // validation for constraint: string
        if (!is_null($folioRecepcion) && !is_string($folioRecepcion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($folioRecepcion, true), gettype($folioRecepcion)), __LINE__);
        }
        $this->FolioRecepcion = $folioRecepcion;
        return $this;
    }
    /**
     * Get OrdenCompra value
     * @return string|null
     */
    public function getOrdenCompra()
    {
        return $this->OrdenCompra;
    }
    /**
     * Set OrdenCompra value
     * @param string $ordenCompra
     * @return \StructType\SIH_Proveedor
     */
    public function setOrdenCompra($ordenCompra = null)
    {
        // validation for constraint: string
        if (!is_null($ordenCompra) && !is_string($ordenCompra)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ordenCompra, true), gettype($ordenCompra)), __LINE__);
        }
        $this->OrdenCompra = $ordenCompra;
        return $this;
    }
}
