<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SET_DIGITAL_INVOICE_REQUEST StructType
 * Meta information extracted from the WSDL
 * - documentation: Estándar de Comprobante Fiscal Digital por Internet.
 * @subpackage Structs
 */
class SET_DIGITAL_INVOICE_REQUEST extends AbstractStructBase
{
    /**
     * The ISBUREAU
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ISBUREAU;
    /**
     * The Comprobante
     * Meta information extracted from the WSDL
     * - ref: cfdi:Comprobante
     * @var \StructType\Comprobante
     */
    public $Comprobante;
    /**
     * The login
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $login;
    /**
     * The pass
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pass;
    /**
     * Constructor method for SET_DIGITAL_INVOICE_REQUEST
     * @uses SET_DIGITAL_INVOICE_REQUEST::setISBUREAU()
     * @uses SET_DIGITAL_INVOICE_REQUEST::setComprobante()
     * @uses SET_DIGITAL_INVOICE_REQUEST::setLogin()
     * @uses SET_DIGITAL_INVOICE_REQUEST::setPass()
     * @param int $iSBUREAU
     * @param \StructType\Comprobante $comprobante
     * @param string $login
     * @param string $pass
     */
    public function __construct($iSBUREAU = null, \StructType\Comprobante $comprobante = null, $login = null, $pass = null)
    {
        $this
            ->setISBUREAU($iSBUREAU)
            ->setComprobante($comprobante)
            ->setLogin($login)
            ->setPass($pass);
    }
    /**
     * Get ISBUREAU value
     * @return int|null
     */
    public function getISBUREAU()
    {
        return $this->ISBUREAU;
    }
    /**
     * Set ISBUREAU value
     * @param int $iSBUREAU
     * @return \StructType\SET_DIGITAL_INVOICE_REQUEST
     */
    public function setISBUREAU($iSBUREAU = null)
    {
        // validation for constraint: int
        if (!is_null($iSBUREAU) && !(is_int($iSBUREAU) || ctype_digit($iSBUREAU))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iSBUREAU, true), gettype($iSBUREAU)), __LINE__);
        }
        $this->ISBUREAU = $iSBUREAU;
        return $this;
    }
    /**
     * Get Comprobante value
     * @return \StructType\Comprobante|null
     */
    public function getComprobante()
    {
        return $this->Comprobante;
    }
    /**
     * Set Comprobante value
     * @param \StructType\Comprobante $comprobante
     * @return \StructType\SET_DIGITAL_INVOICE_REQUEST
     */
    public function setComprobante(\StructType\Comprobante $comprobante = null)
    {
        $this->Comprobante = $comprobante;
        return $this;
    }
    /**
     * Get login value
     * @return string|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param string $login
     * @return \StructType\SET_DIGITAL_INVOICE_REQUEST
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login) && !is_string($login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($login, true), gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get pass value
     * @return string|null
     */
    public function getPass()
    {
        return $this->pass;
    }
    /**
     * Set pass value
     * @param string $pass
     * @return \StructType\SET_DIGITAL_INVOICE_REQUEST
     */
    public function setPass($pass = null)
    {
        // validation for constraint: string
        if (!is_null($pass) && !is_string($pass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pass, true), gettype($pass)), __LINE__);
        }
        $this->pass = $pass;
        return $this;
    }
}
