<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Retenciones StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo opcional para capturar los impuestos retenidos aplicables | Nodo condicional para capturar los impuestos retenidos aplicables. | Nodo condicional para capturar los impuestos retenidos aplicables. Es requerido cuando en los
 * conceptos se registre algún impuesto retenido. | Nodo opcional para asentar los impuestos retenidos aplicables al presente concepto.
 * @subpackage Structs
 */
class Retenciones extends AbstractStructBase
{
    /**
     * The Retencion
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Retencion[]
     */
    public $Retencion;
    /**
     * Constructor method for Retenciones
     * @uses Retenciones::setRetencion()
     * @param \StructType\Retencion[] $retencion
     */
    public function __construct(array $retencion = array())
    {
        $this
            ->setRetencion($retencion);
    }
    /**
     * Get Retencion value
     * @return \StructType\Retencion[]|null
     */
    public function getRetencion()
    {
        return $this->Retencion;
    }
    /**
     * This method is responsible for validating the values passed to the setRetencion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRetencion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRetencionForArrayConstraintsFromSetRetencion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $retencionesRetencionItem) {
            // validation for constraint: itemType
            if (!$retencionesRetencionItem instanceof \StructType\Retencion) {
                $invalidValues[] = is_object($retencionesRetencionItem) ? get_class($retencionesRetencionItem) : sprintf('%s(%s)', gettype($retencionesRetencionItem), var_export($retencionesRetencionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Retencion property can only contain items of type \StructType\Retencion, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Retencion value
     * @throws \InvalidArgumentException
     * @param \StructType\Retencion[] $retencion
     * @return \StructType\Retenciones
     */
    public function setRetencion(array $retencion = array())
    {
        // validation for constraint: array
        if ('' !== ($retencionArrayErrorMessage = self::validateRetencionForArrayConstraintsFromSetRetencion($retencion))) {
            throw new \InvalidArgumentException($retencionArrayErrorMessage, __LINE__);
        }
        $this->Retencion = $retencion;
        return $this;
    }
    /**
     * Add item to Retencion value
     * @throws \InvalidArgumentException
     * @param \StructType\Retencion $item
     * @return \StructType\Retenciones
     */
    public function addToRetencion(\StructType\Retencion $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Retencion) {
            throw new \InvalidArgumentException(sprintf('The Retencion property can only contain items of type \StructType\Retencion, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Retencion[] = $item;
        return $this;
    }
}
