<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Retencion StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo para la información detallada de una retención de impuesto específico | Nodo requerido para registrar la información detallada de una retención de impuesto específico. | Nodo requerido para la información detallada de una
 * retención de impuesto específico. | Nodo requerido para asentar la información detallada de una retención de impuestos aplicable al presente concepto.
 * @subpackage Structs
 */
class Retencion extends AbstractStructBase
{
    /**
     * The Base
     * Meta information extracted from the WSDL
     * - base: xs:decimal
     * - fractionDigits: 6
     * - minInclusive: 0.000001
     * - use: required
     * - whiteSpace: collapse
     * @var float
     */
    public $Base;
    /**
     * The Importe
     * Meta information extracted from the WSDL
     * - documentation: Atributo requerido para señalar el importe o monto del impuesto retenido. No se permiten valores negativos. | Atributo requerido para señalar el monto del impuesto retenido. No se permiten valores negativos. | Atributo requerido
     * para señalar el importe del impuesto retenido que aplica al concepto. No se permiten valores negativos. | Tipo definido para expresar importes numéricos con fracción hasta seis decimales. El valor se redondea de acuerdo con el número de decimales
     * que soporta la moneda. No se permiten valores negativos. | Tipo definido para expresar importes numéricos con fracción hasta seis decimales
     * - base: xs:decimal
     * - fractionDigits: 6
     * - minInclusive: 0.0
     * - pattern: [0-9]{1,18}(.[0-9]{1,6})?
     * - use: required
     * - whiteSpace: collapse
     * @var float
     */
    public $Importe;
    /**
     * The Impuesto
     * Meta information extracted from the WSDL
     * - documentation: Atributo requerido para señalar la clave del tipo de impuesto retenido. | Atributo requerido para señalar la clave del tipo de impuesto retenido | Atributo requerido para señalar la clave del tipo de impuesto retenido aplicable al
     * concepto.
     * - use: required
     * @var string
     */
    public $Impuesto;
    /**
     * The TasaOCuota
     * Meta information extracted from the WSDL
     * - base: xs:decimal
     * - fractionDigits: 6
     * - minInclusive: 0.0
     * - use: required
     * - whiteSpace: collapse
     * @var float
     */
    public $TasaOCuota;
    /**
     * The TipoFactor
     * Meta information extracted from the WSDL
     * - documentation: Atributo requerido para señalar la clave del tipo de factor que se aplica a la base del impuesto.
     * - use: required
     * @var string
     */
    public $TipoFactor;
    /**
     * The importe
     * Meta information extracted from the WSDL
     * - documentation: Atributo requerido para señalar el importe o monto del impuesto retenido | Tipo definido para expresar importes numéricos con fracción hasta seis decimales. El valor se redondea de acuerdo con el número de decimales que soporta
     * la moneda. No se permiten valores negativos. | Tipo definido para expresar importes numéricos con fracción hasta seis decimales
     * - base: xs:decimal
     * - fractionDigits: 6
     * - minInclusive: 0.0
     * - pattern: [0-9]{1,18}(.[0-9]{1,6})?
     * - use: required
     * - whiteSpace: collapse
     * @var float
     */
    public $importe;
    /**
     * The impuesto
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $impuesto;
    /**
     * Constructor method for Retencion
     * @uses Retencion::setBase()
     * @uses Retencion::setImporte()
     * @uses Retencion::setImpuesto()
     * @uses Retencion::setTasaOCuota()
     * @uses Retencion::setTipoFactor()
     * @uses Retencion::setImporte_1()
     * @uses Retencion::setImpuesto_1()
     * @param float $base
     * @param float $importe
     * @param string $impuesto
     * @param float $tasaOCuota
     * @param string $tipoFactor
     * @param float $importe
     * @param string $impuesto
     */
    public function __construct($base = null, $importe = null, $impuesto = null, $tasaOCuota = null, $tipoFactor = null, $importe_1 = null, $impuesto_1 = null)
    {
        $this
            ->setBase($base)
            ->setImporte($importe)
            ->setImpuesto($impuesto)
            ->setTasaOCuota($tasaOCuota)
            ->setTipoFactor($tipoFactor)
            ->setImporte_1($importe_1)
            ->setImpuesto_1($impuesto_1);
    }
    /**
     * Get Base value
     * @return float
     */
    public function getBase()
    {
        return $this->Base;
    }
    /**
     * Set Base value
     * @param float $base
     * @return \StructType\Retencion
     */
    public function setBase($base = null)
    {
        // validation for constraint: float
        if (!is_null($base) && !(is_float($base) || is_numeric($base))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($base, true), gettype($base)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($base) && mb_strlen(mb_substr($base, false !== mb_strpos($base, '.') ? mb_strpos($base, '.') + 1 : mb_strlen($base))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($base, true), mb_strlen(mb_substr($base, mb_strpos($base, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive(0.000001)
        if (!is_null($base) && $base < 0.000001) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.000001', var_export($base, true)), __LINE__);
        }
        $this->Base = $base;
        return $this;
    }
    /**
     * Get Importe value
     * @return float
     */
    public function getImporte()
    {
        return $this->Importe;
    }
    /**
     * Set Importe value
     * @param float $importe
     * @return \StructType\Retencion
     */
    public function setImporte($importe = null)
    {
        // validation for constraint: float
        if (!is_null($importe) && !(is_float($importe) || is_numeric($importe))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($importe, true), gettype($importe)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($importe) && mb_strlen(mb_substr($importe, false !== mb_strpos($importe, '.') ? mb_strpos($importe, '.') + 1 : mb_strlen($importe))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($importe, true), mb_strlen(mb_substr($importe, mb_strpos($importe, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($importe) && $importe < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($importe, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,18}(.[0-9]{1,6})?)
        if (!is_null($importe) && !preg_match('/[0-9]{1,18}(.[0-9]{1,6})?/', $importe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,18}(.[0-9]{1,6})?', var_export($importe, true)), __LINE__);
        }
        $this->Importe = $importe;
        return $this;
    }
    /**
     * Get Impuesto value
     * @return string
     */
    public function getImpuesto()
    {
        return $this->Impuesto;
    }
    /**
     * Set Impuesto value
     * @uses \EnumType\C_Impuesto::valueIsValid()
     * @uses \EnumType\C_Impuesto::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $impuesto
     * @return \StructType\Retencion
     */
    public function setImpuesto($impuesto = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\C_Impuesto::valueIsValid($impuesto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\C_Impuesto', is_array($impuesto) ? implode(', ', $impuesto) : var_export($impuesto, true), implode(', ', \EnumType\C_Impuesto::getValidValues())), __LINE__);
        }
        $this->Impuesto = $impuesto;
        return $this;
    }
    /**
     * Get TasaOCuota value
     * @return float
     */
    public function getTasaOCuota()
    {
        return $this->TasaOCuota;
    }
    /**
     * Set TasaOCuota value
     * @param float $tasaOCuota
     * @return \StructType\Retencion
     */
    public function setTasaOCuota($tasaOCuota = null)
    {
        // validation for constraint: float
        if (!is_null($tasaOCuota) && !(is_float($tasaOCuota) || is_numeric($tasaOCuota))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tasaOCuota, true), gettype($tasaOCuota)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($tasaOCuota) && mb_strlen(mb_substr($tasaOCuota, false !== mb_strpos($tasaOCuota, '.') ? mb_strpos($tasaOCuota, '.') + 1 : mb_strlen($tasaOCuota))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($tasaOCuota, true), mb_strlen(mb_substr($tasaOCuota, mb_strpos($tasaOCuota, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($tasaOCuota) && $tasaOCuota < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($tasaOCuota, true)), __LINE__);
        }
        $this->TasaOCuota = $tasaOCuota;
        return $this;
    }
    /**
     * Get TipoFactor value
     * @return string
     */
    public function getTipoFactor()
    {
        return $this->TipoFactor;
    }
    /**
     * Set TipoFactor value
     * @uses \EnumType\C_TipoFactor::valueIsValid()
     * @uses \EnumType\C_TipoFactor::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoFactor
     * @return \StructType\Retencion
     */
    public function setTipoFactor($tipoFactor = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\C_TipoFactor::valueIsValid($tipoFactor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\C_TipoFactor', is_array($tipoFactor) ? implode(', ', $tipoFactor) : var_export($tipoFactor, true), implode(', ', \EnumType\C_TipoFactor::getValidValues())), __LINE__);
        }
        $this->TipoFactor = $tipoFactor;
        return $this;
    }
    /**
     * Get Importe value
     * @return float
     */
    public function getImporte_1()
    {
        return $this->importe;
    }
    /**
     * Set Importe value
     * @param float $importe
     * @return \StructType\Retencion
     */
    public function setImporte_1($importe_1 = null)
    {
        // validation for constraint: float
        if (!is_null($importe_1) && !(is_float($importe_1) || is_numeric($importe_1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($importe_1, true), gettype($importe_1)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($importe_1) && mb_strlen(mb_substr($importe_1, false !== mb_strpos($importe_1, '.') ? mb_strpos($importe_1, '.') + 1 : mb_strlen($importe_1))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($importe_1, true), mb_strlen(mb_substr($importe_1, mb_strpos($importe_1, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($importe_1) && $importe_1 < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($importe_1, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,18}(.[0-9]{1,6})?)
        if (!is_null($importe_1) && !preg_match('/[0-9]{1,18}(.[0-9]{1,6})?/', $importe_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,18}(.[0-9]{1,6})?', var_export($importe_1, true)), __LINE__);
        }
        $this->importe = $importe_1;
        return $this;
    }
    /**
     * Get Impuesto value
     * @return string
     */
    public function getImpuesto_1()
    {
        return $this->impuesto;
    }
    /**
     * Set Impuesto value
     * @uses \EnumType\C_Impuesto::valueIsValid()
     * @uses \EnumType\C_Impuesto::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $impuesto
     * @return \StructType\Retencion
     */
    public function setImpuesto_1($impuesto_1 = null)
    {
        // validation for constraint: string
        if (!is_null($impuesto_1) && !is_string($impuesto_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($impuesto_1, true), gettype($impuesto_1)), __LINE__);
        }
        $this->impuesto = $impuesto_1;
        return $this;
    }
}
