<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for requestForPaymentIdentification StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo requerido que especifica la transacción a utilizar
 * @subpackage Structs
 */
class RequestForPaymentIdentification extends AbstractStructBase
{
    /**
     * The entityType
     * @var string
     */
    public $entityType;
    /**
     * The uniqueCreatorIdentification
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 17
     * - minLength: 1
     * @var string
     */
    public $uniqueCreatorIdentification;
    /**
     * Constructor method for requestForPaymentIdentification
     * @uses RequestForPaymentIdentification::setEntityType()
     * @uses RequestForPaymentIdentification::setUniqueCreatorIdentification()
     * @param string $entityType
     * @param string $uniqueCreatorIdentification
     */
    public function __construct($entityType = null, $uniqueCreatorIdentification = null)
    {
        $this
            ->setEntityType($entityType)
            ->setUniqueCreatorIdentification($uniqueCreatorIdentification);
    }
    /**
     * Get entityType value
     * @return string|null
     */
    public function getEntityType()
    {
        return $this->entityType;
    }
    /**
     * Set entityType value
     * @uses \EnumType\EntityType::valueIsValid()
     * @uses \EnumType\EntityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $entityType
     * @return \StructType\RequestForPaymentIdentification
     */
    public function setEntityType($entityType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EntityType::valueIsValid($entityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EntityType', is_array($entityType) ? implode(', ', $entityType) : var_export($entityType, true), implode(', ', \EnumType\EntityType::getValidValues())), __LINE__);
        }
        $this->entityType = $entityType;
        return $this;
    }
    /**
     * Get uniqueCreatorIdentification value
     * @return string|null
     */
    public function getUniqueCreatorIdentification()
    {
        return $this->uniqueCreatorIdentification;
    }
    /**
     * Set uniqueCreatorIdentification value
     * @param string $uniqueCreatorIdentification
     * @return \StructType\RequestForPaymentIdentification
     */
    public function setUniqueCreatorIdentification($uniqueCreatorIdentification = null)
    {
        // validation for constraint: string
        if (!is_null($uniqueCreatorIdentification) && !is_string($uniqueCreatorIdentification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uniqueCreatorIdentification, true), gettype($uniqueCreatorIdentification)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($uniqueCreatorIdentification) && mb_strlen($uniqueCreatorIdentification) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($uniqueCreatorIdentification)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($uniqueCreatorIdentification) && mb_strlen($uniqueCreatorIdentification) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($uniqueCreatorIdentification)), __LINE__);
        }
        $this->uniqueCreatorIdentification = $uniqueCreatorIdentification;
        return $this;
    }
}
