<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for requestForPayment StructType
 * @subpackage Structs
 */
class RequestForPayment extends AbstractStructBase
{
    /**
     * The documentStatus
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $documentStatus;
    /**
     * The documentStructureVersion
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $documentStructureVersion;
    /**
     * The requestForPaymentIdentification
     * @var \StructType\RequestForPaymentIdentification
     */
    public $requestForPaymentIdentification;
    /**
     * The specialInstruction
     * Meta information extracted from the WSDL
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var \StructType\SpecialInstruction[]
     */
    public $specialInstruction;
    /**
     * The orderIdentification
     * @var \StructType\OrderIdentification
     */
    public $orderIdentification;
    /**
     * The AdditionalInformation
     * @var \StructType\AdditionalInformation
     */
    public $AdditionalInformation;
    /**
     * The DeliveryNote
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DeliveryNote
     */
    public $DeliveryNote;
    /**
     * The buyer
     * @var \StructType\Buyer
     */
    public $buyer;
    /**
     * The seller
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Seller
     */
    public $seller;
    /**
     * The shipTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ShipTo
     */
    public $shipTo;
    /**
     * The InvoiceCreator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InvoiceCreator
     */
    public $InvoiceCreator;
    /**
     * The Customs
     * Meta information extracted from the WSDL
     * - maxOccurs: 999999
     * - minOccurs: 0
     * @var \StructType\Customs[]
     */
    public $Customs;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\Currency[]
     */
    public $currency;
    /**
     * The paymentTerms
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaymentTerms
     */
    public $paymentTerms;
    /**
     * The shipmentDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $shipmentDetail;
    /**
     * The allowanceCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\AllowanceCharge[]
     */
    public $allowanceCharge;
    /**
     * The lineItem
     * Meta information extracted from the WSDL
     * - maxOccurs: 9999999
     * - minOccurs: 0
     * @var \StructType\LineItem[]
     */
    public $lineItem;
    /**
     * The totalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TotalAmount
     */
    public $totalAmount;
    /**
     * The TotalAllowanceCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: 999999
     * - minOccurs: 0
     * @var \StructType\TotalAllowanceCharge[]
     */
    public $TotalAllowanceCharge;
    /**
     * The baseAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BaseAmount
     */
    public $baseAmount;
    /**
     * The tax
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\Tax[]
     */
    public $tax;
    /**
     * The payableAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PayableAmount
     */
    public $payableAmount;
    /**
     * The DeliveryDate
     * @var string
     */
    public $DeliveryDate;
    /**
     * The contentVersion
     * Meta information extracted from the WSDL
     * - default: 1.3.1
     * @var string
     */
    public $contentVersion;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - default: SimpleInvoiceType
     * @var string
     */
    public $type;
    /**
     * Constructor method for requestForPayment
     * @uses RequestForPayment::setDocumentStatus()
     * @uses RequestForPayment::setDocumentStructureVersion()
     * @uses RequestForPayment::setRequestForPaymentIdentification()
     * @uses RequestForPayment::setSpecialInstruction()
     * @uses RequestForPayment::setOrderIdentification()
     * @uses RequestForPayment::setAdditionalInformation()
     * @uses RequestForPayment::setDeliveryNote()
     * @uses RequestForPayment::setBuyer()
     * @uses RequestForPayment::setSeller()
     * @uses RequestForPayment::setShipTo()
     * @uses RequestForPayment::setInvoiceCreator()
     * @uses RequestForPayment::setCustoms()
     * @uses RequestForPayment::setCurrency()
     * @uses RequestForPayment::setPaymentTerms()
     * @uses RequestForPayment::setShipmentDetail()
     * @uses RequestForPayment::setAllowanceCharge()
     * @uses RequestForPayment::setLineItem()
     * @uses RequestForPayment::setTotalAmount()
     * @uses RequestForPayment::setTotalAllowanceCharge()
     * @uses RequestForPayment::setBaseAmount()
     * @uses RequestForPayment::setTax()
     * @uses RequestForPayment::setPayableAmount()
     * @uses RequestForPayment::setDeliveryDate()
     * @uses RequestForPayment::setContentVersion()
     * @uses RequestForPayment::setType()
     * @param string $documentStatus
     * @param string $documentStructureVersion
     * @param \StructType\RequestForPaymentIdentification $requestForPaymentIdentification
     * @param \StructType\SpecialInstruction[] $specialInstruction
     * @param \StructType\OrderIdentification $orderIdentification
     * @param \StructType\AdditionalInformation $additionalInformation
     * @param \StructType\DeliveryNote $deliveryNote
     * @param \StructType\Buyer $buyer
     * @param \StructType\Seller $seller
     * @param \StructType\ShipTo $shipTo
     * @param \StructType\InvoiceCreator $invoiceCreator
     * @param \StructType\Customs[] $customs
     * @param \StructType\Currency[] $currency
     * @param \StructType\PaymentTerms $paymentTerms
     * @param mixed $shipmentDetail
     * @param \StructType\AllowanceCharge[] $allowanceCharge
     * @param \StructType\LineItem[] $lineItem
     * @param \StructType\TotalAmount $totalAmount
     * @param \StructType\TotalAllowanceCharge[] $totalAllowanceCharge
     * @param \StructType\BaseAmount $baseAmount
     * @param \StructType\Tax[] $tax
     * @param \StructType\PayableAmount $payableAmount
     * @param string $deliveryDate
     * @param string $contentVersion
     * @param string $type
     */
    public function __construct($documentStatus = null, $documentStructureVersion = null, \StructType\RequestForPaymentIdentification $requestForPaymentIdentification = null, array $specialInstruction = array(), \StructType\OrderIdentification $orderIdentification = null, \StructType\AdditionalInformation $additionalInformation = null, \StructType\DeliveryNote $deliveryNote = null, \StructType\Buyer $buyer = null, \StructType\Seller $seller = null, \StructType\ShipTo $shipTo = null, \StructType\InvoiceCreator $invoiceCreator = null, array $customs = array(), array $currency = array(), \StructType\PaymentTerms $paymentTerms = null, $shipmentDetail = null, array $allowanceCharge = array(), array $lineItem = array(), \StructType\TotalAmount $totalAmount = null, array $totalAllowanceCharge = array(), \StructType\BaseAmount $baseAmount = null, array $tax = array(), \StructType\PayableAmount $payableAmount = null, $deliveryDate = null, $contentVersion = '1.3.1', $type = 'SimpleInvoiceType')
    {
        $this
            ->setDocumentStatus($documentStatus)
            ->setDocumentStructureVersion($documentStructureVersion)
            ->setRequestForPaymentIdentification($requestForPaymentIdentification)
            ->setSpecialInstruction($specialInstruction)
            ->setOrderIdentification($orderIdentification)
            ->setAdditionalInformation($additionalInformation)
            ->setDeliveryNote($deliveryNote)
            ->setBuyer($buyer)
            ->setSeller($seller)
            ->setShipTo($shipTo)
            ->setInvoiceCreator($invoiceCreator)
            ->setCustoms($customs)
            ->setCurrency($currency)
            ->setPaymentTerms($paymentTerms)
            ->setShipmentDetail($shipmentDetail)
            ->setAllowanceCharge($allowanceCharge)
            ->setLineItem($lineItem)
            ->setTotalAmount($totalAmount)
            ->setTotalAllowanceCharge($totalAllowanceCharge)
            ->setBaseAmount($baseAmount)
            ->setTax($tax)
            ->setPayableAmount($payableAmount)
            ->setDeliveryDate($deliveryDate)
            ->setContentVersion($contentVersion)
            ->setType($type);
    }
    /**
     * Get documentStatus value
     * @return string
     */
    public function getDocumentStatus()
    {
        return $this->documentStatus;
    }
    /**
     * Set documentStatus value
     * @param string $documentStatus
     * @return \StructType\RequestForPayment
     */
    public function setDocumentStatus($documentStatus = null)
    {
        // validation for constraint: string
        if (!is_null($documentStatus) && !is_string($documentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentStatus, true), gettype($documentStatus)), __LINE__);
        }
        $this->documentStatus = $documentStatus;
        return $this;
    }
    /**
     * Get documentStructureVersion value
     * @return string
     */
    public function getDocumentStructureVersion()
    {
        return $this->documentStructureVersion;
    }
    /**
     * Set documentStructureVersion value
     * @param string $documentStructureVersion
     * @return \StructType\RequestForPayment
     */
    public function setDocumentStructureVersion($documentStructureVersion = null)
    {
        // validation for constraint: string
        if (!is_null($documentStructureVersion) && !is_string($documentStructureVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentStructureVersion, true), gettype($documentStructureVersion)), __LINE__);
        }
        $this->documentStructureVersion = $documentStructureVersion;
        return $this;
    }
    /**
     * Get requestForPaymentIdentification value
     * @return \StructType\RequestForPaymentIdentification|null
     */
    public function getRequestForPaymentIdentification()
    {
        return $this->requestForPaymentIdentification;
    }
    /**
     * Set requestForPaymentIdentification value
     * @param \StructType\RequestForPaymentIdentification $requestForPaymentIdentification
     * @return \StructType\RequestForPayment
     */
    public function setRequestForPaymentIdentification(\StructType\RequestForPaymentIdentification $requestForPaymentIdentification = null)
    {
        $this->requestForPaymentIdentification = $requestForPaymentIdentification;
        return $this;
    }
    /**
     * Get specialInstruction value
     * @return \StructType\SpecialInstruction[]|null
     */
    public function getSpecialInstruction()
    {
        return $this->specialInstruction;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecialInstruction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialInstruction method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecialInstructionForArrayConstraintsFromSetSpecialInstruction(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requestForPaymentSpecialInstructionItem) {
            // validation for constraint: itemType
            if (!$requestForPaymentSpecialInstructionItem instanceof \StructType\SpecialInstruction) {
                $invalidValues[] = is_object($requestForPaymentSpecialInstructionItem) ? get_class($requestForPaymentSpecialInstructionItem) : sprintf('%s(%s)', gettype($requestForPaymentSpecialInstructionItem), var_export($requestForPaymentSpecialInstructionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The specialInstruction property can only contain items of type \StructType\SpecialInstruction, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set specialInstruction value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialInstruction[] $specialInstruction
     * @return \StructType\RequestForPayment
     */
    public function setSpecialInstruction(array $specialInstruction = array())
    {
        // validation for constraint: array
        if ('' !== ($specialInstructionArrayErrorMessage = self::validateSpecialInstructionForArrayConstraintsFromSetSpecialInstruction($specialInstruction))) {
            throw new \InvalidArgumentException($specialInstructionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($specialInstruction) && count($specialInstruction) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 4', count($specialInstruction)), __LINE__);
        }
        $this->specialInstruction = $specialInstruction;
        return $this;
    }
    /**
     * Add item to specialInstruction value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialInstruction $item
     * @return \StructType\RequestForPayment
     */
    public function addToSpecialInstruction(\StructType\SpecialInstruction $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SpecialInstruction) {
            throw new \InvalidArgumentException(sprintf('The specialInstruction property can only contain items of type \StructType\SpecialInstruction, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($this->specialInstruction) && count($this->specialInstruction) >= 4) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 4', count($this->specialInstruction)), __LINE__);
        }
        $this->specialInstruction[] = $item;
        return $this;
    }
    /**
     * Get orderIdentification value
     * @return \StructType\OrderIdentification|null
     */
    public function getOrderIdentification()
    {
        return $this->orderIdentification;
    }
    /**
     * Set orderIdentification value
     * @param \StructType\OrderIdentification $orderIdentification
     * @return \StructType\RequestForPayment
     */
    public function setOrderIdentification(\StructType\OrderIdentification $orderIdentification = null)
    {
        $this->orderIdentification = $orderIdentification;
        return $this;
    }
    /**
     * Get AdditionalInformation value
     * @return \StructType\AdditionalInformation|null
     */
    public function getAdditionalInformation()
    {
        return $this->AdditionalInformation;
    }
    /**
     * Set AdditionalInformation value
     * @param \StructType\AdditionalInformation $additionalInformation
     * @return \StructType\RequestForPayment
     */
    public function setAdditionalInformation(\StructType\AdditionalInformation $additionalInformation = null)
    {
        $this->AdditionalInformation = $additionalInformation;
        return $this;
    }
    /**
     * Get DeliveryNote value
     * @return \StructType\DeliveryNote|null
     */
    public function getDeliveryNote()
    {
        return $this->DeliveryNote;
    }
    /**
     * Set DeliveryNote value
     * @param \StructType\DeliveryNote $deliveryNote
     * @return \StructType\RequestForPayment
     */
    public function setDeliveryNote(\StructType\DeliveryNote $deliveryNote = null)
    {
        $this->DeliveryNote = $deliveryNote;
        return $this;
    }
    /**
     * Get buyer value
     * @return \StructType\Buyer|null
     */
    public function getBuyer()
    {
        return $this->buyer;
    }
    /**
     * Set buyer value
     * @param \StructType\Buyer $buyer
     * @return \StructType\RequestForPayment
     */
    public function setBuyer(\StructType\Buyer $buyer = null)
    {
        $this->buyer = $buyer;
        return $this;
    }
    /**
     * Get seller value
     * @return \StructType\Seller|null
     */
    public function getSeller()
    {
        return $this->seller;
    }
    /**
     * Set seller value
     * @param \StructType\Seller $seller
     * @return \StructType\RequestForPayment
     */
    public function setSeller(\StructType\Seller $seller = null)
    {
        $this->seller = $seller;
        return $this;
    }
    /**
     * Get shipTo value
     * @return \StructType\ShipTo|null
     */
    public function getShipTo()
    {
        return $this->shipTo;
    }
    /**
     * Set shipTo value
     * @param \StructType\ShipTo $shipTo
     * @return \StructType\RequestForPayment
     */
    public function setShipTo(\StructType\ShipTo $shipTo = null)
    {
        $this->shipTo = $shipTo;
        return $this;
    }
    /**
     * Get InvoiceCreator value
     * @return \StructType\InvoiceCreator|null
     */
    public function getInvoiceCreator()
    {
        return $this->InvoiceCreator;
    }
    /**
     * Set InvoiceCreator value
     * @param \StructType\InvoiceCreator $invoiceCreator
     * @return \StructType\RequestForPayment
     */
    public function setInvoiceCreator(\StructType\InvoiceCreator $invoiceCreator = null)
    {
        $this->InvoiceCreator = $invoiceCreator;
        return $this;
    }
    /**
     * Get Customs value
     * @return \StructType\Customs[]|null
     */
    public function getCustoms()
    {
        return $this->Customs;
    }
    /**
     * This method is responsible for validating the values passed to the setCustoms method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustoms method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomsForArrayConstraintsFromSetCustoms(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requestForPaymentCustomsItem) {
            // validation for constraint: itemType
            if (!$requestForPaymentCustomsItem instanceof \StructType\Customs) {
                $invalidValues[] = is_object($requestForPaymentCustomsItem) ? get_class($requestForPaymentCustomsItem) : sprintf('%s(%s)', gettype($requestForPaymentCustomsItem), var_export($requestForPaymentCustomsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Customs property can only contain items of type \StructType\Customs, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Customs value
     * @throws \InvalidArgumentException
     * @param \StructType\Customs[] $customs
     * @return \StructType\RequestForPayment
     */
    public function setCustoms(array $customs = array())
    {
        // validation for constraint: array
        if ('' !== ($customsArrayErrorMessage = self::validateCustomsForArrayConstraintsFromSetCustoms($customs))) {
            throw new \InvalidArgumentException($customsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(999999)
        if (is_array($customs) && count($customs) > 999999) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 999999', count($customs)), __LINE__);
        }
        $this->Customs = $customs;
        return $this;
    }
    /**
     * Add item to Customs value
     * @throws \InvalidArgumentException
     * @param \StructType\Customs $item
     * @return \StructType\RequestForPayment
     */
    public function addToCustoms(\StructType\Customs $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Customs) {
            throw new \InvalidArgumentException(sprintf('The Customs property can only contain items of type \StructType\Customs, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(999999)
        if (is_array($this->Customs) && count($this->Customs) >= 999999) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 999999', count($this->Customs)), __LINE__);
        }
        $this->Customs[] = $item;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\Currency[]|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * This method is responsible for validating the values passed to the setCurrency method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCurrency method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCurrencyForArrayConstraintsFromSetCurrency(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requestForPaymentCurrencyItem) {
            // validation for constraint: itemType
            if (!$requestForPaymentCurrencyItem instanceof \StructType\Currency) {
                $invalidValues[] = is_object($requestForPaymentCurrencyItem) ? get_class($requestForPaymentCurrencyItem) : sprintf('%s(%s)', gettype($requestForPaymentCurrencyItem), var_export($requestForPaymentCurrencyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The currency property can only contain items of type \StructType\Currency, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set currency value
     * @throws \InvalidArgumentException
     * @param \StructType\Currency[] $currency
     * @return \StructType\RequestForPayment
     */
    public function setCurrency(array $currency = array())
    {
        // validation for constraint: array
        if ('' !== ($currencyArrayErrorMessage = self::validateCurrencyForArrayConstraintsFromSetCurrency($currency))) {
            throw new \InvalidArgumentException($currencyArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($currency) && count($currency) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Add item to currency value
     * @throws \InvalidArgumentException
     * @param \StructType\Currency $item
     * @return \StructType\RequestForPayment
     */
    public function addToCurrency(\StructType\Currency $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Currency) {
            throw new \InvalidArgumentException(sprintf('The currency property can only contain items of type \StructType\Currency, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->currency) && count($this->currency) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->currency)), __LINE__);
        }
        $this->currency[] = $item;
        return $this;
    }
    /**
     * Get paymentTerms value
     * @return \StructType\PaymentTerms|null
     */
    public function getPaymentTerms()
    {
        return $this->paymentTerms;
    }
    /**
     * Set paymentTerms value
     * @param \StructType\PaymentTerms $paymentTerms
     * @return \StructType\RequestForPayment
     */
    public function setPaymentTerms(\StructType\PaymentTerms $paymentTerms = null)
    {
        $this->paymentTerms = $paymentTerms;
        return $this;
    }
    /**
     * Get shipmentDetail value
     * @return mixed|null
     */
    public function getShipmentDetail()
    {
        return $this->shipmentDetail;
    }
    /**
     * Set shipmentDetail value
     * @param mixed $shipmentDetail
     * @return \StructType\RequestForPayment
     */
    public function setShipmentDetail($shipmentDetail = null)
    {
        $this->shipmentDetail = $shipmentDetail;
        return $this;
    }
    /**
     * Get allowanceCharge value
     * @return \StructType\AllowanceCharge[]|null
     */
    public function getAllowanceCharge()
    {
        return $this->allowanceCharge;
    }
    /**
     * This method is responsible for validating the values passed to the setAllowanceCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAllowanceCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAllowanceChargeForArrayConstraintsFromSetAllowanceCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requestForPaymentAllowanceChargeItem) {
            // validation for constraint: itemType
            if (!$requestForPaymentAllowanceChargeItem instanceof \StructType\AllowanceCharge) {
                $invalidValues[] = is_object($requestForPaymentAllowanceChargeItem) ? get_class($requestForPaymentAllowanceChargeItem) : sprintf('%s(%s)', gettype($requestForPaymentAllowanceChargeItem), var_export($requestForPaymentAllowanceChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The allowanceCharge property can only contain items of type \StructType\AllowanceCharge, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set allowanceCharge value
     * @throws \InvalidArgumentException
     * @param \StructType\AllowanceCharge[] $allowanceCharge
     * @return \StructType\RequestForPayment
     */
    public function setAllowanceCharge(array $allowanceCharge = array())
    {
        // validation for constraint: array
        if ('' !== ($allowanceChargeArrayErrorMessage = self::validateAllowanceChargeForArrayConstraintsFromSetAllowanceCharge($allowanceCharge))) {
            throw new \InvalidArgumentException($allowanceChargeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($allowanceCharge) && count($allowanceCharge) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($allowanceCharge)), __LINE__);
        }
        $this->allowanceCharge = $allowanceCharge;
        return $this;
    }
    /**
     * Add item to allowanceCharge value
     * @throws \InvalidArgumentException
     * @param \StructType\AllowanceCharge $item
     * @return \StructType\RequestForPayment
     */
    public function addToAllowanceCharge(\StructType\AllowanceCharge $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AllowanceCharge) {
            throw new \InvalidArgumentException(sprintf('The allowanceCharge property can only contain items of type \StructType\AllowanceCharge, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->allowanceCharge) && count($this->allowanceCharge) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->allowanceCharge)), __LINE__);
        }
        $this->allowanceCharge[] = $item;
        return $this;
    }
    /**
     * Get lineItem value
     * @return \StructType\LineItem[]|null
     */
    public function getLineItem()
    {
        return $this->lineItem;
    }
    /**
     * This method is responsible for validating the values passed to the setLineItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLineItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLineItemForArrayConstraintsFromSetLineItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requestForPaymentLineItemItem) {
            // validation for constraint: itemType
            if (!$requestForPaymentLineItemItem instanceof \StructType\LineItem) {
                $invalidValues[] = is_object($requestForPaymentLineItemItem) ? get_class($requestForPaymentLineItemItem) : sprintf('%s(%s)', gettype($requestForPaymentLineItemItem), var_export($requestForPaymentLineItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The lineItem property can only contain items of type \StructType\LineItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set lineItem value
     * @throws \InvalidArgumentException
     * @param \StructType\LineItem[] $lineItem
     * @return \StructType\RequestForPayment
     */
    public function setLineItem(array $lineItem = array())
    {
        // validation for constraint: array
        if ('' !== ($lineItemArrayErrorMessage = self::validateLineItemForArrayConstraintsFromSetLineItem($lineItem))) {
            throw new \InvalidArgumentException($lineItemArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9999999)
        if (is_array($lineItem) && count($lineItem) > 9999999) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9999999', count($lineItem)), __LINE__);
        }
        $this->lineItem = $lineItem;
        return $this;
    }
    /**
     * Add item to lineItem value
     * @throws \InvalidArgumentException
     * @param \StructType\LineItem $item
     * @return \StructType\RequestForPayment
     */
    public function addToLineItem(\StructType\LineItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LineItem) {
            throw new \InvalidArgumentException(sprintf('The lineItem property can only contain items of type \StructType\LineItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9999999)
        if (is_array($this->lineItem) && count($this->lineItem) >= 9999999) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9999999', count($this->lineItem)), __LINE__);
        }
        $this->lineItem[] = $item;
        return $this;
    }
    /**
     * Get totalAmount value
     * @return \StructType\TotalAmount|null
     */
    public function getTotalAmount()
    {
        return $this->totalAmount;
    }
    /**
     * Set totalAmount value
     * @param \StructType\TotalAmount $totalAmount
     * @return \StructType\RequestForPayment
     */
    public function setTotalAmount(\StructType\TotalAmount $totalAmount = null)
    {
        $this->totalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get TotalAllowanceCharge value
     * @return \StructType\TotalAllowanceCharge[]|null
     */
    public function getTotalAllowanceCharge()
    {
        return $this->TotalAllowanceCharge;
    }
    /**
     * This method is responsible for validating the values passed to the setTotalAllowanceCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTotalAllowanceCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTotalAllowanceChargeForArrayConstraintsFromSetTotalAllowanceCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requestForPaymentTotalAllowanceChargeItem) {
            // validation for constraint: itemType
            if (!$requestForPaymentTotalAllowanceChargeItem instanceof \StructType\TotalAllowanceCharge) {
                $invalidValues[] = is_object($requestForPaymentTotalAllowanceChargeItem) ? get_class($requestForPaymentTotalAllowanceChargeItem) : sprintf('%s(%s)', gettype($requestForPaymentTotalAllowanceChargeItem), var_export($requestForPaymentTotalAllowanceChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TotalAllowanceCharge property can only contain items of type \StructType\TotalAllowanceCharge, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TotalAllowanceCharge value
     * @throws \InvalidArgumentException
     * @param \StructType\TotalAllowanceCharge[] $totalAllowanceCharge
     * @return \StructType\RequestForPayment
     */
    public function setTotalAllowanceCharge(array $totalAllowanceCharge = array())
    {
        // validation for constraint: array
        if ('' !== ($totalAllowanceChargeArrayErrorMessage = self::validateTotalAllowanceChargeForArrayConstraintsFromSetTotalAllowanceCharge($totalAllowanceCharge))) {
            throw new \InvalidArgumentException($totalAllowanceChargeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(999999)
        if (is_array($totalAllowanceCharge) && count($totalAllowanceCharge) > 999999) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 999999', count($totalAllowanceCharge)), __LINE__);
        }
        $this->TotalAllowanceCharge = $totalAllowanceCharge;
        return $this;
    }
    /**
     * Add item to TotalAllowanceCharge value
     * @throws \InvalidArgumentException
     * @param \StructType\TotalAllowanceCharge $item
     * @return \StructType\RequestForPayment
     */
    public function addToTotalAllowanceCharge(\StructType\TotalAllowanceCharge $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TotalAllowanceCharge) {
            throw new \InvalidArgumentException(sprintf('The TotalAllowanceCharge property can only contain items of type \StructType\TotalAllowanceCharge, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(999999)
        if (is_array($this->TotalAllowanceCharge) && count($this->TotalAllowanceCharge) >= 999999) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 999999', count($this->TotalAllowanceCharge)), __LINE__);
        }
        $this->TotalAllowanceCharge[] = $item;
        return $this;
    }
    /**
     * Get baseAmount value
     * @return \StructType\BaseAmount|null
     */
    public function getBaseAmount()
    {
        return $this->baseAmount;
    }
    /**
     * Set baseAmount value
     * @param \StructType\BaseAmount $baseAmount
     * @return \StructType\RequestForPayment
     */
    public function setBaseAmount(\StructType\BaseAmount $baseAmount = null)
    {
        $this->baseAmount = $baseAmount;
        return $this;
    }
    /**
     * Get tax value
     * @return \StructType\Tax[]|null
     */
    public function getTax()
    {
        return $this->tax;
    }
    /**
     * This method is responsible for validating the values passed to the setTax method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTax method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxForArrayConstraintsFromSetTax(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requestForPaymentTaxItem) {
            // validation for constraint: itemType
            if (!$requestForPaymentTaxItem instanceof \StructType\Tax) {
                $invalidValues[] = is_object($requestForPaymentTaxItem) ? get_class($requestForPaymentTaxItem) : sprintf('%s(%s)', gettype($requestForPaymentTaxItem), var_export($requestForPaymentTaxItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The tax property can only contain items of type \StructType\Tax, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set tax value
     * @throws \InvalidArgumentException
     * @param \StructType\Tax[] $tax
     * @return \StructType\RequestForPayment
     */
    public function setTax(array $tax = array())
    {
        // validation for constraint: array
        if ('' !== ($taxArrayErrorMessage = self::validateTaxForArrayConstraintsFromSetTax($tax))) {
            throw new \InvalidArgumentException($taxArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($tax) && count($tax) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($tax)), __LINE__);
        }
        $this->tax = $tax;
        return $this;
    }
    /**
     * Add item to tax value
     * @throws \InvalidArgumentException
     * @param \StructType\Tax $item
     * @return \StructType\RequestForPayment
     */
    public function addToTax(\StructType\Tax $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Tax) {
            throw new \InvalidArgumentException(sprintf('The tax property can only contain items of type \StructType\Tax, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->tax) && count($this->tax) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->tax)), __LINE__);
        }
        $this->tax[] = $item;
        return $this;
    }
    /**
     * Get payableAmount value
     * @return \StructType\PayableAmount|null
     */
    public function getPayableAmount()
    {
        return $this->payableAmount;
    }
    /**
     * Set payableAmount value
     * @param \StructType\PayableAmount $payableAmount
     * @return \StructType\RequestForPayment
     */
    public function setPayableAmount(\StructType\PayableAmount $payableAmount = null)
    {
        $this->payableAmount = $payableAmount;
        return $this;
    }
    /**
     * Get DeliveryDate value
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return $this->DeliveryDate;
    }
    /**
     * Set DeliveryDate value
     * @param string $deliveryDate
     * @return \StructType\RequestForPayment
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        $this->DeliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get contentVersion value
     * @return string|null
     */
    public function getContentVersion()
    {
        return $this->contentVersion;
    }
    /**
     * Set contentVersion value
     * @param string $contentVersion
     * @return \StructType\RequestForPayment
     */
    public function setContentVersion($contentVersion = '1.3.1')
    {
        // validation for constraint: string
        if (!is_null($contentVersion) && !is_string($contentVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentVersion, true), gettype($contentVersion)), __LINE__);
        }
        $this->contentVersion = $contentVersion;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\RequestForPayment
     */
    public function setType($type = 'SimpleInvoiceType')
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
}
