<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReferenceNumber StructType
 * @subpackage Structs
 */
class ReferenceNumber extends AbstractStructBase
{
    /**
     * The referenceIdentification
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - form: qualified
     * @var string
     */
    public $referenceIdentification;
    /**
     * The referenceDate
     * Meta information extracted from the WSDL
     * - documentation: SG1 DTM 2380 CALF 171
     * - base: xsd:string
     * - form: qualified
     * - length: 8
     * @var string
     */
    public $referenceDate;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * Constructor method for ReferenceNumber
     * @uses ReferenceNumber::setReferenceIdentification()
     * @uses ReferenceNumber::setReferenceDate()
     * @uses ReferenceNumber::setType()
     * @param string $referenceIdentification
     * @param string $referenceDate
     * @param string $type
     */
    public function __construct($referenceIdentification = null, $referenceDate = null, $type = null)
    {
        $this
            ->setReferenceIdentification($referenceIdentification)
            ->setReferenceDate($referenceDate)
            ->setType($type);
    }
    /**
     * Get referenceIdentification value
     * @return string|null
     */
    public function getReferenceIdentification()
    {
        return $this->referenceIdentification;
    }
    /**
     * Set referenceIdentification value
     * @param string $referenceIdentification
     * @return \StructType\ReferenceNumber
     */
    public function setReferenceIdentification($referenceIdentification = null)
    {
        // validation for constraint: string
        if (!is_null($referenceIdentification) && !is_string($referenceIdentification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceIdentification, true), gettype($referenceIdentification)), __LINE__);
        }
        $this->referenceIdentification = $referenceIdentification;
        return $this;
    }
    /**
     * Get referenceDate value
     * @return string|null
     */
    public function getReferenceDate()
    {
        return $this->referenceDate;
    }
    /**
     * Set referenceDate value
     * @param string $referenceDate
     * @return \StructType\ReferenceNumber
     */
    public function setReferenceDate($referenceDate = null)
    {
        // validation for constraint: string
        if (!is_null($referenceDate) && !is_string($referenceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceDate, true), gettype($referenceDate)), __LINE__);
        }
        // validation for constraint: length(8)
        if (!is_null($referenceDate) && mb_strlen($referenceDate) !== 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 8', mb_strlen($referenceDate)), __LINE__);
        }
        $this->referenceDate = $referenceDate;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\ReferenceNumber
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
}
