<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for referenceIdentification StructType
 * Meta information extracted from the WSDL
 * - documentation: SG1 RFF 1154 CALF ZZZ | SG1 RFF 1154 CALF AAK | SG1 RFF 1154 CALF ACE | SG1 RFF 1154 CALF IA | SG1 RFF 1154 CALF IV | Nodo opcional que especifica la referencia adicional de los productos | Nodo requerido que especifica el numero de
 * folio. Número emitido por el comprador cuando recibe la mercancía que es facturada | Nodo requerido que especifica el número de referencia adicional | Nodo requerido que especifica el número de orden de compra (comprador) a la que hace referencia
 * la factura
 * @subpackage Structs
 */
class ReferenceIdentification extends AbstractStructBase
{
    /**
     * The type
     * Meta information extracted from the WSDL
     * - fixed: ON
     * - use: required
     * @var string
     */
    public $type;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * Constructor method for referenceIdentification
     * @uses ReferenceIdentification::setType()
     * @uses ReferenceIdentification::set_()
     * @param string $type
     * @param string $_
     */
    public function __construct($type = null, $_ = null)
    {
        $this
            ->setType($type)
            ->set_($_);
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\ReferenceIdentification
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\ReferenceIdentification
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
}
