<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Receptor StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo requerido para precisar la información del contribuyente receptor del comprobante.
 * @subpackage Structs
 */
class Receptor extends AbstractStructBase
{
    /**
     * The Rfc
     * Meta information extracted from the WSDL
     * - documentation: Atributo requerido para precisar la Clave del Registro Federal de Contribuyentes correspondiente al contribuyente receptor del comprobante. | Tipo definido para expresar claves del Registro Federal de Contribuyentes
     * - base: xs:string
     * - maxLength: 13
     * - minLength: 12
     * - pattern: [A-Z&Ñ]{3,4}[0-9]{2}(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])[A-Z0-9]{2}[0-9A]
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $Rfc;
    /**
     * The UsoCFDI
     * Meta information extracted from the WSDL
     * - documentation: Atributo requerido para expresar la clave del uso que dará a esta factura el receptor del CFDI.
     * - use: required
     * @var string
     */
    public $UsoCFDI;
    /**
     * The Nombre
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 254
     * - minLength: 1
     * - pattern: [^|]{1,254}
     * - whiteSpace: collapse
     * @var string
     */
    public $Nombre;
    /**
     * The NumRegIdTrib
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 40
     * - minLength: 1
     * - whiteSpace: collapse
     * @var string
     */
    public $NumRegIdTrib;
    /**
     * The ResidenciaFiscal
     * Meta information extracted from the WSDL
     * - documentation: Atributo condicional para registrar la clave del país de residencia para efectos fiscales del receptor del comprobante, cuando se trate de un extranjero, y que es conforme con la especificación ISO 3166-1 alpha-3. Es requerido
     * cuando se incluya el complemento de comercio exterior o se registre el atributo NumRegIdTrib.
     * - base: xs:string
     * - whiteSpace: collapse
     * @var string
     */
    public $ResidenciaFiscal;
    /**
     * Constructor method for Receptor
     * @uses Receptor::setRfc()
     * @uses Receptor::setUsoCFDI()
     * @uses Receptor::setNombre()
     * @uses Receptor::setNumRegIdTrib()
     * @uses Receptor::setResidenciaFiscal()
     * @param string $rfc
     * @param string $usoCFDI
     * @param string $nombre
     * @param string $numRegIdTrib
     * @param string $residenciaFiscal
     */
    public function __construct($rfc = null, $usoCFDI = null, $nombre = null, $numRegIdTrib = null, $residenciaFiscal = null)
    {
        $this
            ->setRfc($rfc)
            ->setUsoCFDI($usoCFDI)
            ->setNombre($nombre)
            ->setNumRegIdTrib($numRegIdTrib)
            ->setResidenciaFiscal($residenciaFiscal);
    }
    /**
     * Get Rfc value
     * @return string
     */
    public function getRfc()
    {
        return $this->Rfc;
    }
    /**
     * Set Rfc value
     * @param string $rfc
     * @return \StructType\Receptor
     */
    public function setRfc($rfc = null)
    {
        // validation for constraint: string
        if (!is_null($rfc) && !is_string($rfc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rfc, true), gettype($rfc)), __LINE__);
        }
        // validation for constraint: maxLength(13)
        if (!is_null($rfc) && mb_strlen($rfc) > 13) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 13', mb_strlen($rfc)), __LINE__);
        }
        // validation for constraint: minLength(12)
        if (!is_null($rfc) && mb_strlen($rfc) < 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 12', mb_strlen($rfc)), __LINE__);
        }
        // validation for constraint: pattern([A-Z&Ñ]{3,4}[0-9]{2}(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])[A-Z0-9]{2}[0-9A])
        if (!is_null($rfc) && !preg_match('/[A-Z&Ñ]{3,4}[0-9]{2}(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])[A-Z0-9]{2}[0-9A]/', $rfc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z&Ñ]{3,4}[0-9]{2}(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])[A-Z0-9]{2}[0-9A]', var_export($rfc, true)), __LINE__);
        }
        $this->Rfc = $rfc;
        return $this;
    }
    /**
     * Get UsoCFDI value
     * @return string
     */
    public function getUsoCFDI()
    {
        return $this->UsoCFDI;
    }
    /**
     * Set UsoCFDI value
     * @uses \EnumType\C_UsoCFDI::valueIsValid()
     * @uses \EnumType\C_UsoCFDI::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $usoCFDI
     * @return \StructType\Receptor
     */
    public function setUsoCFDI($usoCFDI = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\C_UsoCFDI::valueIsValid($usoCFDI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\C_UsoCFDI', is_array($usoCFDI) ? implode(', ', $usoCFDI) : var_export($usoCFDI, true), implode(', ', \EnumType\C_UsoCFDI::getValidValues())), __LINE__);
        }
        $this->UsoCFDI = $usoCFDI;
        return $this;
    }
    /**
     * Get Nombre value
     * @return string|null
     */
    public function getNombre()
    {
        return $this->Nombre;
    }
    /**
     * Set Nombre value
     * @param string $nombre
     * @return \StructType\Receptor
     */
    public function setNombre($nombre = null)
    {
        // validation for constraint: string
        if (!is_null($nombre) && !is_string($nombre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nombre, true), gettype($nombre)), __LINE__);
        }
        // validation for constraint: maxLength(254)
        if (!is_null($nombre) && mb_strlen($nombre) > 254) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 254', mb_strlen($nombre)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nombre) && mb_strlen($nombre) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nombre)), __LINE__);
        }
        // validation for constraint: pattern([^|]{1,254})
        if (!is_null($nombre) && !preg_match('/[^|]{1,254}/', $nombre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^|]{1,254}', var_export($nombre, true)), __LINE__);
        }
        $this->Nombre = $nombre;
        return $this;
    }
    /**
     * Get NumRegIdTrib value
     * @return string|null
     */
    public function getNumRegIdTrib()
    {
        return $this->NumRegIdTrib;
    }
    /**
     * Set NumRegIdTrib value
     * @param string $numRegIdTrib
     * @return \StructType\Receptor
     */
    public function setNumRegIdTrib($numRegIdTrib = null)
    {
        // validation for constraint: string
        if (!is_null($numRegIdTrib) && !is_string($numRegIdTrib)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numRegIdTrib, true), gettype($numRegIdTrib)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($numRegIdTrib) && mb_strlen($numRegIdTrib) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($numRegIdTrib)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($numRegIdTrib) && mb_strlen($numRegIdTrib) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($numRegIdTrib)), __LINE__);
        }
        $this->NumRegIdTrib = $numRegIdTrib;
        return $this;
    }
    /**
     * Get ResidenciaFiscal value
     * @return string|null
     */
    public function getResidenciaFiscal()
    {
        return $this->ResidenciaFiscal;
    }
    /**
     * Set ResidenciaFiscal value
     * @param string $residenciaFiscal
     * @return \StructType\Receptor
     */
    public function setResidenciaFiscal($residenciaFiscal = null)
    {
        // validation for constraint: string
        if (!is_null($residenciaFiscal) && !is_string($residenciaFiscal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residenciaFiscal, true), gettype($residenciaFiscal)), __LINE__);
        }
        $this->ResidenciaFiscal = $residenciaFiscal;
        return $this;
    }
}
