<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ratePerUnit StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo opcional que especifica la Tarifa por unidad
 * @subpackage Structs
 */
class RatePerUnit extends AbstractStructBase
{
    /**
     * The amountPerUnit
     * Meta information extracted from the WSDL
     * - documentation: Nodo requerido que especifica el importe monetario del cargo o descuento por unidad
     * - base: xs:string
     * - maxLength: 36
     * - minLength: 1
     * @var string
     */
    public $amountPerUnit;
    /**
     * Constructor method for ratePerUnit
     * @uses RatePerUnit::setAmountPerUnit()
     * @param string $amountPerUnit
     */
    public function __construct($amountPerUnit = null)
    {
        $this
            ->setAmountPerUnit($amountPerUnit);
    }
    /**
     * Get amountPerUnit value
     * @return string|null
     */
    public function getAmountPerUnit()
    {
        return $this->amountPerUnit;
    }
    /**
     * Set amountPerUnit value
     * @param string $amountPerUnit
     * @return \StructType\RatePerUnit
     */
    public function setAmountPerUnit($amountPerUnit = null)
    {
        // validation for constraint: string
        if (!is_null($amountPerUnit) && !is_string($amountPerUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amountPerUnit, true), gettype($amountPerUnit)), __LINE__);
        }
        // validation for constraint: maxLength(36)
        if (!is_null($amountPerUnit) && mb_strlen($amountPerUnit) > 36) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 36', mb_strlen($amountPerUnit)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($amountPerUnit) && mb_strlen($amountPerUnit) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($amountPerUnit)), __LINE__);
        }
        $this->amountPerUnit = $amountPerUnit;
        return $this;
    }
}
