<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for rate StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo opcional que especifica la tarifa
 * @subpackage Structs
 */
class Rate extends AbstractStructBase
{
    /**
     * The base
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $base;
    /**
     * The percentage
     * Meta information extracted from the WSDL
     * - documentation: Nodo opcional que especifica el porcentaje de descuento que se está aplicando según se ha indicado en el campo anterior a toda la factura
     * @var float
     */
    public $percentage;
    /**
     * Constructor method for rate
     * @uses Rate::setBase()
     * @uses Rate::setPercentage()
     * @param string $base
     * @param float $percentage
     */
    public function __construct($base = null, $percentage = null)
    {
        $this
            ->setBase($base)
            ->setPercentage($percentage);
    }
    /**
     * Get base value
     * @return string
     */
    public function getBase()
    {
        return $this->base;
    }
    /**
     * Set base value
     * @param string $base
     * @return \StructType\Rate
     */
    public function setBase($base = null)
    {
        // validation for constraint: string
        if (!is_null($base) && !is_string($base)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($base, true), gettype($base)), __LINE__);
        }
        $this->base = $base;
        return $this;
    }
    /**
     * Get percentage value
     * @return float|null
     */
    public function getPercentage()
    {
        return $this->percentage;
    }
    /**
     * Set percentage value
     * @param float $percentage
     * @return \StructType\Rate
     */
    public function setPercentage($percentage = null)
    {
        // validation for constraint: float
        if (!is_null($percentage) && !(is_float($percentage) || is_numeric($percentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentage, true), gettype($percentage)), __LINE__);
        }
        $this->percentage = $percentage;
        return $this;
    }
}
