<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrestadoresDeServiciosDeCFD StructType
 * Meta information extracted from the WSDL
 * - documentation: Complemento requerido para los Proveedores de Servicio de generación y envío de Comprobantes Fiscales Digitales.
 * @subpackage Structs
 */
class PrestadoresDeServiciosDeCFD extends AbstractStructBase
{
    /**
     * The fechaAutorizacion
     * Meta information extracted from the WSDL
     * - base: xs:dateTime
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $fechaAutorizacion;
    /**
     * The noAutorizacion
     * Meta information extracted from the WSDL
     * - base: xs:integer
     * - use: required
     * - whiteSpace: collapse
     * @var int
     */
    public $noAutorizacion;
    /**
     * The noCertificado
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - length: 20
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $noCertificado;
    /**
     * The nombre
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minLength: 1
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $nombre;
    /**
     * The rfc
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 13
     * - minLength: 12
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $rfc;
    /**
     * The selloDelPSGECFD
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $selloDelPSGECFD;
    /**
     * Constructor method for PrestadoresDeServiciosDeCFD
     * @uses PrestadoresDeServiciosDeCFD::setFechaAutorizacion()
     * @uses PrestadoresDeServiciosDeCFD::setNoAutorizacion()
     * @uses PrestadoresDeServiciosDeCFD::setNoCertificado()
     * @uses PrestadoresDeServiciosDeCFD::setNombre()
     * @uses PrestadoresDeServiciosDeCFD::setRfc()
     * @uses PrestadoresDeServiciosDeCFD::setSelloDelPSGECFD()
     * @param string $fechaAutorizacion
     * @param int $noAutorizacion
     * @param string $noCertificado
     * @param string $nombre
     * @param string $rfc
     * @param string $selloDelPSGECFD
     */
    public function __construct($fechaAutorizacion = null, $noAutorizacion = null, $noCertificado = null, $nombre = null, $rfc = null, $selloDelPSGECFD = null)
    {
        $this
            ->setFechaAutorizacion($fechaAutorizacion)
            ->setNoAutorizacion($noAutorizacion)
            ->setNoCertificado($noCertificado)
            ->setNombre($nombre)
            ->setRfc($rfc)
            ->setSelloDelPSGECFD($selloDelPSGECFD);
    }
    /**
     * Get fechaAutorizacion value
     * @return string
     */
    public function getFechaAutorizacion()
    {
        return $this->fechaAutorizacion;
    }
    /**
     * Set fechaAutorizacion value
     * @param string $fechaAutorizacion
     * @return \StructType\PrestadoresDeServiciosDeCFD
     */
    public function setFechaAutorizacion($fechaAutorizacion = null)
    {
        // validation for constraint: string
        if (!is_null($fechaAutorizacion) && !is_string($fechaAutorizacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaAutorizacion, true), gettype($fechaAutorizacion)), __LINE__);
        }
        $this->fechaAutorizacion = $fechaAutorizacion;
        return $this;
    }
    /**
     * Get noAutorizacion value
     * @return int
     */
    public function getNoAutorizacion()
    {
        return $this->noAutorizacion;
    }
    /**
     * Set noAutorizacion value
     * @param int $noAutorizacion
     * @return \StructType\PrestadoresDeServiciosDeCFD
     */
    public function setNoAutorizacion($noAutorizacion = null)
    {
        // validation for constraint: int
        if (!is_null($noAutorizacion) && !(is_int($noAutorizacion) || ctype_digit($noAutorizacion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($noAutorizacion, true), gettype($noAutorizacion)), __LINE__);
        }
        $this->noAutorizacion = $noAutorizacion;
        return $this;
    }
    /**
     * Get noCertificado value
     * @return string
     */
    public function getNoCertificado()
    {
        return $this->noCertificado;
    }
    /**
     * Set noCertificado value
     * @param string $noCertificado
     * @return \StructType\PrestadoresDeServiciosDeCFD
     */
    public function setNoCertificado($noCertificado = null)
    {
        // validation for constraint: string
        if (!is_null($noCertificado) && !is_string($noCertificado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noCertificado, true), gettype($noCertificado)), __LINE__);
        }
        // validation for constraint: length(20)
        if (!is_null($noCertificado) && mb_strlen($noCertificado) !== 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 20', mb_strlen($noCertificado)), __LINE__);
        }
        $this->noCertificado = $noCertificado;
        return $this;
    }
    /**
     * Get nombre value
     * @return string
     */
    public function getNombre()
    {
        return $this->nombre;
    }
    /**
     * Set nombre value
     * @param string $nombre
     * @return \StructType\PrestadoresDeServiciosDeCFD
     */
    public function setNombre($nombre = null)
    {
        // validation for constraint: string
        if (!is_null($nombre) && !is_string($nombre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nombre, true), gettype($nombre)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nombre) && mb_strlen($nombre) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nombre)), __LINE__);
        }
        $this->nombre = $nombre;
        return $this;
    }
    /**
     * Get rfc value
     * @return string
     */
    public function getRfc()
    {
        return $this->rfc;
    }
    /**
     * Set rfc value
     * @param string $rfc
     * @return \StructType\PrestadoresDeServiciosDeCFD
     */
    public function setRfc($rfc = null)
    {
        // validation for constraint: string
        if (!is_null($rfc) && !is_string($rfc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rfc, true), gettype($rfc)), __LINE__);
        }
        // validation for constraint: maxLength(13)
        if (!is_null($rfc) && mb_strlen($rfc) > 13) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 13', mb_strlen($rfc)), __LINE__);
        }
        // validation for constraint: minLength(12)
        if (!is_null($rfc) && mb_strlen($rfc) < 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 12', mb_strlen($rfc)), __LINE__);
        }
        $this->rfc = $rfc;
        return $this;
    }
    /**
     * Get selloDelPSGECFD value
     * @return string
     */
    public function getSelloDelPSGECFD()
    {
        return $this->selloDelPSGECFD;
    }
    /**
     * Set selloDelPSGECFD value
     * @param string $selloDelPSGECFD
     * @return \StructType\PrestadoresDeServiciosDeCFD
     */
    public function setSelloDelPSGECFD($selloDelPSGECFD = null)
    {
        // validation for constraint: string
        if (!is_null($selloDelPSGECFD) && !is_string($selloDelPSGECFD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selloDelPSGECFD, true), gettype($selloDelPSGECFD)), __LINE__);
        }
        $this->selloDelPSGECFD = $selloDelPSGECFD;
        return $this;
    }
}
