<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PorCuentadeTerceros StructType
 * Meta information extracted from the WSDL
 * - documentation: Complemento concepto para la emisión de Comprobante Fiscal Digital (CFD) y Comprobante Fiscal Digital a través de Internet (CFDI) por orden y cuenta de terceros.
 * @subpackage Structs
 */
class PorCuentadeTerceros extends AbstractStructBase
{
    /**
     * The rfc
     * Meta information extracted from the WSDL
     * - documentation: Atributo requerido para la Clave del Registro Federal de Contribuyentes correspondiente al contribuyente emisor del comprobante sin guiones o espacios. | Tipo definido para expresar claves del Registro Federal de Contribuyentes
     * - base: xs:string
     * - maxLength: 13
     * - minLength: 12
     * - pattern: [A-Z&Ñ]{3,4}[0-9]{2}(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])[A-Z0-9]{2}[0-9A]
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $rfc;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - documentation: Atributo requerido con valor prefijado a 1.1 que indica la versión del estandar bajo el que se encuentra expresado el complemento.
     * - fixed: 1.1
     * - use: required
     * @var anySimpleType
     */
    public $version;
    /**
     * The InformacionFiscalTercero
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InformacionFiscalTercero
     */
    public $InformacionFiscalTercero;
    /**
     * The CuentaPredial
     * Meta information extracted from the WSDL
     * - choice: CuentaPredial | InformacionAduanera | Parte
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CuentaPredial
     */
    public $CuentaPredial;
    /**
     * The InformacionAduanera
     * Meta information extracted from the WSDL
     * - choice: CuentaPredial | InformacionAduanera | Parte
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InformacionAduanera
     */
    public $InformacionAduanera;
    /**
     * The Parte
     * Meta information extracted from the WSDL
     * - choice: CuentaPredial | InformacionAduanera | Parte
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Parte[]
     */
    public $Parte;
    /**
     * The Impuestos
     * @var \StructType\Impuestos
     */
    public $Impuestos;
    /**
     * The nombre
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minLength: 1
     * - whiteSpace: collapse
     * @var string
     */
    public $nombre;
    /**
     * Constructor method for PorCuentadeTerceros
     * @uses PorCuentadeTerceros::setRfc()
     * @uses PorCuentadeTerceros::setVersion()
     * @uses PorCuentadeTerceros::setInformacionFiscalTercero()
     * @uses PorCuentadeTerceros::setCuentaPredial()
     * @uses PorCuentadeTerceros::setInformacionAduanera()
     * @uses PorCuentadeTerceros::setParte()
     * @uses PorCuentadeTerceros::setImpuestos()
     * @uses PorCuentadeTerceros::setNombre()
     * @param string $rfc
     * @param anySimpleType $version
     * @param \StructType\InformacionFiscalTercero $informacionFiscalTercero
     * @param \StructType\CuentaPredial $cuentaPredial
     * @param \StructType\InformacionAduanera $informacionAduanera
     * @param \StructType\Parte[] $parte
     * @param \StructType\Impuestos $impuestos
     * @param string $nombre
     */
    public function __construct($rfc = null, anySimpleType $version = null, \StructType\InformacionFiscalTercero $informacionFiscalTercero = null, \StructType\CuentaPredial $cuentaPredial = null, \StructType\InformacionAduanera $informacionAduanera = null, array $parte = array(), \StructType\Impuestos $impuestos = null, $nombre = null)
    {
        $this
            ->setRfc($rfc)
            ->setVersion($version)
            ->setInformacionFiscalTercero($informacionFiscalTercero)
            ->setCuentaPredial($cuentaPredial)
            ->setInformacionAduanera($informacionAduanera)
            ->setParte($parte)
            ->setImpuestos($impuestos)
            ->setNombre($nombre);
    }
    /**
     * Get rfc value
     * @return string
     */
    public function getRfc()
    {
        return $this->rfc;
    }
    /**
     * Set rfc value
     * @param string $rfc
     * @return \StructType\PorCuentadeTerceros
     */
    public function setRfc($rfc = null)
    {
        // validation for constraint: string
        if (!is_null($rfc) && !is_string($rfc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rfc, true), gettype($rfc)), __LINE__);
        }
        // validation for constraint: maxLength(13)
        if (!is_null($rfc) && mb_strlen($rfc) > 13) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 13', mb_strlen($rfc)), __LINE__);
        }
        // validation for constraint: minLength(12)
        if (!is_null($rfc) && mb_strlen($rfc) < 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 12', mb_strlen($rfc)), __LINE__);
        }
        // validation for constraint: pattern([A-Z&Ñ]{3,4}[0-9]{2}(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])[A-Z0-9]{2}[0-9A])
        if (!is_null($rfc) && !preg_match('/[A-Z&Ñ]{3,4}[0-9]{2}(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])[A-Z0-9]{2}[0-9A]/', $rfc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z&Ñ]{3,4}[0-9]{2}(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])[A-Z0-9]{2}[0-9A]', var_export($rfc, true)), __LINE__);
        }
        $this->rfc = $rfc;
        return $this;
    }
    /**
     * Get version value
     * @return anySimpleType
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param anySimpleType $version
     * @return \StructType\PorCuentadeTerceros
     */
    public function setVersion(anySimpleType $version = null)
    {
        $this->version = $version;
        return $this;
    }
    /**
     * Get InformacionFiscalTercero value
     * @return \StructType\InformacionFiscalTercero|null
     */
    public function getInformacionFiscalTercero()
    {
        return $this->InformacionFiscalTercero;
    }
    /**
     * Set InformacionFiscalTercero value
     * @param \StructType\InformacionFiscalTercero $informacionFiscalTercero
     * @return \StructType\PorCuentadeTerceros
     */
    public function setInformacionFiscalTercero(\StructType\InformacionFiscalTercero $informacionFiscalTercero = null)
    {
        $this->InformacionFiscalTercero = $informacionFiscalTercero;
        return $this;
    }
    /**
     * Get CuentaPredial value
     * @return \StructType\CuentaPredial|null
     */
    public function getCuentaPredial()
    {
        return isset($this->CuentaPredial) ? $this->CuentaPredial : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCuentaPredial method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCuentaPredial method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCuentaPredialForChoiceConstraintsFromSetCuentaPredial($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'InformacionAduanera',
            'Parte',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CuentaPredial can\'t be set as the property %s is already set. Only one property must be set among these properties: CuentaPredial, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CuentaPredial value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CuentaPredial $cuentaPredial
     * @return \StructType\PorCuentadeTerceros
     */
    public function setCuentaPredial(\StructType\CuentaPredial $cuentaPredial = null)
    {
        // validation for constraint: choice(CuentaPredial, InformacionAduanera, Parte)
        if ('' !== ($cuentaPredialChoiceErrorMessage = self::validateCuentaPredialForChoiceConstraintsFromSetCuentaPredial($cuentaPredial))) {
            throw new \InvalidArgumentException($cuentaPredialChoiceErrorMessage, __LINE__);
        }
        if (is_null($cuentaPredial) || (is_array($cuentaPredial) && empty($cuentaPredial))) {
            unset($this->CuentaPredial);
        } else {
            $this->CuentaPredial = $cuentaPredial;
        }
        return $this;
    }
    /**
     * Get InformacionAduanera value
     * @return \StructType\InformacionAduanera|null
     */
    public function getInformacionAduanera()
    {
        return isset($this->InformacionAduanera) ? $this->InformacionAduanera : null;
    }
    /**
     * This method is responsible for validating the value passed to the setInformacionAduanera method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInformacionAduanera method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateInformacionAduaneraForChoiceConstraintsFromSetInformacionAduanera($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CuentaPredial',
            'Parte',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property InformacionAduanera can\'t be set as the property %s is already set. Only one property must be set among these properties: InformacionAduanera, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set InformacionAduanera value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InformacionAduanera $informacionAduanera
     * @return \StructType\PorCuentadeTerceros
     */
    public function setInformacionAduanera(\StructType\InformacionAduanera $informacionAduanera = null)
    {
        // validation for constraint: choice(CuentaPredial, InformacionAduanera, Parte)
        if ('' !== ($informacionAduaneraChoiceErrorMessage = self::validateInformacionAduaneraForChoiceConstraintsFromSetInformacionAduanera($informacionAduanera))) {
            throw new \InvalidArgumentException($informacionAduaneraChoiceErrorMessage, __LINE__);
        }
        if (is_null($informacionAduanera) || (is_array($informacionAduanera) && empty($informacionAduanera))) {
            unset($this->InformacionAduanera);
        } else {
            $this->InformacionAduanera = $informacionAduanera;
        }
        return $this;
    }
    /**
     * Get Parte value
     * @return \StructType\Parte[]|null
     */
    public function getParte()
    {
        return isset($this->Parte) ? $this->Parte : null;
    }
    /**
     * This method is responsible for validating the values passed to the setParte method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParte method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParteForArrayConstraintsFromSetParte(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $porCuentadeTercerosParteItem) {
            // validation for constraint: itemType
            if (!$porCuentadeTercerosParteItem instanceof \StructType\Parte) {
                $invalidValues[] = is_object($porCuentadeTercerosParteItem) ? get_class($porCuentadeTercerosParteItem) : sprintf('%s(%s)', gettype($porCuentadeTercerosParteItem), var_export($porCuentadeTercerosParteItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Parte property can only contain items of type \StructType\Parte, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setParte method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParte method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateParteForChoiceConstraintsFromSetParte($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CuentaPredial',
            'InformacionAduanera',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Parte can\'t be set as the property %s is already set. Only one property must be set among these properties: Parte, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Parte value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\Parte[] $parte
     * @return \StructType\PorCuentadeTerceros
     */
    public function setParte(array $parte = array())
    {
        // validation for constraint: array
        if ('' !== ($parteArrayErrorMessage = self::validateParteForArrayConstraintsFromSetParte($parte))) {
            throw new \InvalidArgumentException($parteArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(CuentaPredial, InformacionAduanera, Parte)
        if ('' !== ($parteChoiceErrorMessage = self::validateParteForChoiceConstraintsFromSetParte($parte))) {
            throw new \InvalidArgumentException($parteChoiceErrorMessage, __LINE__);
        }
        if (is_null($parte) || (is_array($parte) && empty($parte))) {
            unset($this->Parte);
        } else {
            $this->Parte = $parte;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToParte method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToParte method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToParte($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CuentaPredial',
            'InformacionAduanera',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Parte can\'t be set as the property %s is already set. Only one property must be set among these properties: Parte, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to Parte value
     * @throws \InvalidArgumentException
     * @param \StructType\Parte $item
     * @return \StructType\PorCuentadeTerceros
     */
    public function addToParte(\StructType\Parte $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Parte) {
            throw new \InvalidArgumentException(sprintf('The Parte property can only contain items of type \StructType\Parte, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(CuentaPredial, InformacionAduanera, Parte)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToParte($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->Parte[] = $item;
        return $this;
    }
    /**
     * Get Impuestos value
     * @return \StructType\Impuestos|null
     */
    public function getImpuestos()
    {
        return $this->Impuestos;
    }
    /**
     * Set Impuestos value
     * @param \StructType\Impuestos $impuestos
     * @return \StructType\PorCuentadeTerceros
     */
    public function setImpuestos(\StructType\Impuestos $impuestos = null)
    {
        $this->Impuestos = $impuestos;
        return $this;
    }
    /**
     * Get nombre value
     * @return string|null
     */
    public function getNombre()
    {
        return $this->nombre;
    }
    /**
     * Set nombre value
     * @param string $nombre
     * @return \StructType\PorCuentadeTerceros
     */
    public function setNombre($nombre = null)
    {
        // validation for constraint: string
        if (!is_null($nombre) && !is_string($nombre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nombre, true), gettype($nombre)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nombre) && mb_strlen($nombre) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nombre)), __LINE__);
        }
        $this->nombre = $nombre;
        return $this;
    }
}
