<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for paymentTerms StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo opcional que especifica los términos de pago de la factura
 * @subpackage Structs
 */
class PaymentTerms extends AbstractStructBase
{
    /**
     * The netPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NetPayment
     */
    public $netPayment;
    /**
     * The discountPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DiscountPayment
     */
    public $discountPayment;
    /**
     * The PaymentTermsRelationTime
     * @var string
     */
    public $PaymentTermsRelationTime;
    /**
     * The paymentTermsEvent
     * @var string
     */
    public $paymentTermsEvent;
    /**
     * Constructor method for paymentTerms
     * @uses PaymentTerms::setNetPayment()
     * @uses PaymentTerms::setDiscountPayment()
     * @uses PaymentTerms::setPaymentTermsRelationTime()
     * @uses PaymentTerms::setPaymentTermsEvent()
     * @param \StructType\NetPayment $netPayment
     * @param \StructType\DiscountPayment $discountPayment
     * @param string $paymentTermsRelationTime
     * @param string $paymentTermsEvent
     */
    public function __construct(\StructType\NetPayment $netPayment = null, \StructType\DiscountPayment $discountPayment = null, $paymentTermsRelationTime = null, $paymentTermsEvent = null)
    {
        $this
            ->setNetPayment($netPayment)
            ->setDiscountPayment($discountPayment)
            ->setPaymentTermsRelationTime($paymentTermsRelationTime)
            ->setPaymentTermsEvent($paymentTermsEvent);
    }
    /**
     * Get netPayment value
     * @return \StructType\NetPayment|null
     */
    public function getNetPayment()
    {
        return $this->netPayment;
    }
    /**
     * Set netPayment value
     * @param \StructType\NetPayment $netPayment
     * @return \StructType\PaymentTerms
     */
    public function setNetPayment(\StructType\NetPayment $netPayment = null)
    {
        $this->netPayment = $netPayment;
        return $this;
    }
    /**
     * Get discountPayment value
     * @return \StructType\DiscountPayment|null
     */
    public function getDiscountPayment()
    {
        return $this->discountPayment;
    }
    /**
     * Set discountPayment value
     * @param \StructType\DiscountPayment $discountPayment
     * @return \StructType\PaymentTerms
     */
    public function setDiscountPayment(\StructType\DiscountPayment $discountPayment = null)
    {
        $this->discountPayment = $discountPayment;
        return $this;
    }
    /**
     * Get PaymentTermsRelationTime value
     * @return string|null
     */
    public function getPaymentTermsRelationTime()
    {
        return $this->PaymentTermsRelationTime;
    }
    /**
     * Set PaymentTermsRelationTime value
     * @param string $paymentTermsRelationTime
     * @return \StructType\PaymentTerms
     */
    public function setPaymentTermsRelationTime($paymentTermsRelationTime = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTermsRelationTime) && !is_string($paymentTermsRelationTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTermsRelationTime, true), gettype($paymentTermsRelationTime)), __LINE__);
        }
        $this->PaymentTermsRelationTime = $paymentTermsRelationTime;
        return $this;
    }
    /**
     * Get paymentTermsEvent value
     * @return string|null
     */
    public function getPaymentTermsEvent()
    {
        return $this->paymentTermsEvent;
    }
    /**
     * Set paymentTermsEvent value
     * @param string $paymentTermsEvent
     * @return \StructType\PaymentTerms
     */
    public function setPaymentTermsEvent($paymentTermsEvent = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTermsEvent) && !is_string($paymentTermsEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTermsEvent, true), gettype($paymentTermsEvent)), __LINE__);
        }
        $this->paymentTermsEvent = $paymentTermsEvent;
        return $this;
    }
}
