<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Parte StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo opcional para expresar las partes o componentes que integran la totalidad del concepto expresado en el CFD o CFDI | Nodo opcional para expresar las partes o componentes que integran la totalidad del concepto expresado en el
 * comprobante fiscal digital por Internet.
 * @subpackage Structs
 */
class Parte extends AbstractStructBase
{
    /**
     * The Cantidad
     * Meta information extracted from the WSDL
     * - base: xs:decimal
     * - fractionDigits: 6
     * - minInclusive: 0.000001
     * - use: required
     * - whiteSpace: collapse
     * @var float
     */
    public $Cantidad;
    /**
     * The ClaveProdServ
     * Meta information extracted from the WSDL
     * - documentation: Atributo requerido para expresar la clave del producto o del servicio amparado por la presente parte. Es requerido y deben utilizar las claves del catálogo de productos y servicios, cuando los conceptos que registren por sus
     * actividades correspondan con dichos conceptos.
     * - base: xs:string
     * - pattern: [0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $ClaveProdServ;
    /**
     * The Descripcion
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 1000
     * - minLength: 1
     * - pattern: [^|]{1,1000}
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $Descripcion;
    /**
     * The cantidad
     * Meta information extracted from the WSDL
     * - base: xs:decimal
     * - use: required
     * - whiteSpace: collapse
     * @var float
     */
    public $cantidad;
    /**
     * The descripcion
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minLength: 1
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $descripcion;
    /**
     * The InformacionAduanera
     * Meta information extracted from the WSDL
     * - documentation: Nodo opcional para introducir la información aduanera aplicable cuando se trate de partes o componentes importados vendidos de primera mano.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InformacionAduanera[]
     */
    public $InformacionAduanera;
    /**
     * The Importe
     * Meta information extracted from the WSDL
     * - documentation: Atributo opcional para precisar el importe total de los bienes o servicios de la presente parte. Debe ser equivalente al resultado de multiplicar la cantidad por el valor unitario expresado en la parte. No se permiten valores
     * negativos. | Tipo definido para expresar importes numéricos con fracción hasta seis decimales. El valor se redondea de acuerdo con el número de decimales que soporta la moneda. No se permiten valores negativos. | Tipo definido para expresar
     * importes numéricos con fracción hasta seis decimales
     * - base: xs:decimal
     * - fractionDigits: 6
     * - minInclusive: 0.0
     * - pattern: [0-9]{1,18}(.[0-9]{1,6})?
     * - whiteSpace: collapse
     * @var float
     */
    public $Importe;
    /**
     * The NoIdentificacion
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 100
     * - minLength: 1
     * - pattern: [^|]{1,100}
     * - whiteSpace: collapse
     * @var string
     */
    public $NoIdentificacion;
    /**
     * The Unidad
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 20
     * - minLength: 1
     * - pattern: [^|]{1,20}
     * - whiteSpace: collapse
     * @var string
     */
    public $Unidad;
    /**
     * The ValorUnitario
     * Meta information extracted from the WSDL
     * - documentation: Atributo opcional para precisar el valor o precio unitario del bien o servicio cubierto por la presente parte. No se permiten valores negativos. | Tipo definido para expresar importes numéricos con fracción hasta seis decimales. El
     * valor se redondea de acuerdo con el número de decimales que soporta la moneda. No se permiten valores negativos. | Tipo definido para expresar importes numéricos con fracción hasta seis decimales
     * - base: xs:decimal
     * - fractionDigits: 6
     * - minInclusive: 0.0
     * - pattern: [0-9]{1,18}(.[0-9]{1,6})?
     * - whiteSpace: collapse
     * @var float
     */
    public $ValorUnitario;
    /**
     * The importe
     * Meta information extracted from the WSDL
     * - documentation: Atributo opcional para precisar el importe total de los bienes o servicios de la presente parte. Debe ser equivalente al resultado de multiplicar la cantidad por el valor unitario expresado en la parte. | Tipo definido para expresar
     * importes numéricos con fracción hasta seis decimales. El valor se redondea de acuerdo con el número de decimales que soporta la moneda. No se permiten valores negativos. | Tipo definido para expresar importes numéricos con fracción hasta seis
     * decimales
     * - base: xs:decimal
     * - fractionDigits: 6
     * - minInclusive: 0.0
     * - pattern: [0-9]{1,18}(.[0-9]{1,6})?
     * - whiteSpace: collapse
     * @var float
     */
    public $importe;
    /**
     * The noIdentificacion
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minLength: 1
     * - whiteSpace: collapse
     * @var string
     */
    public $noIdentificacion;
    /**
     * The unidad
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minLength: 1
     * - whiteSpace: collapse
     * @var string
     */
    public $unidad;
    /**
     * The valorUnitario
     * Meta information extracted from the WSDL
     * - documentation: Atributo opcional para precisar el valor o precio unitario del bien o servicio cubierto por la presente parte. | Tipo definido para expresar importes numéricos con fracción hasta seis decimales. El valor se redondea de acuerdo con
     * el número de decimales que soporta la moneda. No se permiten valores negativos. | Tipo definido para expresar importes numéricos con fracción hasta seis decimales
     * - base: xs:decimal
     * - fractionDigits: 6
     * - minInclusive: 0.0
     * - pattern: [0-9]{1,18}(.[0-9]{1,6})?
     * - whiteSpace: collapse
     * @var float
     */
    public $valorUnitario;
    /**
     * Constructor method for Parte
     * @uses Parte::setCantidad()
     * @uses Parte::setClaveProdServ()
     * @uses Parte::setDescripcion()
     * @uses Parte::setCantidad_1()
     * @uses Parte::setDescripcion_1()
     * @uses Parte::setInformacionAduanera()
     * @uses Parte::setImporte()
     * @uses Parte::setNoIdentificacion()
     * @uses Parte::setUnidad()
     * @uses Parte::setValorUnitario()
     * @uses Parte::setImporte_1()
     * @uses Parte::setNoIdentificacion_1()
     * @uses Parte::setUnidad_1()
     * @uses Parte::setValorUnitario_1()
     * @param float $cantidad
     * @param string $claveProdServ
     * @param string $descripcion
     * @param float $cantidad
     * @param string $descripcion
     * @param \StructType\InformacionAduanera[] $informacionAduanera
     * @param float $importe
     * @param string $noIdentificacion
     * @param string $unidad
     * @param float $valorUnitario
     * @param float $importe
     * @param string $noIdentificacion
     * @param string $unidad
     * @param float $valorUnitario
     */
    public function __construct($cantidad = null, $claveProdServ = null, $descripcion = null, $cantidad_1 = null, $descripcion_1 = null, array $informacionAduanera = array(), $importe = null, $noIdentificacion = null, $unidad = null, $valorUnitario = null, $importe_1 = null, $noIdentificacion_1 = null, $unidad_1 = null, $valorUnitario_1 = null)
    {
        $this
            ->setCantidad($cantidad)
            ->setClaveProdServ($claveProdServ)
            ->setDescripcion($descripcion)
            ->setCantidad_1($cantidad_1)
            ->setDescripcion_1($descripcion_1)
            ->setInformacionAduanera($informacionAduanera)
            ->setImporte($importe)
            ->setNoIdentificacion($noIdentificacion)
            ->setUnidad($unidad)
            ->setValorUnitario($valorUnitario)
            ->setImporte_1($importe_1)
            ->setNoIdentificacion_1($noIdentificacion_1)
            ->setUnidad_1($unidad_1)
            ->setValorUnitario_1($valorUnitario_1);
    }
    /**
     * Get Cantidad value
     * @return float
     */
    public function getCantidad()
    {
        return $this->Cantidad;
    }
    /**
     * Set Cantidad value
     * @param float $cantidad
     * @return \StructType\Parte
     */
    public function setCantidad($cantidad = null)
    {
        // validation for constraint: float
        if (!is_null($cantidad) && !(is_float($cantidad) || is_numeric($cantidad))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cantidad, true), gettype($cantidad)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($cantidad) && mb_strlen(mb_substr($cantidad, false !== mb_strpos($cantidad, '.') ? mb_strpos($cantidad, '.') + 1 : mb_strlen($cantidad))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($cantidad, true), mb_strlen(mb_substr($cantidad, mb_strpos($cantidad, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive(0.000001)
        if (!is_null($cantidad) && $cantidad < 0.000001) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.000001', var_export($cantidad, true)), __LINE__);
        }
        $this->Cantidad = $cantidad;
        return $this;
    }
    /**
     * Get ClaveProdServ value
     * @return string
     */
    public function getClaveProdServ()
    {
        return $this->ClaveProdServ;
    }
    /**
     * Set ClaveProdServ value
     * @param string $claveProdServ
     * @return \StructType\Parte
     */
    public function setClaveProdServ($claveProdServ = null)
    {
        // validation for constraint: string
        if (!is_null($claveProdServ) && !is_string($claveProdServ)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($claveProdServ, true), gettype($claveProdServ)), __LINE__);
        }
        // validation for constraint: pattern([0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9])
        if (!is_null($claveProdServ) && !preg_match('/[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]/', $claveProdServ)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]', var_export($claveProdServ, true)), __LINE__);
        }
        $this->ClaveProdServ = $claveProdServ;
        return $this;
    }
    /**
     * Get Descripcion value
     * @return string
     */
    public function getDescripcion()
    {
        return $this->Descripcion;
    }
    /**
     * Set Descripcion value
     * @param string $descripcion
     * @return \StructType\Parte
     */
    public function setDescripcion($descripcion = null)
    {
        // validation for constraint: string
        if (!is_null($descripcion) && !is_string($descripcion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descripcion, true), gettype($descripcion)), __LINE__);
        }
        // validation for constraint: maxLength(1000)
        if (!is_null($descripcion) && mb_strlen($descripcion) > 1000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1000', mb_strlen($descripcion)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($descripcion) && mb_strlen($descripcion) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($descripcion)), __LINE__);
        }
        // validation for constraint: pattern([^|]{1,1000})
        if (!is_null($descripcion) && !preg_match('/[^|]{1,1000}/', $descripcion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^|]{1,1000}', var_export($descripcion, true)), __LINE__);
        }
        $this->Descripcion = $descripcion;
        return $this;
    }
    /**
     * Get Cantidad value
     * @return float
     */
    public function getCantidad_1()
    {
        return $this->cantidad;
    }
    /**
     * Set Cantidad value
     * @param float $cantidad
     * @return \StructType\Parte
     */
    public function setCantidad_1($cantidad_1 = null)
    {
        // validation for constraint: float
        if (!is_null($cantidad_1) && !(is_float($cantidad_1) || is_numeric($cantidad_1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cantidad_1, true), gettype($cantidad_1)), __LINE__);
        }
        $this->cantidad = $cantidad_1;
        return $this;
    }
    /**
     * Get Descripcion value
     * @return string
     */
    public function getDescripcion_1()
    {
        return $this->descripcion;
    }
    /**
     * Set Descripcion value
     * @param string $descripcion
     * @return \StructType\Parte
     */
    public function setDescripcion_1($descripcion_1 = null)
    {
        // validation for constraint: string
        if (!is_null($descripcion_1) && !is_string($descripcion_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descripcion_1, true), gettype($descripcion_1)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($descripcion_1) && mb_strlen($descripcion_1) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($descripcion_1)), __LINE__);
        }
        $this->descripcion = $descripcion_1;
        return $this;
    }
    /**
     * Get InformacionAduanera value
     * @return \StructType\InformacionAduanera[]|null
     */
    public function getInformacionAduanera()
    {
        return $this->InformacionAduanera;
    }
    /**
     * This method is responsible for validating the values passed to the setInformacionAduanera method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInformacionAduanera method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInformacionAduaneraForArrayConstraintsFromSetInformacionAduanera(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $parteInformacionAduaneraItem) {
            // validation for constraint: itemType
            if (!$parteInformacionAduaneraItem instanceof \StructType\InformacionAduanera) {
                $invalidValues[] = is_object($parteInformacionAduaneraItem) ? get_class($parteInformacionAduaneraItem) : sprintf('%s(%s)', gettype($parteInformacionAduaneraItem), var_export($parteInformacionAduaneraItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InformacionAduanera property can only contain items of type \StructType\InformacionAduanera, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InformacionAduanera value
     * @throws \InvalidArgumentException
     * @param \StructType\InformacionAduanera[] $informacionAduanera
     * @return \StructType\Parte
     */
    public function setInformacionAduanera(array $informacionAduanera = array())
    {
        // validation for constraint: array
        if ('' !== ($informacionAduaneraArrayErrorMessage = self::validateInformacionAduaneraForArrayConstraintsFromSetInformacionAduanera($informacionAduanera))) {
            throw new \InvalidArgumentException($informacionAduaneraArrayErrorMessage, __LINE__);
        }
        $this->InformacionAduanera = $informacionAduanera;
        return $this;
    }
    /**
     * Add item to InformacionAduanera value
     * @throws \InvalidArgumentException
     * @param \StructType\InformacionAduanera $item
     * @return \StructType\Parte
     */
    public function addToInformacionAduanera(\StructType\InformacionAduanera $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InformacionAduanera) {
            throw new \InvalidArgumentException(sprintf('The InformacionAduanera property can only contain items of type \StructType\InformacionAduanera, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InformacionAduanera[] = $item;
        return $this;
    }
    /**
     * Get Importe value
     * @return float|null
     */
    public function getImporte()
    {
        return $this->Importe;
    }
    /**
     * Set Importe value
     * @param float $importe
     * @return \StructType\Parte
     */
    public function setImporte($importe = null)
    {
        // validation for constraint: float
        if (!is_null($importe) && !(is_float($importe) || is_numeric($importe))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($importe, true), gettype($importe)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($importe) && mb_strlen(mb_substr($importe, false !== mb_strpos($importe, '.') ? mb_strpos($importe, '.') + 1 : mb_strlen($importe))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($importe, true), mb_strlen(mb_substr($importe, mb_strpos($importe, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($importe) && $importe < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($importe, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,18}(.[0-9]{1,6})?)
        if (!is_null($importe) && !preg_match('/[0-9]{1,18}(.[0-9]{1,6})?/', $importe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,18}(.[0-9]{1,6})?', var_export($importe, true)), __LINE__);
        }
        $this->Importe = $importe;
        return $this;
    }
    /**
     * Get NoIdentificacion value
     * @return string|null
     */
    public function getNoIdentificacion()
    {
        return $this->NoIdentificacion;
    }
    /**
     * Set NoIdentificacion value
     * @param string $noIdentificacion
     * @return \StructType\Parte
     */
    public function setNoIdentificacion($noIdentificacion = null)
    {
        // validation for constraint: string
        if (!is_null($noIdentificacion) && !is_string($noIdentificacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noIdentificacion, true), gettype($noIdentificacion)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($noIdentificacion) && mb_strlen($noIdentificacion) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($noIdentificacion)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($noIdentificacion) && mb_strlen($noIdentificacion) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($noIdentificacion)), __LINE__);
        }
        // validation for constraint: pattern([^|]{1,100})
        if (!is_null($noIdentificacion) && !preg_match('/[^|]{1,100}/', $noIdentificacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^|]{1,100}', var_export($noIdentificacion, true)), __LINE__);
        }
        $this->NoIdentificacion = $noIdentificacion;
        return $this;
    }
    /**
     * Get Unidad value
     * @return string|null
     */
    public function getUnidad()
    {
        return $this->Unidad;
    }
    /**
     * Set Unidad value
     * @param string $unidad
     * @return \StructType\Parte
     */
    public function setUnidad($unidad = null)
    {
        // validation for constraint: string
        if (!is_null($unidad) && !is_string($unidad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unidad, true), gettype($unidad)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($unidad) && mb_strlen($unidad) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($unidad)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($unidad) && mb_strlen($unidad) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($unidad)), __LINE__);
        }
        // validation for constraint: pattern([^|]{1,20})
        if (!is_null($unidad) && !preg_match('/[^|]{1,20}/', $unidad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^|]{1,20}', var_export($unidad, true)), __LINE__);
        }
        $this->Unidad = $unidad;
        return $this;
    }
    /**
     * Get ValorUnitario value
     * @return float|null
     */
    public function getValorUnitario()
    {
        return $this->ValorUnitario;
    }
    /**
     * Set ValorUnitario value
     * @param float $valorUnitario
     * @return \StructType\Parte
     */
    public function setValorUnitario($valorUnitario = null)
    {
        // validation for constraint: float
        if (!is_null($valorUnitario) && !(is_float($valorUnitario) || is_numeric($valorUnitario))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorUnitario, true), gettype($valorUnitario)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($valorUnitario) && mb_strlen(mb_substr($valorUnitario, false !== mb_strpos($valorUnitario, '.') ? mb_strpos($valorUnitario, '.') + 1 : mb_strlen($valorUnitario))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($valorUnitario, true), mb_strlen(mb_substr($valorUnitario, mb_strpos($valorUnitario, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($valorUnitario) && $valorUnitario < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($valorUnitario, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,18}(.[0-9]{1,6})?)
        if (!is_null($valorUnitario) && !preg_match('/[0-9]{1,18}(.[0-9]{1,6})?/', $valorUnitario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,18}(.[0-9]{1,6})?', var_export($valorUnitario, true)), __LINE__);
        }
        $this->ValorUnitario = $valorUnitario;
        return $this;
    }
    /**
     * Get Importe value
     * @return float|null
     */
    public function getImporte_1()
    {
        return $this->importe;
    }
    /**
     * Set Importe value
     * @param float $importe
     * @return \StructType\Parte
     */
    public function setImporte_1($importe_1 = null)
    {
        // validation for constraint: float
        if (!is_null($importe_1) && !(is_float($importe_1) || is_numeric($importe_1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($importe_1, true), gettype($importe_1)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($importe_1) && mb_strlen(mb_substr($importe_1, false !== mb_strpos($importe_1, '.') ? mb_strpos($importe_1, '.') + 1 : mb_strlen($importe_1))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($importe_1, true), mb_strlen(mb_substr($importe_1, mb_strpos($importe_1, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($importe_1) && $importe_1 < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($importe_1, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,18}(.[0-9]{1,6})?)
        if (!is_null($importe_1) && !preg_match('/[0-9]{1,18}(.[0-9]{1,6})?/', $importe_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,18}(.[0-9]{1,6})?', var_export($importe_1, true)), __LINE__);
        }
        $this->importe = $importe_1;
        return $this;
    }
    /**
     * Get NoIdentificacion value
     * @return string|null
     */
    public function getNoIdentificacion_1()
    {
        return $this->noIdentificacion;
    }
    /**
     * Set NoIdentificacion value
     * @param string $noIdentificacion
     * @return \StructType\Parte
     */
    public function setNoIdentificacion_1($noIdentificacion_1 = null)
    {
        // validation for constraint: string
        if (!is_null($noIdentificacion_1) && !is_string($noIdentificacion_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noIdentificacion_1, true), gettype($noIdentificacion_1)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($noIdentificacion_1) && mb_strlen($noIdentificacion_1) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($noIdentificacion_1)), __LINE__);
        }
        $this->noIdentificacion = $noIdentificacion_1;
        return $this;
    }
    /**
     * Get Unidad value
     * @return string|null
     */
    public function getUnidad_1()
    {
        return $this->unidad;
    }
    /**
     * Set Unidad value
     * @param string $unidad
     * @return \StructType\Parte
     */
    public function setUnidad_1($unidad_1 = null)
    {
        // validation for constraint: string
        if (!is_null($unidad_1) && !is_string($unidad_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unidad_1, true), gettype($unidad_1)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($unidad_1) && mb_strlen($unidad_1) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($unidad_1)), __LINE__);
        }
        $this->unidad = $unidad_1;
        return $this;
    }
    /**
     * Get ValorUnitario value
     * @return float|null
     */
    public function getValorUnitario_1()
    {
        return $this->valorUnitario;
    }
    /**
     * Set ValorUnitario value
     * @param float $valorUnitario
     * @return \StructType\Parte
     */
    public function setValorUnitario_1($valorUnitario_1 = null)
    {
        // validation for constraint: float
        if (!is_null($valorUnitario_1) && !(is_float($valorUnitario_1) || is_numeric($valorUnitario_1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorUnitario_1, true), gettype($valorUnitario_1)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($valorUnitario_1) && mb_strlen(mb_substr($valorUnitario_1, false !== mb_strpos($valorUnitario_1, '.') ? mb_strpos($valorUnitario_1, '.') + 1 : mb_strlen($valorUnitario_1))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($valorUnitario_1, true), mb_strlen(mb_substr($valorUnitario_1, mb_strpos($valorUnitario_1, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($valorUnitario_1) && $valorUnitario_1 < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($valorUnitario_1, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,18}(.[0-9]{1,6})?)
        if (!is_null($valorUnitario_1) && !preg_match('/[0-9]{1,18}(.[0-9]{1,6})?/', $valorUnitario_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,18}(.[0-9]{1,6})?', var_export($valorUnitario_1, true)), __LINE__);
        }
        $this->valorUnitario = $valorUnitario_1;
        return $this;
    }
}
