<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for palletInformation StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo opcional que especifica la información de empaquetado
 * @subpackage Structs
 */
class PalletInformation extends AbstractStructBase
{
    /**
     * The description
     * @var \StructType\Description
     */
    public $description;
    /**
     * The palletQuantity
     * Meta information extracted from the WSDL
     * - documentation: Nodo requerido que especifica el numero de paquetes
     * - base: xs:string
     * - maxLength: 15
     * - minLength: 1
     * @var string
     */
    public $palletQuantity;
    /**
     * The transport
     * @var \StructType\Transport
     */
    public $transport;
    /**
     * Constructor method for palletInformation
     * @uses PalletInformation::setDescription()
     * @uses PalletInformation::setPalletQuantity()
     * @uses PalletInformation::setTransport()
     * @param \StructType\Description $description
     * @param string $palletQuantity
     * @param \StructType\Transport $transport
     */
    public function __construct(\StructType\Description $description = null, $palletQuantity = null, \StructType\Transport $transport = null)
    {
        $this
            ->setDescription($description)
            ->setPalletQuantity($palletQuantity)
            ->setTransport($transport);
    }
    /**
     * Get description value
     * @return \StructType\Description|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param \StructType\Description $description
     * @return \StructType\PalletInformation
     */
    public function setDescription(\StructType\Description $description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get palletQuantity value
     * @return string|null
     */
    public function getPalletQuantity()
    {
        return $this->palletQuantity;
    }
    /**
     * Set palletQuantity value
     * @param string $palletQuantity
     * @return \StructType\PalletInformation
     */
    public function setPalletQuantity($palletQuantity = null)
    {
        // validation for constraint: string
        if (!is_null($palletQuantity) && !is_string($palletQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($palletQuantity, true), gettype($palletQuantity)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($palletQuantity) && mb_strlen($palletQuantity) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($palletQuantity)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($palletQuantity) && mb_strlen($palletQuantity) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($palletQuantity)), __LINE__);
        }
        $this->palletQuantity = $palletQuantity;
        return $this;
    }
    /**
     * Get transport value
     * @return \StructType\Transport|null
     */
    public function getTransport()
    {
        return $this->transport;
    }
    /**
     * Set transport value
     * @param \StructType\Transport $transport
     * @return \StructType\PalletInformation
     */
    public function setTransport(\StructType\Transport $transport = null)
    {
        $this->transport = $transport;
        return $this;
    }
}
