<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Pagos StructType
 * Meta information extracted from the WSDL
 * - documentation: Complemento para el Comprobante Fiscal Digital por Internet (CFDI) para registrar información sobre la recepción de pagos. El emisor de este complemento para recepción de pagos debe ser quien las leyes le obligue a expedir
 * comprobantes por los actos o actividades que realicen, por los ingresos que se perciban o por las retenciones de contribuciones que efectúen.
 * @subpackage Structs
 */
class Pagos extends AbstractStructBase
{
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - fixed: 1.0
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $Version;
    /**
     * The Pago
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Pago[]
     */
    public $Pago;
    /**
     * Constructor method for Pagos
     * @uses Pagos::setVersion()
     * @uses Pagos::setPago()
     * @param string $version
     * @param \StructType\Pago[] $pago
     */
    public function __construct($version = null, array $pago = array())
    {
        $this
            ->setVersion($version)
            ->setPago($pago);
    }
    /**
     * Get Version value
     * @return string
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\Pagos
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Pago value
     * @return \StructType\Pago[]|null
     */
    public function getPago()
    {
        return $this->Pago;
    }
    /**
     * This method is responsible for validating the values passed to the setPago method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPago method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePagoForArrayConstraintsFromSetPago(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pagosPagoItem) {
            // validation for constraint: itemType
            if (!$pagosPagoItem instanceof \StructType\Pago) {
                $invalidValues[] = is_object($pagosPagoItem) ? get_class($pagosPagoItem) : sprintf('%s(%s)', gettype($pagosPagoItem), var_export($pagosPagoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Pago property can only contain items of type \StructType\Pago, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Pago value
     * @throws \InvalidArgumentException
     * @param \StructType\Pago[] $pago
     * @return \StructType\Pagos
     */
    public function setPago(array $pago = array())
    {
        // validation for constraint: array
        if ('' !== ($pagoArrayErrorMessage = self::validatePagoForArrayConstraintsFromSetPago($pago))) {
            throw new \InvalidArgumentException($pagoArrayErrorMessage, __LINE__);
        }
        $this->Pago = $pago;
        return $this;
    }
    /**
     * Add item to Pago value
     * @throws \InvalidArgumentException
     * @param \StructType\Pago $item
     * @return \StructType\Pagos
     */
    public function addToPago(\StructType\Pago $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Pago) {
            throw new \InvalidArgumentException(sprintf('The Pago property can only contain items of type \StructType\Pago, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Pago[] = $item;
        return $this;
    }
}
