<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Pago StructType
 * Meta information extracted from the WSDL
 * - documentation: Elemento requerido para incorporar la información de la recepción de pagos.
 * @subpackage Structs
 */
class Pago extends AbstractStructBase
{
    /**
     * The FechaPago
     * Meta information extracted from the WSDL
     * - documentation: Atributo requerido para expresar la fecha y hora en la que el beneficiario recibe el pago. Se expresa en la forma aaaa-mm-ddThh:mm:ss, de acuerdo con la especificación ISO 8601.En caso de no contar con la hora se debe registrar
     * 12:00:00. | Tipo definido para la expresión de la fecha y hora. Se expresa en la forma AAAA-MM-DDThh:mm:ss
     * - base: xs:dateTime
     * - pattern: (20[1-9][0-9])-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01])T(([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $FechaPago;
    /**
     * The FormaDePagoP
     * Meta information extracted from the WSDL
     * - documentation: Atributo requerido para expresar la clave de la forma en que se realiza el pago.
     * - use: required
     * @var string
     */
    public $FormaDePagoP;
    /**
     * The MonedaP
     * Meta information extracted from the WSDL
     * - documentation: Atributo requerido para identificar la clave de la moneda utilizada para realizar el pago, cuando se usa moneda nacional se registra MXN. El atributo Pagos:Pago:Monto y los atributos TotalImpuestosRetenidos,
     * TotalImpuestosTrasladados, Traslados:Traslado:Importe y Retenciones:Retencion:Importe del nodo Pago:Impuestos deben ser expresados en esta moneda. Conforme con la especificación ISO 4217.
     * - base: xs:string
     * - use: required
     * - whiteSpace: collapse
     * @var string
     */
    public $MonedaP;
    /**
     * The Monto
     * Meta information extracted from the WSDL
     * - documentation: Atributo requerido para expresar el importe del pago. | Tipo definido para expresar importes numéricos con fracción hasta seis decimales. El valor se redondea de acuerdo con el número de decimales que soporta la moneda. No se
     * permiten valores negativos. | Tipo definido para expresar importes numéricos con fracción hasta seis decimales
     * - base: xs:decimal
     * - fractionDigits: 6
     * - minInclusive: 0.0
     * - pattern: [0-9]{1,18}(.[0-9]{1,6})?
     * - use: required
     * - whiteSpace: collapse
     * @var float
     */
    public $Monto;
    /**
     * The DoctoRelacionado
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DoctoRelacionado[]
     */
    public $DoctoRelacionado;
    /**
     * The Impuestos
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Impuestos[]
     */
    public $Impuestos;
    /**
     * The CadPago
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 8192
     * - minLength: 1
     * - whiteSpace: collapse
     * @var string
     */
    public $CadPago;
    /**
     * The CertPago
     * Meta information extracted from the WSDL
     * - base: xs:base64Binary
     * - whiteSpace: collapse
     * @var string
     */
    public $CertPago;
    /**
     * The CtaBeneficiario
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 50
     * - minLength: 10
     * - pattern: [A-Z0-9_]{10,50}
     * - whiteSpace: collapse
     * @var string
     */
    public $CtaBeneficiario;
    /**
     * The CtaOrdenante
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 50
     * - minLength: 10
     * - pattern: [A-Z0-9_]{10,50}
     * - whiteSpace: collapse
     * @var string
     */
    public $CtaOrdenante;
    /**
     * The NomBancoOrdExt
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 300
     * - minLength: 1
     * - pattern: [^|]{1,300}
     * - whiteSpace: collapse
     * @var string
     */
    public $NomBancoOrdExt;
    /**
     * The NumOperacion
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 100
     * - minLength: 1
     * - pattern: [^|]{1,100}
     * @var string
     */
    public $NumOperacion;
    /**
     * The RfcEmisorCtaBen
     * Meta information extracted from the WSDL
     * - documentation: Atributo condicional para expresar la clave RFC de la entidad operadora de la cuenta destino, es decir, la operadora, el banco, la institución financiera, emisor de monedero electrónico, etc. Considerar las reglas de obligatoriedad
     * publicadas en la página del SAT para éste atributo de acuerdo con el catálogo catCFDI:c_FormaPago. | Tipo definido para la expresión de un Registro Federal de Contribuyentes de persona moral.
     * - base: xs:string
     * - minLength: 12
     * - pattern: [A-Z&Ñ]{3}[0-9]{2}(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])[A-Z0-9]{2}[0-9A]
     * - whiteSpace: collapse
     * @var string
     */
    public $RfcEmisorCtaBen;
    /**
     * The RfcEmisorCtaOrd
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 13
     * - minLength: 12
     * - pattern: XEXX010101000|[A-Z&Ñ]{3}[0-9]{2}(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])[A-Z0-9]{2}[0-9A]
     * - whiteSpace: collapse
     * @var string
     */
    public $RfcEmisorCtaOrd;
    /**
     * The SelloPago
     * Meta information extracted from the WSDL
     * - base: xs:base64Binary
     * - whiteSpace: collapse
     * @var string
     */
    public $SelloPago;
    /**
     * The TipoCadPago
     * Meta information extracted from the WSDL
     * - documentation: Atributo condicional para identificar la clave del tipo de cadena de pago que genera la entidad receptora del pago. Considerar las reglas de obligatoriedad publicadas en la página del SAT para éste atributo de acuerdo con el
     * catálogo catCFDI:c_FormaPago.
     * @var string
     */
    public $TipoCadPago;
    /**
     * The TipoCambioP
     * Meta information extracted from the WSDL
     * - base: xs:decimal
     * - fractionDigits: 6
     * - minInclusive: 0.000001
     * - whiteSpace: collapse
     * @var float
     */
    public $TipoCambioP;
    /**
     * Constructor method for Pago
     * @uses Pago::setFechaPago()
     * @uses Pago::setFormaDePagoP()
     * @uses Pago::setMonedaP()
     * @uses Pago::setMonto()
     * @uses Pago::setDoctoRelacionado()
     * @uses Pago::setImpuestos()
     * @uses Pago::setCadPago()
     * @uses Pago::setCertPago()
     * @uses Pago::setCtaBeneficiario()
     * @uses Pago::setCtaOrdenante()
     * @uses Pago::setNomBancoOrdExt()
     * @uses Pago::setNumOperacion()
     * @uses Pago::setRfcEmisorCtaBen()
     * @uses Pago::setRfcEmisorCtaOrd()
     * @uses Pago::setSelloPago()
     * @uses Pago::setTipoCadPago()
     * @uses Pago::setTipoCambioP()
     * @param string $fechaPago
     * @param string $formaDePagoP
     * @param string $monedaP
     * @param float $monto
     * @param \StructType\DoctoRelacionado[] $doctoRelacionado
     * @param \StructType\Impuestos[] $impuestos
     * @param string $cadPago
     * @param string $certPago
     * @param string $ctaBeneficiario
     * @param string $ctaOrdenante
     * @param string $nomBancoOrdExt
     * @param string $numOperacion
     * @param string $rfcEmisorCtaBen
     * @param string $rfcEmisorCtaOrd
     * @param string $selloPago
     * @param string $tipoCadPago
     * @param float $tipoCambioP
     */
    public function __construct($fechaPago = null, $formaDePagoP = null, $monedaP = null, $monto = null, array $doctoRelacionado = array(), array $impuestos = array(), $cadPago = null, $certPago = null, $ctaBeneficiario = null, $ctaOrdenante = null, $nomBancoOrdExt = null, $numOperacion = null, $rfcEmisorCtaBen = null, $rfcEmisorCtaOrd = null, $selloPago = null, $tipoCadPago = null, $tipoCambioP = null)
    {
        $this
            ->setFechaPago($fechaPago)
            ->setFormaDePagoP($formaDePagoP)
            ->setMonedaP($monedaP)
            ->setMonto($monto)
            ->setDoctoRelacionado($doctoRelacionado)
            ->setImpuestos($impuestos)
            ->setCadPago($cadPago)
            ->setCertPago($certPago)
            ->setCtaBeneficiario($ctaBeneficiario)
            ->setCtaOrdenante($ctaOrdenante)
            ->setNomBancoOrdExt($nomBancoOrdExt)
            ->setNumOperacion($numOperacion)
            ->setRfcEmisorCtaBen($rfcEmisorCtaBen)
            ->setRfcEmisorCtaOrd($rfcEmisorCtaOrd)
            ->setSelloPago($selloPago)
            ->setTipoCadPago($tipoCadPago)
            ->setTipoCambioP($tipoCambioP);
    }
    /**
     * Get FechaPago value
     * @return string
     */
    public function getFechaPago()
    {
        return $this->FechaPago;
    }
    /**
     * Set FechaPago value
     * @param string $fechaPago
     * @return \StructType\Pago
     */
    public function setFechaPago($fechaPago = null)
    {
        // validation for constraint: string
        if (!is_null($fechaPago) && !is_string($fechaPago)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaPago, true), gettype($fechaPago)), __LINE__);
        }
        // validation for constraint: pattern((20[1-9][0-9])-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01])T(([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]))
        if (!is_null($fechaPago) && !preg_match('/(20[1-9][0-9])-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01])T(([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])/', $fechaPago)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (20[1-9][0-9])-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01])T(([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])', var_export($fechaPago, true)), __LINE__);
        }
        $this->FechaPago = $fechaPago;
        return $this;
    }
    /**
     * Get FormaDePagoP value
     * @return string
     */
    public function getFormaDePagoP()
    {
        return $this->FormaDePagoP;
    }
    /**
     * Set FormaDePagoP value
     * @uses \EnumType\C_FormaPago::valueIsValid()
     * @uses \EnumType\C_FormaPago::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $formaDePagoP
     * @return \StructType\Pago
     */
    public function setFormaDePagoP($formaDePagoP = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\C_FormaPago::valueIsValid($formaDePagoP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\C_FormaPago', is_array($formaDePagoP) ? implode(', ', $formaDePagoP) : var_export($formaDePagoP, true), implode(', ', \EnumType\C_FormaPago::getValidValues())), __LINE__);
        }
        $this->FormaDePagoP = $formaDePagoP;
        return $this;
    }
    /**
     * Get MonedaP value
     * @return string
     */
    public function getMonedaP()
    {
        return $this->MonedaP;
    }
    /**
     * Set MonedaP value
     * @param string $monedaP
     * @return \StructType\Pago
     */
    public function setMonedaP($monedaP = null)
    {
        // validation for constraint: string
        if (!is_null($monedaP) && !is_string($monedaP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($monedaP, true), gettype($monedaP)), __LINE__);
        }
        $this->MonedaP = $monedaP;
        return $this;
    }
    /**
     * Get Monto value
     * @return float
     */
    public function getMonto()
    {
        return $this->Monto;
    }
    /**
     * Set Monto value
     * @param float $monto
     * @return \StructType\Pago
     */
    public function setMonto($monto = null)
    {
        // validation for constraint: float
        if (!is_null($monto) && !(is_float($monto) || is_numeric($monto))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($monto, true), gettype($monto)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($monto) && mb_strlen(mb_substr($monto, false !== mb_strpos($monto, '.') ? mb_strpos($monto, '.') + 1 : mb_strlen($monto))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($monto, true), mb_strlen(mb_substr($monto, mb_strpos($monto, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($monto) && $monto < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($monto, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,18}(.[0-9]{1,6})?)
        if (!is_null($monto) && !preg_match('/[0-9]{1,18}(.[0-9]{1,6})?/', $monto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,18}(.[0-9]{1,6})?', var_export($monto, true)), __LINE__);
        }
        $this->Monto = $monto;
        return $this;
    }
    /**
     * Get DoctoRelacionado value
     * @return \StructType\DoctoRelacionado[]|null
     */
    public function getDoctoRelacionado()
    {
        return $this->DoctoRelacionado;
    }
    /**
     * This method is responsible for validating the values passed to the setDoctoRelacionado method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDoctoRelacionado method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDoctoRelacionadoForArrayConstraintsFromSetDoctoRelacionado(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pagoDoctoRelacionadoItem) {
            // validation for constraint: itemType
            if (!$pagoDoctoRelacionadoItem instanceof \StructType\DoctoRelacionado) {
                $invalidValues[] = is_object($pagoDoctoRelacionadoItem) ? get_class($pagoDoctoRelacionadoItem) : sprintf('%s(%s)', gettype($pagoDoctoRelacionadoItem), var_export($pagoDoctoRelacionadoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DoctoRelacionado property can only contain items of type \StructType\DoctoRelacionado, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DoctoRelacionado value
     * @throws \InvalidArgumentException
     * @param \StructType\DoctoRelacionado[] $doctoRelacionado
     * @return \StructType\Pago
     */
    public function setDoctoRelacionado(array $doctoRelacionado = array())
    {
        // validation for constraint: array
        if ('' !== ($doctoRelacionadoArrayErrorMessage = self::validateDoctoRelacionadoForArrayConstraintsFromSetDoctoRelacionado($doctoRelacionado))) {
            throw new \InvalidArgumentException($doctoRelacionadoArrayErrorMessage, __LINE__);
        }
        $this->DoctoRelacionado = $doctoRelacionado;
        return $this;
    }
    /**
     * Add item to DoctoRelacionado value
     * @throws \InvalidArgumentException
     * @param \StructType\DoctoRelacionado $item
     * @return \StructType\Pago
     */
    public function addToDoctoRelacionado(\StructType\DoctoRelacionado $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DoctoRelacionado) {
            throw new \InvalidArgumentException(sprintf('The DoctoRelacionado property can only contain items of type \StructType\DoctoRelacionado, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DoctoRelacionado[] = $item;
        return $this;
    }
    /**
     * Get Impuestos value
     * @return \StructType\Impuestos[]|null
     */
    public function getImpuestos()
    {
        return $this->Impuestos;
    }
    /**
     * This method is responsible for validating the values passed to the setImpuestos method
     * This method is willingly generated in order to preserve the one-line inline validation within the setImpuestos method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateImpuestosForArrayConstraintsFromSetImpuestos(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pagoImpuestosItem) {
            // validation for constraint: itemType
            if (!$pagoImpuestosItem instanceof \StructType\Impuestos) {
                $invalidValues[] = is_object($pagoImpuestosItem) ? get_class($pagoImpuestosItem) : sprintf('%s(%s)', gettype($pagoImpuestosItem), var_export($pagoImpuestosItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Impuestos property can only contain items of type \StructType\Impuestos, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Impuestos value
     * @throws \InvalidArgumentException
     * @param \StructType\Impuestos[] $impuestos
     * @return \StructType\Pago
     */
    public function setImpuestos(array $impuestos = array())
    {
        // validation for constraint: array
        if ('' !== ($impuestosArrayErrorMessage = self::validateImpuestosForArrayConstraintsFromSetImpuestos($impuestos))) {
            throw new \InvalidArgumentException($impuestosArrayErrorMessage, __LINE__);
        }
        $this->Impuestos = $impuestos;
        return $this;
    }
    /**
     * Add item to Impuestos value
     * @throws \InvalidArgumentException
     * @param \StructType\Impuestos $item
     * @return \StructType\Pago
     */
    public function addToImpuestos(\StructType\Impuestos $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Impuestos) {
            throw new \InvalidArgumentException(sprintf('The Impuestos property can only contain items of type \StructType\Impuestos, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Impuestos[] = $item;
        return $this;
    }
    /**
     * Get CadPago value
     * @return string|null
     */
    public function getCadPago()
    {
        return $this->CadPago;
    }
    /**
     * Set CadPago value
     * @param string $cadPago
     * @return \StructType\Pago
     */
    public function setCadPago($cadPago = null)
    {
        // validation for constraint: string
        if (!is_null($cadPago) && !is_string($cadPago)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cadPago, true), gettype($cadPago)), __LINE__);
        }
        // validation for constraint: maxLength(8192)
        if (!is_null($cadPago) && mb_strlen($cadPago) > 8192) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8192', mb_strlen($cadPago)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($cadPago) && mb_strlen($cadPago) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($cadPago)), __LINE__);
        }
        $this->CadPago = $cadPago;
        return $this;
    }
    /**
     * Get CertPago value
     * @return string|null
     */
    public function getCertPago()
    {
        return $this->CertPago;
    }
    /**
     * Set CertPago value
     * @param string $certPago
     * @return \StructType\Pago
     */
    public function setCertPago($certPago = null)
    {
        // validation for constraint: string
        if (!is_null($certPago) && !is_string($certPago)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($certPago, true), gettype($certPago)), __LINE__);
        }
        $this->CertPago = $certPago;
        return $this;
    }
    /**
     * Get CtaBeneficiario value
     * @return string|null
     */
    public function getCtaBeneficiario()
    {
        return $this->CtaBeneficiario;
    }
    /**
     * Set CtaBeneficiario value
     * @param string $ctaBeneficiario
     * @return \StructType\Pago
     */
    public function setCtaBeneficiario($ctaBeneficiario = null)
    {
        // validation for constraint: string
        if (!is_null($ctaBeneficiario) && !is_string($ctaBeneficiario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ctaBeneficiario, true), gettype($ctaBeneficiario)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($ctaBeneficiario) && mb_strlen($ctaBeneficiario) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($ctaBeneficiario)), __LINE__);
        }
        // validation for constraint: minLength(10)
        if (!is_null($ctaBeneficiario) && mb_strlen($ctaBeneficiario) < 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 10', mb_strlen($ctaBeneficiario)), __LINE__);
        }
        // validation for constraint: pattern([A-Z0-9_]{10,50})
        if (!is_null($ctaBeneficiario) && !preg_match('/[A-Z0-9_]{10,50}/', $ctaBeneficiario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z0-9_]{10,50}', var_export($ctaBeneficiario, true)), __LINE__);
        }
        $this->CtaBeneficiario = $ctaBeneficiario;
        return $this;
    }
    /**
     * Get CtaOrdenante value
     * @return string|null
     */
    public function getCtaOrdenante()
    {
        return $this->CtaOrdenante;
    }
    /**
     * Set CtaOrdenante value
     * @param string $ctaOrdenante
     * @return \StructType\Pago
     */
    public function setCtaOrdenante($ctaOrdenante = null)
    {
        // validation for constraint: string
        if (!is_null($ctaOrdenante) && !is_string($ctaOrdenante)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ctaOrdenante, true), gettype($ctaOrdenante)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($ctaOrdenante) && mb_strlen($ctaOrdenante) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($ctaOrdenante)), __LINE__);
        }
        // validation for constraint: minLength(10)
        if (!is_null($ctaOrdenante) && mb_strlen($ctaOrdenante) < 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 10', mb_strlen($ctaOrdenante)), __LINE__);
        }
        // validation for constraint: pattern([A-Z0-9_]{10,50})
        if (!is_null($ctaOrdenante) && !preg_match('/[A-Z0-9_]{10,50}/', $ctaOrdenante)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z0-9_]{10,50}', var_export($ctaOrdenante, true)), __LINE__);
        }
        $this->CtaOrdenante = $ctaOrdenante;
        return $this;
    }
    /**
     * Get NomBancoOrdExt value
     * @return string|null
     */
    public function getNomBancoOrdExt()
    {
        return $this->NomBancoOrdExt;
    }
    /**
     * Set NomBancoOrdExt value
     * @param string $nomBancoOrdExt
     * @return \StructType\Pago
     */
    public function setNomBancoOrdExt($nomBancoOrdExt = null)
    {
        // validation for constraint: string
        if (!is_null($nomBancoOrdExt) && !is_string($nomBancoOrdExt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomBancoOrdExt, true), gettype($nomBancoOrdExt)), __LINE__);
        }
        // validation for constraint: maxLength(300)
        if (!is_null($nomBancoOrdExt) && mb_strlen($nomBancoOrdExt) > 300) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 300', mb_strlen($nomBancoOrdExt)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nomBancoOrdExt) && mb_strlen($nomBancoOrdExt) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nomBancoOrdExt)), __LINE__);
        }
        // validation for constraint: pattern([^|]{1,300})
        if (!is_null($nomBancoOrdExt) && !preg_match('/[^|]{1,300}/', $nomBancoOrdExt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^|]{1,300}', var_export($nomBancoOrdExt, true)), __LINE__);
        }
        $this->NomBancoOrdExt = $nomBancoOrdExt;
        return $this;
    }
    /**
     * Get NumOperacion value
     * @return string|null
     */
    public function getNumOperacion()
    {
        return $this->NumOperacion;
    }
    /**
     * Set NumOperacion value
     * @param string $numOperacion
     * @return \StructType\Pago
     */
    public function setNumOperacion($numOperacion = null)
    {
        // validation for constraint: string
        if (!is_null($numOperacion) && !is_string($numOperacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numOperacion, true), gettype($numOperacion)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($numOperacion) && mb_strlen($numOperacion) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($numOperacion)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($numOperacion) && mb_strlen($numOperacion) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($numOperacion)), __LINE__);
        }
        // validation for constraint: pattern([^|]{1,100})
        if (!is_null($numOperacion) && !preg_match('/[^|]{1,100}/', $numOperacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^|]{1,100}', var_export($numOperacion, true)), __LINE__);
        }
        $this->NumOperacion = $numOperacion;
        return $this;
    }
    /**
     * Get RfcEmisorCtaBen value
     * @return string|null
     */
    public function getRfcEmisorCtaBen()
    {
        return $this->RfcEmisorCtaBen;
    }
    /**
     * Set RfcEmisorCtaBen value
     * @param string $rfcEmisorCtaBen
     * @return \StructType\Pago
     */
    public function setRfcEmisorCtaBen($rfcEmisorCtaBen = null)
    {
        // validation for constraint: string
        if (!is_null($rfcEmisorCtaBen) && !is_string($rfcEmisorCtaBen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rfcEmisorCtaBen, true), gettype($rfcEmisorCtaBen)), __LINE__);
        }
        // validation for constraint: minLength(12)
        if (!is_null($rfcEmisorCtaBen) && mb_strlen($rfcEmisorCtaBen) < 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 12', mb_strlen($rfcEmisorCtaBen)), __LINE__);
        }
        // validation for constraint: pattern([A-Z&Ñ]{3}[0-9]{2}(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])[A-Z0-9]{2}[0-9A])
        if (!is_null($rfcEmisorCtaBen) && !preg_match('/[A-Z&Ñ]{3}[0-9]{2}(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])[A-Z0-9]{2}[0-9A]/', $rfcEmisorCtaBen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z&Ñ]{3}[0-9]{2}(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])[A-Z0-9]{2}[0-9A]', var_export($rfcEmisorCtaBen, true)), __LINE__);
        }
        $this->RfcEmisorCtaBen = $rfcEmisorCtaBen;
        return $this;
    }
    /**
     * Get RfcEmisorCtaOrd value
     * @return string|null
     */
    public function getRfcEmisorCtaOrd()
    {
        return $this->RfcEmisorCtaOrd;
    }
    /**
     * Set RfcEmisorCtaOrd value
     * @param string $rfcEmisorCtaOrd
     * @return \StructType\Pago
     */
    public function setRfcEmisorCtaOrd($rfcEmisorCtaOrd = null)
    {
        // validation for constraint: string
        if (!is_null($rfcEmisorCtaOrd) && !is_string($rfcEmisorCtaOrd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rfcEmisorCtaOrd, true), gettype($rfcEmisorCtaOrd)), __LINE__);
        }
        // validation for constraint: maxLength(13)
        if (!is_null($rfcEmisorCtaOrd) && mb_strlen($rfcEmisorCtaOrd) > 13) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 13', mb_strlen($rfcEmisorCtaOrd)), __LINE__);
        }
        // validation for constraint: minLength(12)
        if (!is_null($rfcEmisorCtaOrd) && mb_strlen($rfcEmisorCtaOrd) < 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 12', mb_strlen($rfcEmisorCtaOrd)), __LINE__);
        }
        // validation for constraint: pattern(XEXX010101000|[A-Z&Ñ]{3}[0-9]{2}(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])[A-Z0-9]{2}[0-9A])
        if (!is_null($rfcEmisorCtaOrd) && !preg_match('/XEXX010101000|[A-Z&Ñ]{3}[0-9]{2}(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])[A-Z0-9]{2}[0-9A]/', $rfcEmisorCtaOrd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression XEXX010101000|[A-Z&Ñ]{3}[0-9]{2}(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])[A-Z0-9]{2}[0-9A]', var_export($rfcEmisorCtaOrd, true)), __LINE__);
        }
        $this->RfcEmisorCtaOrd = $rfcEmisorCtaOrd;
        return $this;
    }
    /**
     * Get SelloPago value
     * @return string|null
     */
    public function getSelloPago()
    {
        return $this->SelloPago;
    }
    /**
     * Set SelloPago value
     * @param string $selloPago
     * @return \StructType\Pago
     */
    public function setSelloPago($selloPago = null)
    {
        // validation for constraint: string
        if (!is_null($selloPago) && !is_string($selloPago)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selloPago, true), gettype($selloPago)), __LINE__);
        }
        $this->SelloPago = $selloPago;
        return $this;
    }
    /**
     * Get TipoCadPago value
     * @return string|null
     */
    public function getTipoCadPago()
    {
        return $this->TipoCadPago;
    }
    /**
     * Set TipoCadPago value
     * @uses \EnumType\C_TipoCadenaPago::valueIsValid()
     * @uses \EnumType\C_TipoCadenaPago::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoCadPago
     * @return \StructType\Pago
     */
    public function setTipoCadPago($tipoCadPago = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\C_TipoCadenaPago::valueIsValid($tipoCadPago)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\C_TipoCadenaPago', is_array($tipoCadPago) ? implode(', ', $tipoCadPago) : var_export($tipoCadPago, true), implode(', ', \EnumType\C_TipoCadenaPago::getValidValues())), __LINE__);
        }
        $this->TipoCadPago = $tipoCadPago;
        return $this;
    }
    /**
     * Get TipoCambioP value
     * @return float|null
     */
    public function getTipoCambioP()
    {
        return $this->TipoCambioP;
    }
    /**
     * Set TipoCambioP value
     * @param float $tipoCambioP
     * @return \StructType\Pago
     */
    public function setTipoCambioP($tipoCambioP = null)
    {
        // validation for constraint: float
        if (!is_null($tipoCambioP) && !(is_float($tipoCambioP) || is_numeric($tipoCambioP))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tipoCambioP, true), gettype($tipoCambioP)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($tipoCambioP) && mb_strlen(mb_substr($tipoCambioP, false !== mb_strpos($tipoCambioP, '.') ? mb_strpos($tipoCambioP, '.') + 1 : mb_strlen($tipoCambioP))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($tipoCambioP, true), mb_strlen(mb_substr($tipoCambioP, mb_strpos($tipoCambioP, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive(0.000001)
        if (!is_null($tipoCambioP) && $tipoCambioP < 0.000001) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.000001', var_export($tipoCambioP, true)), __LINE__);
        }
        $this->TipoCambioP = $tipoCambioP;
        return $this;
    }
}
