<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for orderIdentification StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo requerido que especifica información sobre la orden de compra a la que hace referencia la factura
 * @subpackage Structs
 */
class OrderIdentification extends AbstractStructBase
{
    /**
     * The referenceIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: 30
     * @var \StructType\ReferenceIdentification[]
     */
    public $referenceIdentification;
    /**
     * The ReferenceDate
     * Meta information extracted from the WSDL
     * - documentation: Nodo opcional que especifica la fecha de la orden de compra(comprador) a la que hace referencia la factura
     * - minOccurs: 0
     * @var string
     */
    public $ReferenceDate;
    /**
     * Constructor method for orderIdentification
     * @uses OrderIdentification::setReferenceIdentification()
     * @uses OrderIdentification::setReferenceDate()
     * @param \StructType\ReferenceIdentification[] $referenceIdentification
     * @param string $referenceDate
     */
    public function __construct(array $referenceIdentification = array(), $referenceDate = null)
    {
        $this
            ->setReferenceIdentification($referenceIdentification)
            ->setReferenceDate($referenceDate);
    }
    /**
     * Get referenceIdentification value
     * @return \StructType\ReferenceIdentification[]|null
     */
    public function getReferenceIdentification()
    {
        return $this->referenceIdentification;
    }
    /**
     * This method is responsible for validating the values passed to the setReferenceIdentification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReferenceIdentification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReferenceIdentificationForArrayConstraintsFromSetReferenceIdentification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderIdentificationReferenceIdentificationItem) {
            // validation for constraint: itemType
            if (!$orderIdentificationReferenceIdentificationItem instanceof \StructType\ReferenceIdentification) {
                $invalidValues[] = is_object($orderIdentificationReferenceIdentificationItem) ? get_class($orderIdentificationReferenceIdentificationItem) : sprintf('%s(%s)', gettype($orderIdentificationReferenceIdentificationItem), var_export($orderIdentificationReferenceIdentificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The referenceIdentification property can only contain items of type \StructType\ReferenceIdentification, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set referenceIdentification value
     * @throws \InvalidArgumentException
     * @param \StructType\ReferenceIdentification[] $referenceIdentification
     * @return \StructType\OrderIdentification
     */
    public function setReferenceIdentification(array $referenceIdentification = array())
    {
        // validation for constraint: array
        if ('' !== ($referenceIdentificationArrayErrorMessage = self::validateReferenceIdentificationForArrayConstraintsFromSetReferenceIdentification($referenceIdentification))) {
            throw new \InvalidArgumentException($referenceIdentificationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($referenceIdentification) && count($referenceIdentification) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 30', count($referenceIdentification)), __LINE__);
        }
        $this->referenceIdentification = $referenceIdentification;
        return $this;
    }
    /**
     * Add item to referenceIdentification value
     * @throws \InvalidArgumentException
     * @param \StructType\ReferenceIdentification $item
     * @return \StructType\OrderIdentification
     */
    public function addToReferenceIdentification(\StructType\ReferenceIdentification $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReferenceIdentification) {
            throw new \InvalidArgumentException(sprintf('The referenceIdentification property can only contain items of type \StructType\ReferenceIdentification, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($this->referenceIdentification) && count($this->referenceIdentification) >= 30) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 30', count($this->referenceIdentification)), __LINE__);
        }
        $this->referenceIdentification[] = $item;
        return $this;
    }
    /**
     * Get ReferenceDate value
     * @return string|null
     */
    public function getReferenceDate()
    {
        return $this->ReferenceDate;
    }
    /**
     * Set ReferenceDate value
     * @param string $referenceDate
     * @return \StructType\OrderIdentification
     */
    public function setReferenceDate($referenceDate = null)
    {
        // validation for constraint: string
        if (!is_null($referenceDate) && !is_string($referenceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceDate, true), gettype($referenceDate)), __LINE__);
        }
        $this->ReferenceDate = $referenceDate;
        return $this;
    }
}
