<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for netPayment StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo opcional que especifica las condiciones de pago
 * @subpackage Structs
 */
class NetPayment extends AbstractStructBase
{
    /**
     * The netPaymentTermsType
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $netPaymentTermsType;
    /**
     * The paymentTimePeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaymentTimePeriod
     */
    public $paymentTimePeriod;
    /**
     * Constructor method for netPayment
     * @uses NetPayment::setNetPaymentTermsType()
     * @uses NetPayment::setPaymentTimePeriod()
     * @param string $netPaymentTermsType
     * @param \StructType\PaymentTimePeriod $paymentTimePeriod
     */
    public function __construct($netPaymentTermsType = null, \StructType\PaymentTimePeriod $paymentTimePeriod = null)
    {
        $this
            ->setNetPaymentTermsType($netPaymentTermsType)
            ->setPaymentTimePeriod($paymentTimePeriod);
    }
    /**
     * Get netPaymentTermsType value
     * @return string
     */
    public function getNetPaymentTermsType()
    {
        return $this->netPaymentTermsType;
    }
    /**
     * Set netPaymentTermsType value
     * @param string $netPaymentTermsType
     * @return \StructType\NetPayment
     */
    public function setNetPaymentTermsType($netPaymentTermsType = null)
    {
        // validation for constraint: string
        if (!is_null($netPaymentTermsType) && !is_string($netPaymentTermsType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($netPaymentTermsType, true), gettype($netPaymentTermsType)), __LINE__);
        }
        $this->netPaymentTermsType = $netPaymentTermsType;
        return $this;
    }
    /**
     * Get paymentTimePeriod value
     * @return \StructType\PaymentTimePeriod|null
     */
    public function getPaymentTimePeriod()
    {
        return $this->paymentTimePeriod;
    }
    /**
     * Set paymentTimePeriod value
     * @param \StructType\PaymentTimePeriod $paymentTimePeriod
     * @return \StructType\NetPayment
     */
    public function setPaymentTimePeriod(\StructType\PaymentTimePeriod $paymentTimePeriod = null)
    {
        $this->paymentTimePeriod = $paymentTimePeriod;
        return $this;
    }
}
