<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for netAmount StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo requerido que especifica el importe neto
 * @subpackage Structs
 */
class NetAmount extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Nodo requerido que especifica el importe neto de la línea de artículo
     * @var float
     */
    public $Amount;
    /**
     * Constructor method for netAmount
     * @uses NetAmount::setAmount()
     * @param float $amount
     */
    public function __construct($amount = null)
    {
        $this
            ->setAmount($amount);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\NetAmount
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
}
