<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for nameAndAddress StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo requerido que especifica la etiqueta padre que indica que se empezará a definir el nombre y dirección de la ubicación donde esta la aduana | Nodo opcional que especifica el nombre y dirección de la ubicación donde debe
 * realizarse la entrega de mercancía
 * @subpackage Structs
 */
class NameAndAddress extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: Nodo opcional que especifica la razón social de la empresa a donde se va a embarcar en caso de ser diferente al comprador, o el nombre de la bodega o centro de distribución | Nodo opcional que especifica la razón social de la
     * empresa a dende se emite la factura en caso de ser diferente al identificador del proveedor | Nodo requerido que especifica el nombre de la Aduana | SG2NAD 3036 CALIF BY | SG2NAD 3036 CALIF SU
     * - base: xsd:string
     * - form: qualified
     * - maxLength: 35
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The streetAddressOne
     * Meta information extracted from the WSDL
     * - documentation: Nodo opcional que especifica el domicilio a donde se embarcara la mercancía: Calle, número exterior, número interior y colonias | Nodo opcional que especifica el domicilio del emisor de la factura: Calle, número exterior, número
     * interior y colonias
     * - base: xs:string
     * - maxLength: 35
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $streetAddressOne;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - documentation: Nodo opcional que especifica la ciudad donde se encuentra el domicilio a donde se embarcará la mercancía | Nodo opcional que especifica la ciudad donde se encuentra el domicilio del emisor de la factura
     * - base: xs:string
     * - maxLength: 35
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $city;
    /**
     * The postalCode
     * Meta information extracted from the WSDL
     * - documentation: Nodo opcional que especifica el codigo postal del domicilio a donde se embarcara la mercancía | Nodo opcional que especifica el codigo postal del domicilio del emisor de la factura
     * - base: xs:string
     * - maxLength: 9
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $postalCode;
    /**
     * Constructor method for nameAndAddress
     * @uses NameAndAddress::setName()
     * @uses NameAndAddress::setStreetAddressOne()
     * @uses NameAndAddress::setCity()
     * @uses NameAndAddress::setPostalCode()
     * @param string $name
     * @param string $streetAddressOne
     * @param string $city
     * @param string $postalCode
     */
    public function __construct($name = null, $streetAddressOne = null, $city = null, $postalCode = null)
    {
        $this
            ->setName($name)
            ->setStreetAddressOne($streetAddressOne)
            ->setCity($city)
            ->setPostalCode($postalCode);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\NameAndAddress
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($name) && mb_strlen($name) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($name)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($name) && mb_strlen($name) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get streetAddressOne value
     * @return string|null
     */
    public function getStreetAddressOne()
    {
        return $this->streetAddressOne;
    }
    /**
     * Set streetAddressOne value
     * @param string $streetAddressOne
     * @return \StructType\NameAndAddress
     */
    public function setStreetAddressOne($streetAddressOne = null)
    {
        // validation for constraint: string
        if (!is_null($streetAddressOne) && !is_string($streetAddressOne)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetAddressOne, true), gettype($streetAddressOne)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($streetAddressOne) && mb_strlen($streetAddressOne) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($streetAddressOne)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($streetAddressOne) && mb_strlen($streetAddressOne) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($streetAddressOne)), __LINE__);
        }
        $this->streetAddressOne = $streetAddressOne;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\NameAndAddress
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($city) && mb_strlen($city) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($city)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($city) && mb_strlen($city) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get postalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->postalCode;
    }
    /**
     * Set postalCode value
     * @param string $postalCode
     * @return \StructType\NameAndAddress
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        // validation for constraint: maxLength(9)
        if (!is_null($postalCode) && mb_strlen($postalCode) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 9', mb_strlen($postalCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($postalCode) && mb_strlen($postalCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($postalCode)), __LINE__);
        }
        $this->postalCode = $postalCode;
        return $this;
    }
}
