<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for monetaryAmountOrPercentage StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo requerido que especifica la cantidad monetaria o descuento por linea de articulo | Nodo opcional que especifica la cantidad monetaria o porcentaje del descuento
 * @subpackage Structs
 */
class MonetaryAmountOrPercentage extends AbstractStructBase
{
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Rate
     */
    public $rate;
    /**
     * The percentagePerUnit
     * Meta information extracted from the WSDL
     * - documentation: Nodo requerido que especifica el porcentaje del cargo o descuento
     * - base: xs:string
     * - maxLength: 5
     * - minLength: 1
     * @var string
     */
    public $percentagePerUnit;
    /**
     * The ratePerUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RatePerUnit
     */
    public $ratePerUnit;
    /**
     * Constructor method for monetaryAmountOrPercentage
     * @uses MonetaryAmountOrPercentage::setRate()
     * @uses MonetaryAmountOrPercentage::setPercentagePerUnit()
     * @uses MonetaryAmountOrPercentage::setRatePerUnit()
     * @param \StructType\Rate $rate
     * @param string $percentagePerUnit
     * @param \StructType\RatePerUnit $ratePerUnit
     */
    public function __construct(\StructType\Rate $rate = null, $percentagePerUnit = null, \StructType\RatePerUnit $ratePerUnit = null)
    {
        $this
            ->setRate($rate)
            ->setPercentagePerUnit($percentagePerUnit)
            ->setRatePerUnit($ratePerUnit);
    }
    /**
     * Get rate value
     * @return \StructType\Rate|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param \StructType\Rate $rate
     * @return \StructType\MonetaryAmountOrPercentage
     */
    public function setRate(\StructType\Rate $rate = null)
    {
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get percentagePerUnit value
     * @return string|null
     */
    public function getPercentagePerUnit()
    {
        return $this->percentagePerUnit;
    }
    /**
     * Set percentagePerUnit value
     * @param string $percentagePerUnit
     * @return \StructType\MonetaryAmountOrPercentage
     */
    public function setPercentagePerUnit($percentagePerUnit = null)
    {
        // validation for constraint: string
        if (!is_null($percentagePerUnit) && !is_string($percentagePerUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($percentagePerUnit, true), gettype($percentagePerUnit)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($percentagePerUnit) && mb_strlen($percentagePerUnit) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($percentagePerUnit)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($percentagePerUnit) && mb_strlen($percentagePerUnit) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($percentagePerUnit)), __LINE__);
        }
        $this->percentagePerUnit = $percentagePerUnit;
        return $this;
    }
    /**
     * Get ratePerUnit value
     * @return \StructType\RatePerUnit|null
     */
    public function getRatePerUnit()
    {
        return $this->ratePerUnit;
    }
    /**
     * Set ratePerUnit value
     * @param \StructType\RatePerUnit $ratePerUnit
     * @return \StructType\MonetaryAmountOrPercentage
     */
    public function setRatePerUnit(\StructType\RatePerUnit $ratePerUnit = null)
    {
        $this->ratePerUnit = $ratePerUnit;
        return $this;
    }
}
