<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for messageError StructType
 * Meta information extracted from the WSDL
 * - documentation: SG4 ERC
 * @subpackage Structs
 */
class MessageError extends AbstractStructBase
{
    /**
     * The errorCode
     * Meta information extracted from the WSDL
     * - form: qualified
     * @var string
     */
    public $errorCode;
    /**
     * The errorDescription
     * Meta information extracted from the WSDL
     * - form: qualified
     * @var \StructType\ErrorDescription
     */
    public $errorDescription;
    /**
     * The referenceIdentification
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - form: qualified
     * - minOccurs: 0
     * @var string
     */
    public $referenceIdentification;
    /**
     * The sequence
     * Meta information extracted from the WSDL
     * - base: xsd:integer
     * - fractionDigits: 0
     * - totalDigits: 5
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for messageError
     * @uses MessageError::setErrorCode()
     * @uses MessageError::setErrorDescription()
     * @uses MessageError::setReferenceIdentification()
     * @uses MessageError::setSequence()
     * @param string $errorCode
     * @param \StructType\ErrorDescription $errorDescription
     * @param string $referenceIdentification
     * @param int $sequence
     */
    public function __construct($errorCode = null, \StructType\ErrorDescription $errorDescription = null, $referenceIdentification = null, $sequence = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setErrorDescription($errorDescription)
            ->setReferenceIdentification($referenceIdentification)
            ->setSequence($sequence);
    }
    /**
     * Get errorCode value
     * @return string|null
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @param string $errorCode
     * @return \StructType\MessageError
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get errorDescription value
     * @return \StructType\ErrorDescription|null
     */
    public function getErrorDescription()
    {
        return $this->errorDescription;
    }
    /**
     * Set errorDescription value
     * @param \StructType\ErrorDescription $errorDescription
     * @return \StructType\MessageError
     */
    public function setErrorDescription(\StructType\ErrorDescription $errorDescription = null)
    {
        $this->errorDescription = $errorDescription;
        return $this;
    }
    /**
     * Get referenceIdentification value
     * @return string|null
     */
    public function getReferenceIdentification()
    {
        return $this->referenceIdentification;
    }
    /**
     * Set referenceIdentification value
     * @param string $referenceIdentification
     * @return \StructType\MessageError
     */
    public function setReferenceIdentification($referenceIdentification = null)
    {
        // validation for constraint: string
        if (!is_null($referenceIdentification) && !is_string($referenceIdentification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceIdentification, true), gettype($referenceIdentification)), __LINE__);
        }
        $this->referenceIdentification = $referenceIdentification;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \StructType\MessageError
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !(is_int($sequence) || ctype_digit($sequence))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sequence, true), gettype($sequence)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($sequence) && mb_strlen(mb_substr($sequence, false !== mb_strpos($sequence, '.') ? mb_strpos($sequence, '.') + 1 : mb_strlen($sequence))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($sequence, true), mb_strlen(mb_substr($sequence, mb_strpos($sequence, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($sequence) && mb_strlen(preg_replace('/(\D)/', '', $sequence)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($sequence, true), mb_strlen(preg_replace('/(\D)/', '', $sequence))), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
}
