<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for lineItem StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo opcional que especifica la linea de detalle de la factura
 * @subpackage Structs
 */
class LineItem extends AbstractStructBase
{
    /**
     * The tradeItemIdentification
     * @var \StructType\TradeItemIdentification
     */
    public $tradeItemIdentification;
    /**
     * The alternateTradeItemIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: 999999
     * - minOccurs: 0
     * @var \StructType\AlternateTradeItemIdentification[]
     */
    public $alternateTradeItemIdentification;
    /**
     * The tradeItemDescriptionInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TradeItemDescriptionInformation
     */
    public $tradeItemDescriptionInformation;
    /**
     * The invoicedQuantity
     * @var \StructType\InvoicedQuantity
     */
    public $invoicedQuantity;
    /**
     * The aditionalQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 9999
     * - minOccurs: 0
     * @var \StructType\AditionalQuantity[]
     */
    public $aditionalQuantity;
    /**
     * The grossPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\GrossPrice
     */
    public $grossPrice;
    /**
     * The netPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NetPrice
     */
    public $netPrice;
    /**
     * The AdditionalInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AdditionalInformation
     */
    public $AdditionalInformation;
    /**
     * The Customs
     * Meta information extracted from the WSDL
     * - maxOccurs: 999999
     * - minOccurs: 0
     * @var \StructType\Customs[]
     */
    public $Customs;
    /**
     * The LogisticUnits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LogisticUnits
     */
    public $LogisticUnits;
    /**
     * The palletInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PalletInformation
     */
    public $palletInformation;
    /**
     * The extendedAttributes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtendedAttributes
     */
    public $extendedAttributes;
    /**
     * The allowanceCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\AllowanceCharge[]
     */
    public $allowanceCharge;
    /**
     * The tradeItemTaxInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\TradeItemTaxInformation[]
     */
    public $tradeItemTaxInformation;
    /**
     * The totalLineAmount
     * @var \StructType\TotalLineAmount
     */
    public $totalLineAmount;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - base: xs:integer
     * - fractionDigits: 0
     * - totalDigits: 5
     * @var int
     */
    public $number;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - default: SimpleInvoiceLineItemType
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $type;
    /**
     * Constructor method for lineItem
     * @uses LineItem::setTradeItemIdentification()
     * @uses LineItem::setAlternateTradeItemIdentification()
     * @uses LineItem::setTradeItemDescriptionInformation()
     * @uses LineItem::setInvoicedQuantity()
     * @uses LineItem::setAditionalQuantity()
     * @uses LineItem::setGrossPrice()
     * @uses LineItem::setNetPrice()
     * @uses LineItem::setAdditionalInformation()
     * @uses LineItem::setCustoms()
     * @uses LineItem::setLogisticUnits()
     * @uses LineItem::setPalletInformation()
     * @uses LineItem::setExtendedAttributes()
     * @uses LineItem::setAllowanceCharge()
     * @uses LineItem::setTradeItemTaxInformation()
     * @uses LineItem::setTotalLineAmount()
     * @uses LineItem::setNumber()
     * @uses LineItem::setType()
     * @param \StructType\TradeItemIdentification $tradeItemIdentification
     * @param \StructType\AlternateTradeItemIdentification[] $alternateTradeItemIdentification
     * @param \StructType\TradeItemDescriptionInformation $tradeItemDescriptionInformation
     * @param \StructType\InvoicedQuantity $invoicedQuantity
     * @param \StructType\AditionalQuantity[] $aditionalQuantity
     * @param \StructType\GrossPrice $grossPrice
     * @param \StructType\NetPrice $netPrice
     * @param \StructType\AdditionalInformation $additionalInformation
     * @param \StructType\Customs[] $customs
     * @param \StructType\LogisticUnits $logisticUnits
     * @param \StructType\PalletInformation $palletInformation
     * @param \StructType\ExtendedAttributes $extendedAttributes
     * @param \StructType\AllowanceCharge[] $allowanceCharge
     * @param \StructType\TradeItemTaxInformation[] $tradeItemTaxInformation
     * @param \StructType\TotalLineAmount $totalLineAmount
     * @param int $number
     * @param string $type
     */
    public function __construct(\StructType\TradeItemIdentification $tradeItemIdentification = null, array $alternateTradeItemIdentification = array(), \StructType\TradeItemDescriptionInformation $tradeItemDescriptionInformation = null, \StructType\InvoicedQuantity $invoicedQuantity = null, array $aditionalQuantity = array(), \StructType\GrossPrice $grossPrice = null, \StructType\NetPrice $netPrice = null, \StructType\AdditionalInformation $additionalInformation = null, array $customs = array(), \StructType\LogisticUnits $logisticUnits = null, \StructType\PalletInformation $palletInformation = null, \StructType\ExtendedAttributes $extendedAttributes = null, array $allowanceCharge = array(), array $tradeItemTaxInformation = array(), \StructType\TotalLineAmount $totalLineAmount = null, $number = null, $type = 'SimpleInvoiceLineItemType')
    {
        $this
            ->setTradeItemIdentification($tradeItemIdentification)
            ->setAlternateTradeItemIdentification($alternateTradeItemIdentification)
            ->setTradeItemDescriptionInformation($tradeItemDescriptionInformation)
            ->setInvoicedQuantity($invoicedQuantity)
            ->setAditionalQuantity($aditionalQuantity)
            ->setGrossPrice($grossPrice)
            ->setNetPrice($netPrice)
            ->setAdditionalInformation($additionalInformation)
            ->setCustoms($customs)
            ->setLogisticUnits($logisticUnits)
            ->setPalletInformation($palletInformation)
            ->setExtendedAttributes($extendedAttributes)
            ->setAllowanceCharge($allowanceCharge)
            ->setTradeItemTaxInformation($tradeItemTaxInformation)
            ->setTotalLineAmount($totalLineAmount)
            ->setNumber($number)
            ->setType($type);
    }
    /**
     * Get tradeItemIdentification value
     * @return \StructType\TradeItemIdentification|null
     */
    public function getTradeItemIdentification()
    {
        return $this->tradeItemIdentification;
    }
    /**
     * Set tradeItemIdentification value
     * @param \StructType\TradeItemIdentification $tradeItemIdentification
     * @return \StructType\LineItem
     */
    public function setTradeItemIdentification(\StructType\TradeItemIdentification $tradeItemIdentification = null)
    {
        $this->tradeItemIdentification = $tradeItemIdentification;
        return $this;
    }
    /**
     * Get alternateTradeItemIdentification value
     * @return \StructType\AlternateTradeItemIdentification[]|null
     */
    public function getAlternateTradeItemIdentification()
    {
        return $this->alternateTradeItemIdentification;
    }
    /**
     * This method is responsible for validating the values passed to the setAlternateTradeItemIdentification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlternateTradeItemIdentification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlternateTradeItemIdentificationForArrayConstraintsFromSetAlternateTradeItemIdentification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $lineItemAlternateTradeItemIdentificationItem) {
            // validation for constraint: itemType
            if (!$lineItemAlternateTradeItemIdentificationItem instanceof \StructType\AlternateTradeItemIdentification) {
                $invalidValues[] = is_object($lineItemAlternateTradeItemIdentificationItem) ? get_class($lineItemAlternateTradeItemIdentificationItem) : sprintf('%s(%s)', gettype($lineItemAlternateTradeItemIdentificationItem), var_export($lineItemAlternateTradeItemIdentificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The alternateTradeItemIdentification property can only contain items of type \StructType\AlternateTradeItemIdentification, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set alternateTradeItemIdentification value
     * @throws \InvalidArgumentException
     * @param \StructType\AlternateTradeItemIdentification[] $alternateTradeItemIdentification
     * @return \StructType\LineItem
     */
    public function setAlternateTradeItemIdentification(array $alternateTradeItemIdentification = array())
    {
        // validation for constraint: array
        if ('' !== ($alternateTradeItemIdentificationArrayErrorMessage = self::validateAlternateTradeItemIdentificationForArrayConstraintsFromSetAlternateTradeItemIdentification($alternateTradeItemIdentification))) {
            throw new \InvalidArgumentException($alternateTradeItemIdentificationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(999999)
        if (is_array($alternateTradeItemIdentification) && count($alternateTradeItemIdentification) > 999999) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 999999', count($alternateTradeItemIdentification)), __LINE__);
        }
        $this->alternateTradeItemIdentification = $alternateTradeItemIdentification;
        return $this;
    }
    /**
     * Add item to alternateTradeItemIdentification value
     * @throws \InvalidArgumentException
     * @param \StructType\AlternateTradeItemIdentification $item
     * @return \StructType\LineItem
     */
    public function addToAlternateTradeItemIdentification(\StructType\AlternateTradeItemIdentification $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AlternateTradeItemIdentification) {
            throw new \InvalidArgumentException(sprintf('The alternateTradeItemIdentification property can only contain items of type \StructType\AlternateTradeItemIdentification, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(999999)
        if (is_array($this->alternateTradeItemIdentification) && count($this->alternateTradeItemIdentification) >= 999999) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 999999', count($this->alternateTradeItemIdentification)), __LINE__);
        }
        $this->alternateTradeItemIdentification[] = $item;
        return $this;
    }
    /**
     * Get tradeItemDescriptionInformation value
     * @return \StructType\TradeItemDescriptionInformation|null
     */
    public function getTradeItemDescriptionInformation()
    {
        return $this->tradeItemDescriptionInformation;
    }
    /**
     * Set tradeItemDescriptionInformation value
     * @param \StructType\TradeItemDescriptionInformation $tradeItemDescriptionInformation
     * @return \StructType\LineItem
     */
    public function setTradeItemDescriptionInformation(\StructType\TradeItemDescriptionInformation $tradeItemDescriptionInformation = null)
    {
        $this->tradeItemDescriptionInformation = $tradeItemDescriptionInformation;
        return $this;
    }
    /**
     * Get invoicedQuantity value
     * @return \StructType\InvoicedQuantity|null
     */
    public function getInvoicedQuantity()
    {
        return $this->invoicedQuantity;
    }
    /**
     * Set invoicedQuantity value
     * @param \StructType\InvoicedQuantity $invoicedQuantity
     * @return \StructType\LineItem
     */
    public function setInvoicedQuantity(\StructType\InvoicedQuantity $invoicedQuantity = null)
    {
        $this->invoicedQuantity = $invoicedQuantity;
        return $this;
    }
    /**
     * Get aditionalQuantity value
     * @return \StructType\AditionalQuantity[]|null
     */
    public function getAditionalQuantity()
    {
        return $this->aditionalQuantity;
    }
    /**
     * This method is responsible for validating the values passed to the setAditionalQuantity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAditionalQuantity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAditionalQuantityForArrayConstraintsFromSetAditionalQuantity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $lineItemAditionalQuantityItem) {
            // validation for constraint: itemType
            if (!$lineItemAditionalQuantityItem instanceof \StructType\AditionalQuantity) {
                $invalidValues[] = is_object($lineItemAditionalQuantityItem) ? get_class($lineItemAditionalQuantityItem) : sprintf('%s(%s)', gettype($lineItemAditionalQuantityItem), var_export($lineItemAditionalQuantityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The aditionalQuantity property can only contain items of type \StructType\AditionalQuantity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set aditionalQuantity value
     * @throws \InvalidArgumentException
     * @param \StructType\AditionalQuantity[] $aditionalQuantity
     * @return \StructType\LineItem
     */
    public function setAditionalQuantity(array $aditionalQuantity = array())
    {
        // validation for constraint: array
        if ('' !== ($aditionalQuantityArrayErrorMessage = self::validateAditionalQuantityForArrayConstraintsFromSetAditionalQuantity($aditionalQuantity))) {
            throw new \InvalidArgumentException($aditionalQuantityArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9999)
        if (is_array($aditionalQuantity) && count($aditionalQuantity) > 9999) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9999', count($aditionalQuantity)), __LINE__);
        }
        $this->aditionalQuantity = $aditionalQuantity;
        return $this;
    }
    /**
     * Add item to aditionalQuantity value
     * @throws \InvalidArgumentException
     * @param \StructType\AditionalQuantity $item
     * @return \StructType\LineItem
     */
    public function addToAditionalQuantity(\StructType\AditionalQuantity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AditionalQuantity) {
            throw new \InvalidArgumentException(sprintf('The aditionalQuantity property can only contain items of type \StructType\AditionalQuantity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9999)
        if (is_array($this->aditionalQuantity) && count($this->aditionalQuantity) >= 9999) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9999', count($this->aditionalQuantity)), __LINE__);
        }
        $this->aditionalQuantity[] = $item;
        return $this;
    }
    /**
     * Get grossPrice value
     * @return \StructType\GrossPrice|null
     */
    public function getGrossPrice()
    {
        return $this->grossPrice;
    }
    /**
     * Set grossPrice value
     * @param \StructType\GrossPrice $grossPrice
     * @return \StructType\LineItem
     */
    public function setGrossPrice(\StructType\GrossPrice $grossPrice = null)
    {
        $this->grossPrice = $grossPrice;
        return $this;
    }
    /**
     * Get netPrice value
     * @return \StructType\NetPrice|null
     */
    public function getNetPrice()
    {
        return $this->netPrice;
    }
    /**
     * Set netPrice value
     * @param \StructType\NetPrice $netPrice
     * @return \StructType\LineItem
     */
    public function setNetPrice(\StructType\NetPrice $netPrice = null)
    {
        $this->netPrice = $netPrice;
        return $this;
    }
    /**
     * Get AdditionalInformation value
     * @return \StructType\AdditionalInformation|null
     */
    public function getAdditionalInformation()
    {
        return $this->AdditionalInformation;
    }
    /**
     * Set AdditionalInformation value
     * @param \StructType\AdditionalInformation $additionalInformation
     * @return \StructType\LineItem
     */
    public function setAdditionalInformation(\StructType\AdditionalInformation $additionalInformation = null)
    {
        $this->AdditionalInformation = $additionalInformation;
        return $this;
    }
    /**
     * Get Customs value
     * @return \StructType\Customs[]|null
     */
    public function getCustoms()
    {
        return $this->Customs;
    }
    /**
     * This method is responsible for validating the values passed to the setCustoms method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustoms method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomsForArrayConstraintsFromSetCustoms(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $lineItemCustomsItem) {
            // validation for constraint: itemType
            if (!$lineItemCustomsItem instanceof \StructType\Customs) {
                $invalidValues[] = is_object($lineItemCustomsItem) ? get_class($lineItemCustomsItem) : sprintf('%s(%s)', gettype($lineItemCustomsItem), var_export($lineItemCustomsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Customs property can only contain items of type \StructType\Customs, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Customs value
     * @throws \InvalidArgumentException
     * @param \StructType\Customs[] $customs
     * @return \StructType\LineItem
     */
    public function setCustoms(array $customs = array())
    {
        // validation for constraint: array
        if ('' !== ($customsArrayErrorMessage = self::validateCustomsForArrayConstraintsFromSetCustoms($customs))) {
            throw new \InvalidArgumentException($customsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(999999)
        if (is_array($customs) && count($customs) > 999999) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 999999', count($customs)), __LINE__);
        }
        $this->Customs = $customs;
        return $this;
    }
    /**
     * Add item to Customs value
     * @throws \InvalidArgumentException
     * @param \StructType\Customs $item
     * @return \StructType\LineItem
     */
    public function addToCustoms(\StructType\Customs $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Customs) {
            throw new \InvalidArgumentException(sprintf('The Customs property can only contain items of type \StructType\Customs, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(999999)
        if (is_array($this->Customs) && count($this->Customs) >= 999999) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 999999', count($this->Customs)), __LINE__);
        }
        $this->Customs[] = $item;
        return $this;
    }
    /**
     * Get LogisticUnits value
     * @return \StructType\LogisticUnits|null
     */
    public function getLogisticUnits()
    {
        return $this->LogisticUnits;
    }
    /**
     * Set LogisticUnits value
     * @param \StructType\LogisticUnits $logisticUnits
     * @return \StructType\LineItem
     */
    public function setLogisticUnits(\StructType\LogisticUnits $logisticUnits = null)
    {
        $this->LogisticUnits = $logisticUnits;
        return $this;
    }
    /**
     * Get palletInformation value
     * @return \StructType\PalletInformation|null
     */
    public function getPalletInformation()
    {
        return $this->palletInformation;
    }
    /**
     * Set palletInformation value
     * @param \StructType\PalletInformation $palletInformation
     * @return \StructType\LineItem
     */
    public function setPalletInformation(\StructType\PalletInformation $palletInformation = null)
    {
        $this->palletInformation = $palletInformation;
        return $this;
    }
    /**
     * Get extendedAttributes value
     * @return \StructType\ExtendedAttributes|null
     */
    public function getExtendedAttributes()
    {
        return $this->extendedAttributes;
    }
    /**
     * Set extendedAttributes value
     * @param \StructType\ExtendedAttributes $extendedAttributes
     * @return \StructType\LineItem
     */
    public function setExtendedAttributes(\StructType\ExtendedAttributes $extendedAttributes = null)
    {
        $this->extendedAttributes = $extendedAttributes;
        return $this;
    }
    /**
     * Get allowanceCharge value
     * @return \StructType\AllowanceCharge[]|null
     */
    public function getAllowanceCharge()
    {
        return $this->allowanceCharge;
    }
    /**
     * This method is responsible for validating the values passed to the setAllowanceCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAllowanceCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAllowanceChargeForArrayConstraintsFromSetAllowanceCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $lineItemAllowanceChargeItem) {
            // validation for constraint: itemType
            if (!$lineItemAllowanceChargeItem instanceof \StructType\AllowanceCharge) {
                $invalidValues[] = is_object($lineItemAllowanceChargeItem) ? get_class($lineItemAllowanceChargeItem) : sprintf('%s(%s)', gettype($lineItemAllowanceChargeItem), var_export($lineItemAllowanceChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The allowanceCharge property can only contain items of type \StructType\AllowanceCharge, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set allowanceCharge value
     * @throws \InvalidArgumentException
     * @param \StructType\AllowanceCharge[] $allowanceCharge
     * @return \StructType\LineItem
     */
    public function setAllowanceCharge(array $allowanceCharge = array())
    {
        // validation for constraint: array
        if ('' !== ($allowanceChargeArrayErrorMessage = self::validateAllowanceChargeForArrayConstraintsFromSetAllowanceCharge($allowanceCharge))) {
            throw new \InvalidArgumentException($allowanceChargeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($allowanceCharge) && count($allowanceCharge) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($allowanceCharge)), __LINE__);
        }
        $this->allowanceCharge = $allowanceCharge;
        return $this;
    }
    /**
     * Add item to allowanceCharge value
     * @throws \InvalidArgumentException
     * @param \StructType\AllowanceCharge $item
     * @return \StructType\LineItem
     */
    public function addToAllowanceCharge(\StructType\AllowanceCharge $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AllowanceCharge) {
            throw new \InvalidArgumentException(sprintf('The allowanceCharge property can only contain items of type \StructType\AllowanceCharge, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->allowanceCharge) && count($this->allowanceCharge) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->allowanceCharge)), __LINE__);
        }
        $this->allowanceCharge[] = $item;
        return $this;
    }
    /**
     * Get tradeItemTaxInformation value
     * @return \StructType\TradeItemTaxInformation[]|null
     */
    public function getTradeItemTaxInformation()
    {
        return $this->tradeItemTaxInformation;
    }
    /**
     * This method is responsible for validating the values passed to the setTradeItemTaxInformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTradeItemTaxInformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTradeItemTaxInformationForArrayConstraintsFromSetTradeItemTaxInformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $lineItemTradeItemTaxInformationItem) {
            // validation for constraint: itemType
            if (!$lineItemTradeItemTaxInformationItem instanceof \StructType\TradeItemTaxInformation) {
                $invalidValues[] = is_object($lineItemTradeItemTaxInformationItem) ? get_class($lineItemTradeItemTaxInformationItem) : sprintf('%s(%s)', gettype($lineItemTradeItemTaxInformationItem), var_export($lineItemTradeItemTaxInformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The tradeItemTaxInformation property can only contain items of type \StructType\TradeItemTaxInformation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set tradeItemTaxInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\TradeItemTaxInformation[] $tradeItemTaxInformation
     * @return \StructType\LineItem
     */
    public function setTradeItemTaxInformation(array $tradeItemTaxInformation = array())
    {
        // validation for constraint: array
        if ('' !== ($tradeItemTaxInformationArrayErrorMessage = self::validateTradeItemTaxInformationForArrayConstraintsFromSetTradeItemTaxInformation($tradeItemTaxInformation))) {
            throw new \InvalidArgumentException($tradeItemTaxInformationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($tradeItemTaxInformation) && count($tradeItemTaxInformation) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($tradeItemTaxInformation)), __LINE__);
        }
        $this->tradeItemTaxInformation = $tradeItemTaxInformation;
        return $this;
    }
    /**
     * Add item to tradeItemTaxInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\TradeItemTaxInformation $item
     * @return \StructType\LineItem
     */
    public function addToTradeItemTaxInformation(\StructType\TradeItemTaxInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TradeItemTaxInformation) {
            throw new \InvalidArgumentException(sprintf('The tradeItemTaxInformation property can only contain items of type \StructType\TradeItemTaxInformation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->tradeItemTaxInformation) && count($this->tradeItemTaxInformation) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->tradeItemTaxInformation)), __LINE__);
        }
        $this->tradeItemTaxInformation[] = $item;
        return $this;
    }
    /**
     * Get totalLineAmount value
     * @return \StructType\TotalLineAmount|null
     */
    public function getTotalLineAmount()
    {
        return $this->totalLineAmount;
    }
    /**
     * Set totalLineAmount value
     * @param \StructType\TotalLineAmount $totalLineAmount
     * @return \StructType\LineItem
     */
    public function setTotalLineAmount(\StructType\TotalLineAmount $totalLineAmount = null)
    {
        $this->totalLineAmount = $totalLineAmount;
        return $this;
    }
    /**
     * Get number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param int $number
     * @return \StructType\LineItem
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($number) && mb_strlen(mb_substr($number, false !== mb_strpos($number, '.') ? mb_strpos($number, '.') + 1 : mb_strlen($number))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($number, true), mb_strlen(mb_substr($number, mb_strpos($number, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($number) && mb_strlen(preg_replace('/(\D)/', '', $number)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($number, true), mb_strlen(preg_replace('/(\D)/', '', $number))), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\LineItem
     */
    public function setType($type = 'SimpleInvoiceLineItemType')
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($type) && mb_strlen($type) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($type)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($type) && mb_strlen($type) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
}
