<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for invoicedQuantity StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo requerido que especifica la cantidad facturada del producto en la línea de articulo actual
 * @subpackage Structs
 */
class InvoicedQuantity extends AbstractStructBase
{
    /**
     * The unitOfMeasure
     * Meta information extracted from the WSDL
     * - documentation: Atributo para especificar la unidad de medida, solo si el articulo es de unidad variable
     * - use: required
     * @var string
     */
    public $unitOfMeasure;
    /**
     * The _
     * @var float
     */
    public $_;
    /**
     * Constructor method for invoicedQuantity
     * @uses InvoicedQuantity::setUnitOfMeasure()
     * @uses InvoicedQuantity::set_()
     * @param string $unitOfMeasure
     * @param float $_
     */
    public function __construct($unitOfMeasure = null, $_ = null)
    {
        $this
            ->setUnitOfMeasure($unitOfMeasure)
            ->set_($_);
    }
    /**
     * Get unitOfMeasure value
     * @return string
     */
    public function getUnitOfMeasure()
    {
        return $this->unitOfMeasure;
    }
    /**
     * Set unitOfMeasure value
     * @param string $unitOfMeasure
     * @return \StructType\InvoicedQuantity
     */
    public function setUnitOfMeasure($unitOfMeasure = null)
    {
        // validation for constraint: string
        if (!is_null($unitOfMeasure) && !is_string($unitOfMeasure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitOfMeasure, true), gettype($unitOfMeasure)), __LINE__);
        }
        $this->unitOfMeasure = $unitOfMeasure;
        return $this;
    }
    /**
     * Get _ value
     * @return float|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param float $_
     * @return \StructType\InvoicedQuantity
     */
    public function set_($_ = null)
    {
        // validation for constraint: float
        if (!is_null($_) && !(is_float($_) || is_numeric($_))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
}
