<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceCreator StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo opcional que especifica la ubicación donde se especifica el identificador del emisor de la factura si es distinto del identificador del proveedor.
 * @subpackage Structs
 */
class InvoiceCreator extends AbstractStructBase
{
    /**
     * The gln
     * Meta information extracted from the WSDL
     * - documentation: Nodo requerido que especifica el número global de localización (GLN) del comprador. | Nodo requerido que especifica el número global de localización (GLN) del vendedor. | Nodo opcional que especifica el número global de
     * localización (GLN) de la ubicación a entregar la mercancía | Nodo opcional que especifica el número global de localización (GLN)de la ubicación del emisor de la factura | Nodo opcional que especifica el número global de localización (GLN) de
     * la aduana | SG2NAD 3039 CALIF BY | SG2NAD 3039 CALIF SU
     * - base: xs:string
     * - length: 13
     * - minOccurs: 0
     * @var string
     */
    public $gln;
    /**
     * The alternatePartyIdentification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AlternatePartyIdentification
     */
    public $alternatePartyIdentification;
    /**
     * The nameAndAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NameAndAddress
     */
    public $nameAndAddress;
    /**
     * Constructor method for InvoiceCreator
     * @uses InvoiceCreator::setGln()
     * @uses InvoiceCreator::setAlternatePartyIdentification()
     * @uses InvoiceCreator::setNameAndAddress()
     * @param string $gln
     * @param \StructType\AlternatePartyIdentification $alternatePartyIdentification
     * @param \StructType\NameAndAddress $nameAndAddress
     */
    public function __construct($gln = null, \StructType\AlternatePartyIdentification $alternatePartyIdentification = null, \StructType\NameAndAddress $nameAndAddress = null)
    {
        $this
            ->setGln($gln)
            ->setAlternatePartyIdentification($alternatePartyIdentification)
            ->setNameAndAddress($nameAndAddress);
    }
    /**
     * Get gln value
     * @return string|null
     */
    public function getGln()
    {
        return $this->gln;
    }
    /**
     * Set gln value
     * @param string $gln
     * @return \StructType\InvoiceCreator
     */
    public function setGln($gln = null)
    {
        // validation for constraint: string
        if (!is_null($gln) && !is_string($gln)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gln, true), gettype($gln)), __LINE__);
        }
        // validation for constraint: length(13)
        if (!is_null($gln) && mb_strlen($gln) !== 13) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 13', mb_strlen($gln)), __LINE__);
        }
        $this->gln = $gln;
        return $this;
    }
    /**
     * Get alternatePartyIdentification value
     * @return \StructType\AlternatePartyIdentification|null
     */
    public function getAlternatePartyIdentification()
    {
        return $this->alternatePartyIdentification;
    }
    /**
     * Set alternatePartyIdentification value
     * @param \StructType\AlternatePartyIdentification $alternatePartyIdentification
     * @return \StructType\InvoiceCreator
     */
    public function setAlternatePartyIdentification(\StructType\AlternatePartyIdentification $alternatePartyIdentification = null)
    {
        $this->alternatePartyIdentification = $alternatePartyIdentification;
        return $this;
    }
    /**
     * Get nameAndAddress value
     * @return \StructType\NameAndAddress|null
     */
    public function getNameAndAddress()
    {
        return $this->nameAndAddress;
    }
    /**
     * Set nameAndAddress value
     * @param \StructType\NameAndAddress $nameAndAddress
     * @return \StructType\InvoiceCreator
     */
    public function setNameAndAddress(\StructType\NameAndAddress $nameAndAddress = null)
    {
        $this->nameAndAddress = $nameAndAddress;
        return $this;
    }
}
