<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InformacionAduanera StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo opcional para introducir la información aduanera aplicable cuando se trate de ventas de primera mano de mercancías importadas. | Nodo opcional para introducir la información aduanera aplicable cuando se trate de ventas de
 * primera mano de mercancías importadas o se trate de operaciones de comercio exterior con bienes o servicios.
 * @subpackage Structs
 */
class InformacionAduanera extends T_InformacionAduanera
{
    /**
     * The NumeroPedimento
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - length: 21
     * - pattern: [0-9]{2}  [0-9]{2}  [0-9]{4}  [0-9]{7}
     * - use: required
     * @var string
     */
    public $NumeroPedimento;
    /**
     * Constructor method for InformacionAduanera
     * @uses InformacionAduanera::setNumeroPedimento()
     * @param string $numeroPedimento
     */
    public function __construct($numeroPedimento = null)
    {
        $this
            ->setNumeroPedimento($numeroPedimento);
    }
    /**
     * Get NumeroPedimento value
     * @return string
     */
    public function getNumeroPedimento()
    {
        return $this->NumeroPedimento;
    }
    /**
     * Set NumeroPedimento value
     * @param string $numeroPedimento
     * @return \StructType\InformacionAduanera
     */
    public function setNumeroPedimento($numeroPedimento = null)
    {
        // validation for constraint: string
        if (!is_null($numeroPedimento) && !is_string($numeroPedimento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroPedimento, true), gettype($numeroPedimento)), __LINE__);
        }
        // validation for constraint: length(21)
        if (!is_null($numeroPedimento) && mb_strlen($numeroPedimento) !== 21) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 21', mb_strlen($numeroPedimento)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}  [0-9]{2}  [0-9]{4}  [0-9]{7})
        if (!is_null($numeroPedimento) && !preg_match('/[0-9]{2}  [0-9]{2}  [0-9]{4}  [0-9]{7}/', $numeroPedimento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}  [0-9]{2}  [0-9]{4}  [0-9]{7}', var_export($numeroPedimento, true)), __LINE__);
        }
        $this->NumeroPedimento = $numeroPedimento;
        return $this;
    }
}
