<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Impuestos StructType
 * Meta information extracted from the WSDL
 * - documentation: Nodo requerido para capturar los impuestos aplicables. | Nodo condicional para expresar el resumen de los impuestos aplicables cuando este documento sea un anticipo. | Nodo condicional para expresar el resumen de los impuestos
 * aplicables. | Nodo opcional para capturar los impuestos aplicables al presente concepto. Cuando un concepto no registra un impuesto, implica que no es objeto del mismo.
 * @subpackage Structs
 */
class Impuestos extends AbstractStructBase
{
    /**
     * The Traslados
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Traslados
     */
    public $Traslados;
    /**
     * The Retenciones
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Retenciones
     */
    public $Retenciones;
    /**
     * The TotalImpuestosRetenidos
     * Meta information extracted from the WSDL
     * - documentation: Atributo condicional para expresar el total de los impuestos retenidos que se desprenden del pago. No se permiten valores negativos. | Atributo condicional para expresar el total de los impuestos retenidos que se desprenden de los
     * conceptos expresados en el comprobante fiscal digital por Internet. No se permiten valores negativos. Es requerido cuando en los conceptos se registren impuestos retenidos | Tipo definido para expresar importes numéricos con fracción hasta seis
     * decimales. El valor se redondea de acuerdo con el número de decimales que soporta la moneda. No se permiten valores negativos. | Tipo definido para expresar importes numéricos con fracción hasta seis decimales
     * - base: xs:decimal
     * - fractionDigits: 6
     * - minInclusive: 0.0
     * - pattern: [0-9]{1,18}(.[0-9]{1,6})?
     * - whiteSpace: collapse
     * @var float
     */
    public $TotalImpuestosRetenidos;
    /**
     * The TotalImpuestosTrasladados
     * Meta information extracted from the WSDL
     * - documentation: Atributo condicional para expresar el total de los impuestos trasladados que se desprenden del pago. No se permiten valores negativos. | Atributo condicional para expresar el total de los impuestos trasladados que se desprenden de
     * los conceptos expresados en el comprobante fiscal digital por Internet. No se permiten valores negativos. Es requerido cuando en los conceptos se registren impuestos trasladados. | Tipo definido para expresar importes numéricos con fracción hasta
     * seis decimales. El valor se redondea de acuerdo con el número de decimales que soporta la moneda. No se permiten valores negativos. | Tipo definido para expresar importes numéricos con fracción hasta seis decimales
     * - base: xs:decimal
     * - fractionDigits: 6
     * - minInclusive: 0.0
     * - pattern: [0-9]{1,18}(.[0-9]{1,6})?
     * - whiteSpace: collapse
     * @var float
     */
    public $TotalImpuestosTrasladados;
    /**
     * Constructor method for Impuestos
     * @uses Impuestos::setTraslados()
     * @uses Impuestos::setRetenciones()
     * @uses Impuestos::setTotalImpuestosRetenidos()
     * @uses Impuestos::setTotalImpuestosTrasladados()
     * @param \StructType\Traslados $traslados
     * @param \StructType\Retenciones $retenciones
     * @param float $totalImpuestosRetenidos
     * @param float $totalImpuestosTrasladados
     */
    public function __construct(\StructType\Traslados $traslados = null, \StructType\Retenciones $retenciones = null, $totalImpuestosRetenidos = null, $totalImpuestosTrasladados = null)
    {
        $this
            ->setTraslados($traslados)
            ->setRetenciones($retenciones)
            ->setTotalImpuestosRetenidos($totalImpuestosRetenidos)
            ->setTotalImpuestosTrasladados($totalImpuestosTrasladados);
    }
    /**
     * Get Traslados value
     * @return \StructType\Traslados|null
     */
    public function getTraslados()
    {
        return $this->Traslados;
    }
    /**
     * Set Traslados value
     * @param \StructType\Traslados $traslados
     * @return \StructType\Impuestos
     */
    public function setTraslados(\StructType\Traslados $traslados = null)
    {
        $this->Traslados = $traslados;
        return $this;
    }
    /**
     * Get Retenciones value
     * @return \StructType\Retenciones|null
     */
    public function getRetenciones()
    {
        return $this->Retenciones;
    }
    /**
     * Set Retenciones value
     * @param \StructType\Retenciones $retenciones
     * @return \StructType\Impuestos
     */
    public function setRetenciones(\StructType\Retenciones $retenciones = null)
    {
        $this->Retenciones = $retenciones;
        return $this;
    }
    /**
     * Get TotalImpuestosRetenidos value
     * @return float|null
     */
    public function getTotalImpuestosRetenidos()
    {
        return $this->TotalImpuestosRetenidos;
    }
    /**
     * Set TotalImpuestosRetenidos value
     * @param float $totalImpuestosRetenidos
     * @return \StructType\Impuestos
     */
    public function setTotalImpuestosRetenidos($totalImpuestosRetenidos = null)
    {
        // validation for constraint: float
        if (!is_null($totalImpuestosRetenidos) && !(is_float($totalImpuestosRetenidos) || is_numeric($totalImpuestosRetenidos))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalImpuestosRetenidos, true), gettype($totalImpuestosRetenidos)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($totalImpuestosRetenidos) && mb_strlen(mb_substr($totalImpuestosRetenidos, false !== mb_strpos($totalImpuestosRetenidos, '.') ? mb_strpos($totalImpuestosRetenidos, '.') + 1 : mb_strlen($totalImpuestosRetenidos))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($totalImpuestosRetenidos, true), mb_strlen(mb_substr($totalImpuestosRetenidos, mb_strpos($totalImpuestosRetenidos, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($totalImpuestosRetenidos) && $totalImpuestosRetenidos < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($totalImpuestosRetenidos, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,18}(.[0-9]{1,6})?)
        if (!is_null($totalImpuestosRetenidos) && !preg_match('/[0-9]{1,18}(.[0-9]{1,6})?/', $totalImpuestosRetenidos)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,18}(.[0-9]{1,6})?', var_export($totalImpuestosRetenidos, true)), __LINE__);
        }
        $this->TotalImpuestosRetenidos = $totalImpuestosRetenidos;
        return $this;
    }
    /**
     * Get TotalImpuestosTrasladados value
     * @return float|null
     */
    public function getTotalImpuestosTrasladados()
    {
        return $this->TotalImpuestosTrasladados;
    }
    /**
     * Set TotalImpuestosTrasladados value
     * @param float $totalImpuestosTrasladados
     * @return \StructType\Impuestos
     */
    public function setTotalImpuestosTrasladados($totalImpuestosTrasladados = null)
    {
        // validation for constraint: float
        if (!is_null($totalImpuestosTrasladados) && !(is_float($totalImpuestosTrasladados) || is_numeric($totalImpuestosTrasladados))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalImpuestosTrasladados, true), gettype($totalImpuestosTrasladados)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($totalImpuestosTrasladados) && mb_strlen(mb_substr($totalImpuestosTrasladados, false !== mb_strpos($totalImpuestosTrasladados, '.') ? mb_strpos($totalImpuestosTrasladados, '.') + 1 : mb_strlen($totalImpuestosTrasladados))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($totalImpuestosTrasladados, true), mb_strlen(mb_substr($totalImpuestosTrasladados, mb_strpos($totalImpuestosTrasladados, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($totalImpuestosTrasladados) && $totalImpuestosTrasladados < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($totalImpuestosTrasladados, true)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,18}(.[0-9]{1,6})?)
        if (!is_null($totalImpuestosTrasladados) && !preg_match('/[0-9]{1,18}(.[0-9]{1,6})?/', $totalImpuestosTrasladados)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,18}(.[0-9]{1,6})?', var_export($totalImpuestosTrasladados, true)), __LINE__);
        }
        $this->TotalImpuestosTrasladados = $totalImpuestosTrasladados;
        return $this;
    }
}
