<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HEADER StructType
 * @subpackage Structs
 */
class HEADER extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $ID;
    /**
     * The DOCUMENT_TYPE
     * @var string
     */
    public $DOCUMENT_TYPE;
    /**
     * The HEB_RFC
     * @var string
     */
    public $HEB_RFC;
    /**
     * The VENDOR_NUMBER
     * @var int
     */
    public $VENDOR_NUMBER;
    /**
     * The VENDOR_RFC
     * @var string
     */
    public $VENDOR_RFC;
    /**
     * The DETAIL_NUMBER_OF_LINES
     * @var int
     */
    public $DETAIL_NUMBER_OF_LINES;
    /**
     * The RECEIPT_NUMBER
     * @var string
     */
    public $RECEIPT_NUMBER;
    /**
     * The SUBSIDIARY_GLN
     * @var string
     */
    public $SUBSIDIARY_GLN;
    /**
     * The SUBSIDIARY
     * @var int
     */
    public $SUBSIDIARY;
    /**
     * The SUBSIDIARY_DESC
     * @var string
     */
    public $SUBSIDIARY_DESC;
    /**
     * The SUBSIDIARY_ADDRESS
     * @var string
     */
    public $SUBSIDIARY_ADDRESS;
    /**
     * The SUBSIDIARY_CITY
     * @var string
     */
    public $SUBSIDIARY_CITY;
    /**
     * The VENDOR
     * @var string
     */
    public $VENDOR;
    /**
     * The OPERATION_DATE
     * @var string
     */
    public $OPERATION_DATE;
    /**
     * The PLATES
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PLATES;
    /**
     * The RECEIPT_DATE
     * @var string
     */
    public $RECEIPT_DATE;
    /**
     * The DEPARTMENT_ID
     * @var int
     */
    public $DEPARTMENT_ID;
    /**
     * The DEPARTMENT
     * @var string
     */
    public $DEPARTMENT;
    /**
     * The PURCHASE_ORDER
     * @var int
     */
    public $PURCHASE_ORDER;
    /**
     * The DRIVER_NAME
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DRIVER_NAME;
    /**
     * The TOTAL
     * @var float
     */
    public $TOTAL;
    /**
     * The QUANTITY
     * @var int
     */
    public $QUANTITY;
    /**
     * The SUBTOTAL
     * @var float
     */
    public $SUBTOTAL;
    /**
     * The IVA
     * @var float
     */
    public $IVA;
    /**
     * The IEPS
     * @var float
     */
    public $IEPS;
    /**
     * The ORIGINAL
     * @var string
     */
    public $ORIGINAL;
    /**
     * The INVOICE_NUMBER
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $INVOICE_NUMBER;
    /**
     * The PURCHASE_DATE
     * @var string
     */
    public $PURCHASE_DATE;
    /**
     * The TOTAL_ITEMS
     * @var int
     */
    public $TOTAL_ITEMS;
    /**
     * The CONFIRMED_BY
     * @var string
     */
    public $CONFIRMED_BY;
    /**
     * The RECEIPT_BY
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RECEIPT_BY;
    /**
     * The MISSING_NUMBER
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MISSING_NUMBER;
    /**
     * The TOTAL_MISSING
     * @var int
     */
    public $TOTAL_MISSING;
    /**
     * The TOTAL_VENDOR_INVOICE
     * @var float
     */
    public $TOTAL_VENDOR_INVOICE;
    /**
     * The TOTAL_VALUED
     * @var float
     */
    public $TOTAL_VALUED;
    /**
     * The TOTAL_DIFFERENCE
     * @var float
     */
    public $TOTAL_DIFFERENCE;
    /**
     * The GROSS_AMOUNT
     * @var float
     */
    public $GROSS_AMOUNT;
    /**
     * The ENTIRE_AMOUNT
     * @var float
     */
    public $ENTIRE_AMOUNT;
    /**
     * The IVA_AMOUNT
     * @var float
     */
    public $IVA_AMOUNT;
    /**
     * The IEPS_AMOUNT
     * @var float
     */
    public $IEPS_AMOUNT;
    /**
     * The ESTIMATED_TOTAL
     * @var float
     */
    public $ESTIMATED_TOTAL;
    /**
     * The RELATED_BILLS
     * @var string
     */
    public $RELATED_BILLS;
    /**
     * The CURRENCY
     * @var string
     */
    public $CURRENCY;
    /**
     * The STATUS
     * @var int
     */
    public $STATUS;
    /**
     * Constructor method for HEADER
     * @uses HEADER::setID()
     * @uses HEADER::setDOCUMENT_TYPE()
     * @uses HEADER::setHEB_RFC()
     * @uses HEADER::setVENDOR_NUMBER()
     * @uses HEADER::setVENDOR_RFC()
     * @uses HEADER::setDETAIL_NUMBER_OF_LINES()
     * @uses HEADER::setRECEIPT_NUMBER()
     * @uses HEADER::setSUBSIDIARY_GLN()
     * @uses HEADER::setSUBSIDIARY()
     * @uses HEADER::setSUBSIDIARY_DESC()
     * @uses HEADER::setSUBSIDIARY_ADDRESS()
     * @uses HEADER::setSUBSIDIARY_CITY()
     * @uses HEADER::setVENDOR()
     * @uses HEADER::setOPERATION_DATE()
     * @uses HEADER::setPLATES()
     * @uses HEADER::setRECEIPT_DATE()
     * @uses HEADER::setDEPARTMENT_ID()
     * @uses HEADER::setDEPARTMENT()
     * @uses HEADER::setPURCHASE_ORDER()
     * @uses HEADER::setDRIVER_NAME()
     * @uses HEADER::setTOTAL()
     * @uses HEADER::setQUANTITY()
     * @uses HEADER::setSUBTOTAL()
     * @uses HEADER::setIVA()
     * @uses HEADER::setIEPS()
     * @uses HEADER::setORIGINAL()
     * @uses HEADER::setINVOICE_NUMBER()
     * @uses HEADER::setPURCHASE_DATE()
     * @uses HEADER::setTOTAL_ITEMS()
     * @uses HEADER::setCONFIRMED_BY()
     * @uses HEADER::setRECEIPT_BY()
     * @uses HEADER::setMISSING_NUMBER()
     * @uses HEADER::setTOTAL_MISSING()
     * @uses HEADER::setTOTAL_VENDOR_INVOICE()
     * @uses HEADER::setTOTAL_VALUED()
     * @uses HEADER::setTOTAL_DIFFERENCE()
     * @uses HEADER::setGROSS_AMOUNT()
     * @uses HEADER::setENTIRE_AMOUNT()
     * @uses HEADER::setIVA_AMOUNT()
     * @uses HEADER::setIEPS_AMOUNT()
     * @uses HEADER::setESTIMATED_TOTAL()
     * @uses HEADER::setRELATED_BILLS()
     * @uses HEADER::setCURRENCY()
     * @uses HEADER::setSTATUS()
     * @param int $iD
     * @param string $dOCUMENT_TYPE
     * @param string $hEB_RFC
     * @param int $vENDOR_NUMBER
     * @param string $vENDOR_RFC
     * @param int $dETAIL_NUMBER_OF_LINES
     * @param string $rECEIPT_NUMBER
     * @param string $sUBSIDIARY_GLN
     * @param int $sUBSIDIARY
     * @param string $sUBSIDIARY_DESC
     * @param string $sUBSIDIARY_ADDRESS
     * @param string $sUBSIDIARY_CITY
     * @param string $vENDOR
     * @param string $oPERATION_DATE
     * @param string $pLATES
     * @param string $rECEIPT_DATE
     * @param int $dEPARTMENT_ID
     * @param string $dEPARTMENT
     * @param int $pURCHASE_ORDER
     * @param string $dRIVER_NAME
     * @param float $tOTAL
     * @param int $qUANTITY
     * @param float $sUBTOTAL
     * @param float $iVA
     * @param float $iEPS
     * @param string $oRIGINAL
     * @param string $iNVOICE_NUMBER
     * @param string $pURCHASE_DATE
     * @param int $tOTAL_ITEMS
     * @param string $cONFIRMED_BY
     * @param string $rECEIPT_BY
     * @param int $mISSING_NUMBER
     * @param int $tOTAL_MISSING
     * @param float $tOTAL_VENDOR_INVOICE
     * @param float $tOTAL_VALUED
     * @param float $tOTAL_DIFFERENCE
     * @param float $gROSS_AMOUNT
     * @param float $eNTIRE_AMOUNT
     * @param float $iVA_AMOUNT
     * @param float $iEPS_AMOUNT
     * @param float $eSTIMATED_TOTAL
     * @param string $rELATED_BILLS
     * @param string $cURRENCY
     * @param int $sTATUS
     */
    public function __construct($iD = null, $dOCUMENT_TYPE = null, $hEB_RFC = null, $vENDOR_NUMBER = null, $vENDOR_RFC = null, $dETAIL_NUMBER_OF_LINES = null, $rECEIPT_NUMBER = null, $sUBSIDIARY_GLN = null, $sUBSIDIARY = null, $sUBSIDIARY_DESC = null, $sUBSIDIARY_ADDRESS = null, $sUBSIDIARY_CITY = null, $vENDOR = null, $oPERATION_DATE = null, $pLATES = null, $rECEIPT_DATE = null, $dEPARTMENT_ID = null, $dEPARTMENT = null, $pURCHASE_ORDER = null, $dRIVER_NAME = null, $tOTAL = null, $qUANTITY = null, $sUBTOTAL = null, $iVA = null, $iEPS = null, $oRIGINAL = null, $iNVOICE_NUMBER = null, $pURCHASE_DATE = null, $tOTAL_ITEMS = null, $cONFIRMED_BY = null, $rECEIPT_BY = null, $mISSING_NUMBER = null, $tOTAL_MISSING = null, $tOTAL_VENDOR_INVOICE = null, $tOTAL_VALUED = null, $tOTAL_DIFFERENCE = null, $gROSS_AMOUNT = null, $eNTIRE_AMOUNT = null, $iVA_AMOUNT = null, $iEPS_AMOUNT = null, $eSTIMATED_TOTAL = null, $rELATED_BILLS = null, $cURRENCY = null, $sTATUS = null)
    {
        $this
            ->setID($iD)
            ->setDOCUMENT_TYPE($dOCUMENT_TYPE)
            ->setHEB_RFC($hEB_RFC)
            ->setVENDOR_NUMBER($vENDOR_NUMBER)
            ->setVENDOR_RFC($vENDOR_RFC)
            ->setDETAIL_NUMBER_OF_LINES($dETAIL_NUMBER_OF_LINES)
            ->setRECEIPT_NUMBER($rECEIPT_NUMBER)
            ->setSUBSIDIARY_GLN($sUBSIDIARY_GLN)
            ->setSUBSIDIARY($sUBSIDIARY)
            ->setSUBSIDIARY_DESC($sUBSIDIARY_DESC)
            ->setSUBSIDIARY_ADDRESS($sUBSIDIARY_ADDRESS)
            ->setSUBSIDIARY_CITY($sUBSIDIARY_CITY)
            ->setVENDOR($vENDOR)
            ->setOPERATION_DATE($oPERATION_DATE)
            ->setPLATES($pLATES)
            ->setRECEIPT_DATE($rECEIPT_DATE)
            ->setDEPARTMENT_ID($dEPARTMENT_ID)
            ->setDEPARTMENT($dEPARTMENT)
            ->setPURCHASE_ORDER($pURCHASE_ORDER)
            ->setDRIVER_NAME($dRIVER_NAME)
            ->setTOTAL($tOTAL)
            ->setQUANTITY($qUANTITY)
            ->setSUBTOTAL($sUBTOTAL)
            ->setIVA($iVA)
            ->setIEPS($iEPS)
            ->setORIGINAL($oRIGINAL)
            ->setINVOICE_NUMBER($iNVOICE_NUMBER)
            ->setPURCHASE_DATE($pURCHASE_DATE)
            ->setTOTAL_ITEMS($tOTAL_ITEMS)
            ->setCONFIRMED_BY($cONFIRMED_BY)
            ->setRECEIPT_BY($rECEIPT_BY)
            ->setMISSING_NUMBER($mISSING_NUMBER)
            ->setTOTAL_MISSING($tOTAL_MISSING)
            ->setTOTAL_VENDOR_INVOICE($tOTAL_VENDOR_INVOICE)
            ->setTOTAL_VALUED($tOTAL_VALUED)
            ->setTOTAL_DIFFERENCE($tOTAL_DIFFERENCE)
            ->setGROSS_AMOUNT($gROSS_AMOUNT)
            ->setENTIRE_AMOUNT($eNTIRE_AMOUNT)
            ->setIVA_AMOUNT($iVA_AMOUNT)
            ->setIEPS_AMOUNT($iEPS_AMOUNT)
            ->setESTIMATED_TOTAL($eSTIMATED_TOTAL)
            ->setRELATED_BILLS($rELATED_BILLS)
            ->setCURRENCY($cURRENCY)
            ->setSTATUS($sTATUS);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\HEADER
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get DOCUMENT_TYPE value
     * @return string|null
     */
    public function getDOCUMENT_TYPE()
    {
        return $this->DOCUMENT_TYPE;
    }
    /**
     * Set DOCUMENT_TYPE value
     * @param string $dOCUMENT_TYPE
     * @return \StructType\HEADER
     */
    public function setDOCUMENT_TYPE($dOCUMENT_TYPE = null)
    {
        // validation for constraint: string
        if (!is_null($dOCUMENT_TYPE) && !is_string($dOCUMENT_TYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dOCUMENT_TYPE, true), gettype($dOCUMENT_TYPE)), __LINE__);
        }
        $this->DOCUMENT_TYPE = $dOCUMENT_TYPE;
        return $this;
    }
    /**
     * Get HEB_RFC value
     * @return string|null
     */
    public function getHEB_RFC()
    {
        return $this->HEB_RFC;
    }
    /**
     * Set HEB_RFC value
     * @param string $hEB_RFC
     * @return \StructType\HEADER
     */
    public function setHEB_RFC($hEB_RFC = null)
    {
        // validation for constraint: string
        if (!is_null($hEB_RFC) && !is_string($hEB_RFC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hEB_RFC, true), gettype($hEB_RFC)), __LINE__);
        }
        $this->HEB_RFC = $hEB_RFC;
        return $this;
    }
    /**
     * Get VENDOR_NUMBER value
     * @return int|null
     */
    public function getVENDOR_NUMBER()
    {
        return $this->VENDOR_NUMBER;
    }
    /**
     * Set VENDOR_NUMBER value
     * @param int $vENDOR_NUMBER
     * @return \StructType\HEADER
     */
    public function setVENDOR_NUMBER($vENDOR_NUMBER = null)
    {
        // validation for constraint: int
        if (!is_null($vENDOR_NUMBER) && !(is_int($vENDOR_NUMBER) || ctype_digit($vENDOR_NUMBER))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vENDOR_NUMBER, true), gettype($vENDOR_NUMBER)), __LINE__);
        }
        $this->VENDOR_NUMBER = $vENDOR_NUMBER;
        return $this;
    }
    /**
     * Get VENDOR_RFC value
     * @return string|null
     */
    public function getVENDOR_RFC()
    {
        return $this->VENDOR_RFC;
    }
    /**
     * Set VENDOR_RFC value
     * @param string $vENDOR_RFC
     * @return \StructType\HEADER
     */
    public function setVENDOR_RFC($vENDOR_RFC = null)
    {
        // validation for constraint: string
        if (!is_null($vENDOR_RFC) && !is_string($vENDOR_RFC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vENDOR_RFC, true), gettype($vENDOR_RFC)), __LINE__);
        }
        $this->VENDOR_RFC = $vENDOR_RFC;
        return $this;
    }
    /**
     * Get DETAIL_NUMBER_OF_LINES value
     * @return int|null
     */
    public function getDETAIL_NUMBER_OF_LINES()
    {
        return $this->DETAIL_NUMBER_OF_LINES;
    }
    /**
     * Set DETAIL_NUMBER_OF_LINES value
     * @param int $dETAIL_NUMBER_OF_LINES
     * @return \StructType\HEADER
     */
    public function setDETAIL_NUMBER_OF_LINES($dETAIL_NUMBER_OF_LINES = null)
    {
        // validation for constraint: int
        if (!is_null($dETAIL_NUMBER_OF_LINES) && !(is_int($dETAIL_NUMBER_OF_LINES) || ctype_digit($dETAIL_NUMBER_OF_LINES))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dETAIL_NUMBER_OF_LINES, true), gettype($dETAIL_NUMBER_OF_LINES)), __LINE__);
        }
        $this->DETAIL_NUMBER_OF_LINES = $dETAIL_NUMBER_OF_LINES;
        return $this;
    }
    /**
     * Get RECEIPT_NUMBER value
     * @return string|null
     */
    public function getRECEIPT_NUMBER()
    {
        return $this->RECEIPT_NUMBER;
    }
    /**
     * Set RECEIPT_NUMBER value
     * @param string $rECEIPT_NUMBER
     * @return \StructType\HEADER
     */
    public function setRECEIPT_NUMBER($rECEIPT_NUMBER = null)
    {
        // validation for constraint: string
        if (!is_null($rECEIPT_NUMBER) && !is_string($rECEIPT_NUMBER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rECEIPT_NUMBER, true), gettype($rECEIPT_NUMBER)), __LINE__);
        }
        $this->RECEIPT_NUMBER = $rECEIPT_NUMBER;
        return $this;
    }
    /**
     * Get SUBSIDIARY_GLN value
     * @return string|null
     */
    public function getSUBSIDIARY_GLN()
    {
        return $this->SUBSIDIARY_GLN;
    }
    /**
     * Set SUBSIDIARY_GLN value
     * @param string $sUBSIDIARY_GLN
     * @return \StructType\HEADER
     */
    public function setSUBSIDIARY_GLN($sUBSIDIARY_GLN = null)
    {
        // validation for constraint: string
        if (!is_null($sUBSIDIARY_GLN) && !is_string($sUBSIDIARY_GLN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUBSIDIARY_GLN, true), gettype($sUBSIDIARY_GLN)), __LINE__);
        }
        $this->SUBSIDIARY_GLN = $sUBSIDIARY_GLN;
        return $this;
    }
    /**
     * Get SUBSIDIARY value
     * @return int|null
     */
    public function getSUBSIDIARY()
    {
        return $this->SUBSIDIARY;
    }
    /**
     * Set SUBSIDIARY value
     * @param int $sUBSIDIARY
     * @return \StructType\HEADER
     */
    public function setSUBSIDIARY($sUBSIDIARY = null)
    {
        // validation for constraint: int
        if (!is_null($sUBSIDIARY) && !(is_int($sUBSIDIARY) || ctype_digit($sUBSIDIARY))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sUBSIDIARY, true), gettype($sUBSIDIARY)), __LINE__);
        }
        $this->SUBSIDIARY = $sUBSIDIARY;
        return $this;
    }
    /**
     * Get SUBSIDIARY_DESC value
     * @return string|null
     */
    public function getSUBSIDIARY_DESC()
    {
        return $this->SUBSIDIARY_DESC;
    }
    /**
     * Set SUBSIDIARY_DESC value
     * @param string $sUBSIDIARY_DESC
     * @return \StructType\HEADER
     */
    public function setSUBSIDIARY_DESC($sUBSIDIARY_DESC = null)
    {
        // validation for constraint: string
        if (!is_null($sUBSIDIARY_DESC) && !is_string($sUBSIDIARY_DESC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUBSIDIARY_DESC, true), gettype($sUBSIDIARY_DESC)), __LINE__);
        }
        $this->SUBSIDIARY_DESC = $sUBSIDIARY_DESC;
        return $this;
    }
    /**
     * Get SUBSIDIARY_ADDRESS value
     * @return string|null
     */
    public function getSUBSIDIARY_ADDRESS()
    {
        return $this->SUBSIDIARY_ADDRESS;
    }
    /**
     * Set SUBSIDIARY_ADDRESS value
     * @param string $sUBSIDIARY_ADDRESS
     * @return \StructType\HEADER
     */
    public function setSUBSIDIARY_ADDRESS($sUBSIDIARY_ADDRESS = null)
    {
        // validation for constraint: string
        if (!is_null($sUBSIDIARY_ADDRESS) && !is_string($sUBSIDIARY_ADDRESS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUBSIDIARY_ADDRESS, true), gettype($sUBSIDIARY_ADDRESS)), __LINE__);
        }
        $this->SUBSIDIARY_ADDRESS = $sUBSIDIARY_ADDRESS;
        return $this;
    }
    /**
     * Get SUBSIDIARY_CITY value
     * @return string|null
     */
    public function getSUBSIDIARY_CITY()
    {
        return $this->SUBSIDIARY_CITY;
    }
    /**
     * Set SUBSIDIARY_CITY value
     * @param string $sUBSIDIARY_CITY
     * @return \StructType\HEADER
     */
    public function setSUBSIDIARY_CITY($sUBSIDIARY_CITY = null)
    {
        // validation for constraint: string
        if (!is_null($sUBSIDIARY_CITY) && !is_string($sUBSIDIARY_CITY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUBSIDIARY_CITY, true), gettype($sUBSIDIARY_CITY)), __LINE__);
        }
        $this->SUBSIDIARY_CITY = $sUBSIDIARY_CITY;
        return $this;
    }
    /**
     * Get VENDOR value
     * @return string|null
     */
    public function getVENDOR()
    {
        return $this->VENDOR;
    }
    /**
     * Set VENDOR value
     * @param string $vENDOR
     * @return \StructType\HEADER
     */
    public function setVENDOR($vENDOR = null)
    {
        // validation for constraint: string
        if (!is_null($vENDOR) && !is_string($vENDOR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vENDOR, true), gettype($vENDOR)), __LINE__);
        }
        $this->VENDOR = $vENDOR;
        return $this;
    }
    /**
     * Get OPERATION_DATE value
     * @return string|null
     */
    public function getOPERATION_DATE()
    {
        return $this->OPERATION_DATE;
    }
    /**
     * Set OPERATION_DATE value
     * @param string $oPERATION_DATE
     * @return \StructType\HEADER
     */
    public function setOPERATION_DATE($oPERATION_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($oPERATION_DATE) && !is_string($oPERATION_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oPERATION_DATE, true), gettype($oPERATION_DATE)), __LINE__);
        }
        $this->OPERATION_DATE = $oPERATION_DATE;
        return $this;
    }
    /**
     * Get PLATES value
     * @return string|null
     */
    public function getPLATES()
    {
        return $this->PLATES;
    }
    /**
     * Set PLATES value
     * @param string $pLATES
     * @return \StructType\HEADER
     */
    public function setPLATES($pLATES = null)
    {
        // validation for constraint: string
        if (!is_null($pLATES) && !is_string($pLATES)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pLATES, true), gettype($pLATES)), __LINE__);
        }
        $this->PLATES = $pLATES;
        return $this;
    }
    /**
     * Get RECEIPT_DATE value
     * @return string|null
     */
    public function getRECEIPT_DATE()
    {
        return $this->RECEIPT_DATE;
    }
    /**
     * Set RECEIPT_DATE value
     * @param string $rECEIPT_DATE
     * @return \StructType\HEADER
     */
    public function setRECEIPT_DATE($rECEIPT_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($rECEIPT_DATE) && !is_string($rECEIPT_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rECEIPT_DATE, true), gettype($rECEIPT_DATE)), __LINE__);
        }
        $this->RECEIPT_DATE = $rECEIPT_DATE;
        return $this;
    }
    /**
     * Get DEPARTMENT_ID value
     * @return int|null
     */
    public function getDEPARTMENT_ID()
    {
        return $this->DEPARTMENT_ID;
    }
    /**
     * Set DEPARTMENT_ID value
     * @param int $dEPARTMENT_ID
     * @return \StructType\HEADER
     */
    public function setDEPARTMENT_ID($dEPARTMENT_ID = null)
    {
        // validation for constraint: int
        if (!is_null($dEPARTMENT_ID) && !(is_int($dEPARTMENT_ID) || ctype_digit($dEPARTMENT_ID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dEPARTMENT_ID, true), gettype($dEPARTMENT_ID)), __LINE__);
        }
        $this->DEPARTMENT_ID = $dEPARTMENT_ID;
        return $this;
    }
    /**
     * Get DEPARTMENT value
     * @return string|null
     */
    public function getDEPARTMENT()
    {
        return $this->DEPARTMENT;
    }
    /**
     * Set DEPARTMENT value
     * @param string $dEPARTMENT
     * @return \StructType\HEADER
     */
    public function setDEPARTMENT($dEPARTMENT = null)
    {
        // validation for constraint: string
        if (!is_null($dEPARTMENT) && !is_string($dEPARTMENT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dEPARTMENT, true), gettype($dEPARTMENT)), __LINE__);
        }
        $this->DEPARTMENT = $dEPARTMENT;
        return $this;
    }
    /**
     * Get PURCHASE_ORDER value
     * @return int|null
     */
    public function getPURCHASE_ORDER()
    {
        return $this->PURCHASE_ORDER;
    }
    /**
     * Set PURCHASE_ORDER value
     * @param int $pURCHASE_ORDER
     * @return \StructType\HEADER
     */
    public function setPURCHASE_ORDER($pURCHASE_ORDER = null)
    {
        // validation for constraint: int
        if (!is_null($pURCHASE_ORDER) && !(is_int($pURCHASE_ORDER) || ctype_digit($pURCHASE_ORDER))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pURCHASE_ORDER, true), gettype($pURCHASE_ORDER)), __LINE__);
        }
        $this->PURCHASE_ORDER = $pURCHASE_ORDER;
        return $this;
    }
    /**
     * Get DRIVER_NAME value
     * @return string|null
     */
    public function getDRIVER_NAME()
    {
        return $this->DRIVER_NAME;
    }
    /**
     * Set DRIVER_NAME value
     * @param string $dRIVER_NAME
     * @return \StructType\HEADER
     */
    public function setDRIVER_NAME($dRIVER_NAME = null)
    {
        // validation for constraint: string
        if (!is_null($dRIVER_NAME) && !is_string($dRIVER_NAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dRIVER_NAME, true), gettype($dRIVER_NAME)), __LINE__);
        }
        $this->DRIVER_NAME = $dRIVER_NAME;
        return $this;
    }
    /**
     * Get TOTAL value
     * @return float|null
     */
    public function getTOTAL()
    {
        return $this->TOTAL;
    }
    /**
     * Set TOTAL value
     * @param float $tOTAL
     * @return \StructType\HEADER
     */
    public function setTOTAL($tOTAL = null)
    {
        // validation for constraint: float
        if (!is_null($tOTAL) && !(is_float($tOTAL) || is_numeric($tOTAL))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tOTAL, true), gettype($tOTAL)), __LINE__);
        }
        $this->TOTAL = $tOTAL;
        return $this;
    }
    /**
     * Get QUANTITY value
     * @return int|null
     */
    public function getQUANTITY()
    {
        return $this->QUANTITY;
    }
    /**
     * Set QUANTITY value
     * @param int $qUANTITY
     * @return \StructType\HEADER
     */
    public function setQUANTITY($qUANTITY = null)
    {
        // validation for constraint: int
        if (!is_null($qUANTITY) && !(is_int($qUANTITY) || ctype_digit($qUANTITY))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($qUANTITY, true), gettype($qUANTITY)), __LINE__);
        }
        $this->QUANTITY = $qUANTITY;
        return $this;
    }
    /**
     * Get SUBTOTAL value
     * @return float|null
     */
    public function getSUBTOTAL()
    {
        return $this->SUBTOTAL;
    }
    /**
     * Set SUBTOTAL value
     * @param float $sUBTOTAL
     * @return \StructType\HEADER
     */
    public function setSUBTOTAL($sUBTOTAL = null)
    {
        // validation for constraint: float
        if (!is_null($sUBTOTAL) && !(is_float($sUBTOTAL) || is_numeric($sUBTOTAL))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sUBTOTAL, true), gettype($sUBTOTAL)), __LINE__);
        }
        $this->SUBTOTAL = $sUBTOTAL;
        return $this;
    }
    /**
     * Get IVA value
     * @return float|null
     */
    public function getIVA()
    {
        return $this->IVA;
    }
    /**
     * Set IVA value
     * @param float $iVA
     * @return \StructType\HEADER
     */
    public function setIVA($iVA = null)
    {
        // validation for constraint: float
        if (!is_null($iVA) && !(is_float($iVA) || is_numeric($iVA))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($iVA, true), gettype($iVA)), __LINE__);
        }
        $this->IVA = $iVA;
        return $this;
    }
    /**
     * Get IEPS value
     * @return float|null
     */
    public function getIEPS()
    {
        return $this->IEPS;
    }
    /**
     * Set IEPS value
     * @param float $iEPS
     * @return \StructType\HEADER
     */
    public function setIEPS($iEPS = null)
    {
        // validation for constraint: float
        if (!is_null($iEPS) && !(is_float($iEPS) || is_numeric($iEPS))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($iEPS, true), gettype($iEPS)), __LINE__);
        }
        $this->IEPS = $iEPS;
        return $this;
    }
    /**
     * Get ORIGINAL value
     * @return string|null
     */
    public function getORIGINAL()
    {
        return $this->ORIGINAL;
    }
    /**
     * Set ORIGINAL value
     * @param string $oRIGINAL
     * @return \StructType\HEADER
     */
    public function setORIGINAL($oRIGINAL = null)
    {
        // validation for constraint: string
        if (!is_null($oRIGINAL) && !is_string($oRIGINAL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oRIGINAL, true), gettype($oRIGINAL)), __LINE__);
        }
        $this->ORIGINAL = $oRIGINAL;
        return $this;
    }
    /**
     * Get INVOICE_NUMBER value
     * @return string|null
     */
    public function getINVOICE_NUMBER()
    {
        return $this->INVOICE_NUMBER;
    }
    /**
     * Set INVOICE_NUMBER value
     * @param string $iNVOICE_NUMBER
     * @return \StructType\HEADER
     */
    public function setINVOICE_NUMBER($iNVOICE_NUMBER = null)
    {
        // validation for constraint: string
        if (!is_null($iNVOICE_NUMBER) && !is_string($iNVOICE_NUMBER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iNVOICE_NUMBER, true), gettype($iNVOICE_NUMBER)), __LINE__);
        }
        $this->INVOICE_NUMBER = $iNVOICE_NUMBER;
        return $this;
    }
    /**
     * Get PURCHASE_DATE value
     * @return string|null
     */
    public function getPURCHASE_DATE()
    {
        return $this->PURCHASE_DATE;
    }
    /**
     * Set PURCHASE_DATE value
     * @param string $pURCHASE_DATE
     * @return \StructType\HEADER
     */
    public function setPURCHASE_DATE($pURCHASE_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($pURCHASE_DATE) && !is_string($pURCHASE_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pURCHASE_DATE, true), gettype($pURCHASE_DATE)), __LINE__);
        }
        $this->PURCHASE_DATE = $pURCHASE_DATE;
        return $this;
    }
    /**
     * Get TOTAL_ITEMS value
     * @return int|null
     */
    public function getTOTAL_ITEMS()
    {
        return $this->TOTAL_ITEMS;
    }
    /**
     * Set TOTAL_ITEMS value
     * @param int $tOTAL_ITEMS
     * @return \StructType\HEADER
     */
    public function setTOTAL_ITEMS($tOTAL_ITEMS = null)
    {
        // validation for constraint: int
        if (!is_null($tOTAL_ITEMS) && !(is_int($tOTAL_ITEMS) || ctype_digit($tOTAL_ITEMS))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tOTAL_ITEMS, true), gettype($tOTAL_ITEMS)), __LINE__);
        }
        $this->TOTAL_ITEMS = $tOTAL_ITEMS;
        return $this;
    }
    /**
     * Get CONFIRMED_BY value
     * @return string|null
     */
    public function getCONFIRMED_BY()
    {
        return $this->CONFIRMED_BY;
    }
    /**
     * Set CONFIRMED_BY value
     * @param string $cONFIRMED_BY
     * @return \StructType\HEADER
     */
    public function setCONFIRMED_BY($cONFIRMED_BY = null)
    {
        // validation for constraint: string
        if (!is_null($cONFIRMED_BY) && !is_string($cONFIRMED_BY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cONFIRMED_BY, true), gettype($cONFIRMED_BY)), __LINE__);
        }
        $this->CONFIRMED_BY = $cONFIRMED_BY;
        return $this;
    }
    /**
     * Get RECEIPT_BY value
     * @return string|null
     */
    public function getRECEIPT_BY()
    {
        return $this->RECEIPT_BY;
    }
    /**
     * Set RECEIPT_BY value
     * @param string $rECEIPT_BY
     * @return \StructType\HEADER
     */
    public function setRECEIPT_BY($rECEIPT_BY = null)
    {
        // validation for constraint: string
        if (!is_null($rECEIPT_BY) && !is_string($rECEIPT_BY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rECEIPT_BY, true), gettype($rECEIPT_BY)), __LINE__);
        }
        $this->RECEIPT_BY = $rECEIPT_BY;
        return $this;
    }
    /**
     * Get MISSING_NUMBER value
     * @return int|null
     */
    public function getMISSING_NUMBER()
    {
        return $this->MISSING_NUMBER;
    }
    /**
     * Set MISSING_NUMBER value
     * @param int $mISSING_NUMBER
     * @return \StructType\HEADER
     */
    public function setMISSING_NUMBER($mISSING_NUMBER = null)
    {
        // validation for constraint: int
        if (!is_null($mISSING_NUMBER) && !(is_int($mISSING_NUMBER) || ctype_digit($mISSING_NUMBER))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mISSING_NUMBER, true), gettype($mISSING_NUMBER)), __LINE__);
        }
        $this->MISSING_NUMBER = $mISSING_NUMBER;
        return $this;
    }
    /**
     * Get TOTAL_MISSING value
     * @return int|null
     */
    public function getTOTAL_MISSING()
    {
        return $this->TOTAL_MISSING;
    }
    /**
     * Set TOTAL_MISSING value
     * @param int $tOTAL_MISSING
     * @return \StructType\HEADER
     */
    public function setTOTAL_MISSING($tOTAL_MISSING = null)
    {
        // validation for constraint: int
        if (!is_null($tOTAL_MISSING) && !(is_int($tOTAL_MISSING) || ctype_digit($tOTAL_MISSING))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tOTAL_MISSING, true), gettype($tOTAL_MISSING)), __LINE__);
        }
        $this->TOTAL_MISSING = $tOTAL_MISSING;
        return $this;
    }
    /**
     * Get TOTAL_VENDOR_INVOICE value
     * @return float|null
     */
    public function getTOTAL_VENDOR_INVOICE()
    {
        return $this->TOTAL_VENDOR_INVOICE;
    }
    /**
     * Set TOTAL_VENDOR_INVOICE value
     * @param float $tOTAL_VENDOR_INVOICE
     * @return \StructType\HEADER
     */
    public function setTOTAL_VENDOR_INVOICE($tOTAL_VENDOR_INVOICE = null)
    {
        // validation for constraint: float
        if (!is_null($tOTAL_VENDOR_INVOICE) && !(is_float($tOTAL_VENDOR_INVOICE) || is_numeric($tOTAL_VENDOR_INVOICE))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tOTAL_VENDOR_INVOICE, true), gettype($tOTAL_VENDOR_INVOICE)), __LINE__);
        }
        $this->TOTAL_VENDOR_INVOICE = $tOTAL_VENDOR_INVOICE;
        return $this;
    }
    /**
     * Get TOTAL_VALUED value
     * @return float|null
     */
    public function getTOTAL_VALUED()
    {
        return $this->TOTAL_VALUED;
    }
    /**
     * Set TOTAL_VALUED value
     * @param float $tOTAL_VALUED
     * @return \StructType\HEADER
     */
    public function setTOTAL_VALUED($tOTAL_VALUED = null)
    {
        // validation for constraint: float
        if (!is_null($tOTAL_VALUED) && !(is_float($tOTAL_VALUED) || is_numeric($tOTAL_VALUED))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tOTAL_VALUED, true), gettype($tOTAL_VALUED)), __LINE__);
        }
        $this->TOTAL_VALUED = $tOTAL_VALUED;
        return $this;
    }
    /**
     * Get TOTAL_DIFFERENCE value
     * @return float|null
     */
    public function getTOTAL_DIFFERENCE()
    {
        return $this->TOTAL_DIFFERENCE;
    }
    /**
     * Set TOTAL_DIFFERENCE value
     * @param float $tOTAL_DIFFERENCE
     * @return \StructType\HEADER
     */
    public function setTOTAL_DIFFERENCE($tOTAL_DIFFERENCE = null)
    {
        // validation for constraint: float
        if (!is_null($tOTAL_DIFFERENCE) && !(is_float($tOTAL_DIFFERENCE) || is_numeric($tOTAL_DIFFERENCE))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tOTAL_DIFFERENCE, true), gettype($tOTAL_DIFFERENCE)), __LINE__);
        }
        $this->TOTAL_DIFFERENCE = $tOTAL_DIFFERENCE;
        return $this;
    }
    /**
     * Get GROSS_AMOUNT value
     * @return float|null
     */
    public function getGROSS_AMOUNT()
    {
        return $this->GROSS_AMOUNT;
    }
    /**
     * Set GROSS_AMOUNT value
     * @param float $gROSS_AMOUNT
     * @return \StructType\HEADER
     */
    public function setGROSS_AMOUNT($gROSS_AMOUNT = null)
    {
        // validation for constraint: float
        if (!is_null($gROSS_AMOUNT) && !(is_float($gROSS_AMOUNT) || is_numeric($gROSS_AMOUNT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gROSS_AMOUNT, true), gettype($gROSS_AMOUNT)), __LINE__);
        }
        $this->GROSS_AMOUNT = $gROSS_AMOUNT;
        return $this;
    }
    /**
     * Get ENTIRE_AMOUNT value
     * @return float|null
     */
    public function getENTIRE_AMOUNT()
    {
        return $this->ENTIRE_AMOUNT;
    }
    /**
     * Set ENTIRE_AMOUNT value
     * @param float $eNTIRE_AMOUNT
     * @return \StructType\HEADER
     */
    public function setENTIRE_AMOUNT($eNTIRE_AMOUNT = null)
    {
        // validation for constraint: float
        if (!is_null($eNTIRE_AMOUNT) && !(is_float($eNTIRE_AMOUNT) || is_numeric($eNTIRE_AMOUNT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($eNTIRE_AMOUNT, true), gettype($eNTIRE_AMOUNT)), __LINE__);
        }
        $this->ENTIRE_AMOUNT = $eNTIRE_AMOUNT;
        return $this;
    }
    /**
     * Get IVA_AMOUNT value
     * @return float|null
     */
    public function getIVA_AMOUNT()
    {
        return $this->IVA_AMOUNT;
    }
    /**
     * Set IVA_AMOUNT value
     * @param float $iVA_AMOUNT
     * @return \StructType\HEADER
     */
    public function setIVA_AMOUNT($iVA_AMOUNT = null)
    {
        // validation for constraint: float
        if (!is_null($iVA_AMOUNT) && !(is_float($iVA_AMOUNT) || is_numeric($iVA_AMOUNT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($iVA_AMOUNT, true), gettype($iVA_AMOUNT)), __LINE__);
        }
        $this->IVA_AMOUNT = $iVA_AMOUNT;
        return $this;
    }
    /**
     * Get IEPS_AMOUNT value
     * @return float|null
     */
    public function getIEPS_AMOUNT()
    {
        return $this->IEPS_AMOUNT;
    }
    /**
     * Set IEPS_AMOUNT value
     * @param float $iEPS_AMOUNT
     * @return \StructType\HEADER
     */
    public function setIEPS_AMOUNT($iEPS_AMOUNT = null)
    {
        // validation for constraint: float
        if (!is_null($iEPS_AMOUNT) && !(is_float($iEPS_AMOUNT) || is_numeric($iEPS_AMOUNT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($iEPS_AMOUNT, true), gettype($iEPS_AMOUNT)), __LINE__);
        }
        $this->IEPS_AMOUNT = $iEPS_AMOUNT;
        return $this;
    }
    /**
     * Get ESTIMATED_TOTAL value
     * @return float|null
     */
    public function getESTIMATED_TOTAL()
    {
        return $this->ESTIMATED_TOTAL;
    }
    /**
     * Set ESTIMATED_TOTAL value
     * @param float $eSTIMATED_TOTAL
     * @return \StructType\HEADER
     */
    public function setESTIMATED_TOTAL($eSTIMATED_TOTAL = null)
    {
        // validation for constraint: float
        if (!is_null($eSTIMATED_TOTAL) && !(is_float($eSTIMATED_TOTAL) || is_numeric($eSTIMATED_TOTAL))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($eSTIMATED_TOTAL, true), gettype($eSTIMATED_TOTAL)), __LINE__);
        }
        $this->ESTIMATED_TOTAL = $eSTIMATED_TOTAL;
        return $this;
    }
    /**
     * Get RELATED_BILLS value
     * @return string|null
     */
    public function getRELATED_BILLS()
    {
        return $this->RELATED_BILLS;
    }
    /**
     * Set RELATED_BILLS value
     * @param string $rELATED_BILLS
     * @return \StructType\HEADER
     */
    public function setRELATED_BILLS($rELATED_BILLS = null)
    {
        // validation for constraint: string
        if (!is_null($rELATED_BILLS) && !is_string($rELATED_BILLS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rELATED_BILLS, true), gettype($rELATED_BILLS)), __LINE__);
        }
        $this->RELATED_BILLS = $rELATED_BILLS;
        return $this;
    }
    /**
     * Get CURRENCY value
     * @return string|null
     */
    public function getCURRENCY()
    {
        return $this->CURRENCY;
    }
    /**
     * Set CURRENCY value
     * @param string $cURRENCY
     * @return \StructType\HEADER
     */
    public function setCURRENCY($cURRENCY = null)
    {
        // validation for constraint: string
        if (!is_null($cURRENCY) && !is_string($cURRENCY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cURRENCY, true), gettype($cURRENCY)), __LINE__);
        }
        $this->CURRENCY = $cURRENCY;
        return $this;
    }
    /**
     * Get STATUS value
     * @return int|null
     */
    public function getSTATUS()
    {
        return $this->STATUS;
    }
    /**
     * Set STATUS value
     * @param int $sTATUS
     * @return \StructType\HEADER
     */
    public function setSTATUS($sTATUS = null)
    {
        // validation for constraint: int
        if (!is_null($sTATUS) && !(is_int($sTATUS) || ctype_digit($sTATUS))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sTATUS, true), gettype($sTATUS)), __LINE__);
        }
        $this->STATUS = $sTATUS;
        return $this;
    }
}
